/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.lakalapay.service;

import com.elitesland.scp.lakalapay.service.ISignManager;
import com.elitesland.scp.lakalapay.utils.RSA;
import com.elitesland.scp.lakalapay.utils.SignType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SignManager
implements ISignManager {
    protected String signType = SignType.RSA;
    protected String md5PrivateKey;
    protected String rsaPrivateKey;
    protected String hmacsha256PrivateKey;
    protected String inputCharset = "utf-8";
    protected String signName = "sign";
    protected String signTypeName = "sign_type";

    public String getSignType() {
        return this.signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getMd5PrivateKey() {
        return this.md5PrivateKey;
    }

    public void setMd5PrivateKey(String md5PrivateKey) {
        this.md5PrivateKey = md5PrivateKey;
    }

    public String getRsaPrivateKey() {
        return this.rsaPrivateKey;
    }

    public void setRsaPrivateKey(String rsaPrivateKey) {
        this.rsaPrivateKey = rsaPrivateKey;
    }

    public String getInputCharset() {
        return this.inputCharset;
    }

    public void setInputCharset(String inputCharset) {
        this.inputCharset = inputCharset;
    }

    public String getSignName() {
        return this.signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public String getSignTypeName() {
        return this.signTypeName;
    }

    public void setSignTypeName(String signTypeName) {
        this.signTypeName = signTypeName;
    }

    public String getHmacsha256PrivateKey() {
        return this.hmacsha256PrivateKey;
    }

    public void setHmacsha256PrivateKey(String hmacsha256PrivateKey) {
        this.hmacsha256PrivateKey = hmacsha256PrivateKey;
    }

    public Map<String, Object> buildRequestPara(Map<String, Object> sParaTemp) {
        Map<String, Object> sPara = this.paraFilter(sParaTemp);
        String mysign = this.buildRequestMysign(sPara);
        sPara.put(this.signName, mysign);
        sPara.put(this.signTypeName, this.signType);
        return sPara;
    }

    private String buildRequestMysign(Map<String, Object> sPara) {
        String prestr = this.createLinkString(sPara);
        String mysign = "";
        if (this.signType.equals(SignType.MD5)) {
            mysign = RSA.sign(prestr, this.md5PrivateKey, this.inputCharset);
        } else if (this.signType.equals(SignType.RSA)) {
            mysign = RSA.sign(prestr, this.rsaPrivateKey, this.inputCharset);
        } else if (this.signType.equals(SignType.HMACSHA256)) {
            mysign = RSA.getSignHmacSHA256(sPara, this.hmacsha256PrivateKey);
        }
        return mysign;
    }

    protected Map<String, Object> paraFilter(Map<String, Object> sArray) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (sArray != null && sArray.size() > 0) {
            for (String key : sArray.keySet()) {
                Object value = sArray.get(key);
                if (value == null || value.equals("") || key.equalsIgnoreCase(this.signName) || key.equalsIgnoreCase(this.signTypeName)) continue;
                result.put(key, value);
            }
            return result;
        }
        return result;
    }

    public String createLinkString(Map<String, Object> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        Object prestr = "";
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            Object value = params.get(key);
            prestr = i == keys.size() - 1 ? (String)prestr + key + "=" + value : (String)prestr + key + "=" + value + "&";
        }
        return prestr;
    }
}

