/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.mq;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.boh.StoreReceiveConfirmSendParam;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.infr.dto.boh.DemandOrderDtl;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepoProc;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class StoreReceiveConfirmListener
implements MessageQueueListener<StoreReceiveConfirmSendParam> {
    private static final Logger log = LoggerFactory.getLogger(StoreReceiveConfirmListener.class);
    private final StoreReceiveRepo storeReceiveRepo;
    private final StoreReceiveRepoProc storeReceiveRepoProc;
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;

    @NotEmpty
    public String[] channels() {
        return new String[]{"store_order_confirm"};
    }

    @Transactional(rollbackFor={Exception.class})
    public void onConsume(@NotBlank String s, @NotNull StoreReceiveConfirmSendParam storeReceiveSendParam) {
        log.info("\u95e8\u5e97\u6536\u9000\u8d27 \u786e\u8ba4\u56de\u5199\uff1a" + JSON.toJSONString((Object)storeReceiveSendParam));
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(storeReceiveSendParam.getDocId());
        if (CollectionUtil.isEmpty(receiveDOS)) {
            return;
        }
        List ceList = receiveDOS.stream().filter(i -> Objects.equals(i.getStatus(), "CE")).collect(Collectors.toList());
        if (ceList.isEmpty()) {
            return;
        }
        List<Long> orderDidList = storeReceiveSendParam.getItems().stream().map(i -> i.getOrderDid()).distinct().collect(Collectors.toList());
        List<DemandOrderDtl> orderDtl = this.storeReceiveRepoProc.findOrderDtl(orderDidList);
        Map<Long, BigDecimal> priceMap = orderDtl.stream().filter(i -> i.getPrice() != null).collect(Collectors.toMap(i -> i.getId(), i -> i.getPrice()));
        StoreReceiveDO thisDo = receiveDOS.get(0);
        thisDo.setStatus("CF");
        thisDo.setTotalRealQty(storeReceiveSendParam.getItems().stream().map(i -> i.getQty()).reduce(BigDecimal.ZERO, BigDecimal::add));
        BigDecimal totalRealAmt = BigDecimal.ZERO;
        for (Object item : storeReceiveSendParam.getItems()) {
            BigDecimal bigDecimal = priceMap.get(item.getOrderDid());
            if (bigDecimal == null) continue;
            totalRealAmt = totalRealAmt.add(item.getQty().multiply(bigDecimal));
        }
        thisDo.setRealAmt(totalRealAmt);
        if (thisDo.getRtType().equals("R")) {
            thisDo.setReceiveDate(storeReceiveSendParam.getConfirmTime());
        } else {
            thisDo.setRtnDate(storeReceiveSendParam.getConfirmTime());
        }
        this.storeReceiveRepo.save(thisDo);
        if ("T".equals(thisDo.getRtType())) {
            return;
        }
        log.info("\u8c03\u62e8\u5355\u66f4\u65b0\u8ba2\u8d27\u5355\u6536\u8d27\u6570\u91cf\uff1a{}", (Object)JSONUtil.toJsonStr((Object)storeReceiveSendParam.getItems()));
        Map<Long, BigDecimal> orderDidQtyMap = storeReceiveSendParam.getItems().stream().collect(Collectors.groupingBy(StoreReceiveConfirmSendParam.OrderItem::getOrderDid, Collectors.mapping(StoreReceiveConfirmSendParam.OrderItem::getQty, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        log.info("\u8c03\u62e8\u5355\u66f4\u65b0\u6536\u8d27\u6570\u91cf\u6570\u636e\uff1a{}", (Object)JSONUtil.toJsonStr(orderDidQtyMap));
        for (Map.Entry entry : orderDidQtyMap.entrySet()) {
            Long did = (Long)entry.getKey();
            BigDecimal qty = (BigDecimal)entry.getValue();
            this.scpDemandOrderDDomainService.updateRecvQty(did, qty);
        }
        List<Long> ids = storeReceiveSendParam.getItems().stream().map(StoreReceiveConfirmSendParam.OrderItem::getOrderDid).collect(Collectors.toList());
        List list = this.scpDemandOrderDDomainService.getMasIdByDId(ids).stream().distinct().collect(Collectors.toList());
        for (Long masId : list) {
            this.scpDemandOrderDomainService.updateDocStatusById(masId, "RECV");
        }
    }

    public StoreReceiveConfirmListener(StoreReceiveRepo storeReceiveRepo, StoreReceiveRepoProc storeReceiveRepoProc, ScpDemandOrderDomainService scpDemandOrderDomainService, ScpDemandOrderDDomainService scpDemandOrderDDomainService) {
        this.storeReceiveRepo = storeReceiveRepo;
        this.storeReceiveRepoProc = storeReceiveRepoProc;
        this.scpDemandOrderDomainService = scpDemandOrderDomainService;
        this.scpDemandOrderDDomainService = scpDemandOrderDDomainService;
    }
}

