package com.elitesland.scp.application.facade.vo.calendar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2024-04-01
* @Version 1.0
**/

@Data
@ApiModel(value = "ScpSuppDemandCalendarParamVO", description = "送货日历查询条件")
public class ScpSuppDemandCalendarParamVO implements Serializable {

    @ApiModelProperty(value = "供应商编码")
    @NotBlank(message = "供应商编码为空")
    private String suppCode;

    @ApiModelProperty(value = "类型")
    @NotBlank(message = "类型为空")
    private String type;

    @ApiModelProperty(value = "仓库编码/门店编码")
    @NotBlank(message = "仓库编码/门店编码为空")
    private String storeWhCode;

    @ApiModelProperty(value = "年")
    private String year;

    @ApiModelProperty(value = "月")
    private String month;






}