package com.elitesland.scp.application.service.mrp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpMrpDPageParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDExportRespVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;


@Component
@Slf4j
@RequiredArgsConstructor
public class ScpMrpExportServiceImpl implements DataExport<ScpMrpDExportRespVO, ScpMrpDPageParam> {

    private final ScpMrpDService scpMrpDService;

    @Override
    public String getTmplCode() {
        return "yst_scp_mrp_d_export";
    }

    @Override
    public PagingVO<ScpMrpDExportRespVO> executeExport(ScpMrpDPageParam param) {
        return scpMrpDService.queryExport(param);
    }
}
