package com.elitesland.scp.rmi;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.dto.PurPriceParamRpcDTO;
import com.elitesland.pur.dto.PurPurcPriceRpcDTO;
import com.elitesland.pur.dto.po.*;
import com.elitesland.pur.provider.PurPoDProvider;
import com.elitesland.pur.provider.PurPoProvider;
import com.elitesland.pur.provider.PurPriceProvider;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@Slf4j
@RequiredArgsConstructor
public class RmiPurRpcService {

    private final PurPriceProvider purPriceProvider;

    private final PurPoProvider purPoProvider;

    private final PurPoDProvider purPoDProvider;

    /**
     * 校验商品外采价格
     *
     * @param param
     * @return
     */
    public String checkItemPurPrice(List<PurPriceParamRpcDTO> param) {
        log.info("校验外采采购价格,{}", JSON.toJSONString(param));
        ApiResult<List<PurPurcPriceRpcDTO>> itemPurPrice = purPriceProvider.checkItemPurPrice(param);
        log.info("校验外采采购价格返回值:{}", JSON.toJSONString(itemPurPrice));
        if (!itemPurPrice.isSuccess()) {
            return itemPurPrice.getMsg();
        }
        return "";
    }


    public List<PurPoSaveDTO> createPo(List<PurPoSaveDTO> param) {
        log.info("创建采购订单,{}", JSON.toJSONString(param));
        List<PurPoSaveDTO> purResult = purPoProvider.createBatch(param).computeData();
        log.info("创建采购订单返回值:{}", JSON.toJSONString(purResult));
        return purResult;
    }

    public List<PurPoPayRpcDTO> payInfo(Long id) {
        ApiResult<List<PurPoPayRpcDTO>> payInfoByPoId = purPoProvider.findPayInfoByPoId(id);
        if (!payInfoByPoId.isSuccess()) {
            throw new BusinessException("查询采购订单支付信息异常:" + payInfoByPoId.getMsg());
        }
        return payInfoByPoId.getData();
    }

    public PurPoDTO findPurPoById(Long id) {
        List<PurPoDTO> poList = purPoProvider.findIdBatch(List.of(id));
        if (CollUtil.isEmpty(poList)) {
            throw new BusinessException("采购订单不存在");
        }
        return poList.get(0);
    }

    public List<PurPoDDTO> findPurPoDByPoId(Long poId) {
        List<PurPoDDTO> podList = purPoDProvider.findByMasIds(List.of(poId));
        if (CollUtil.isEmpty(podList)) {
            throw new BusinessException("采购订单明细不存在");
        }
        return podList;
    }

    public void updateOnlinePay(PurPoOnlinePayParamDTO payParamDTO) {
        try {
            purPoProvider.updateOnlinePay(payParamDTO);
        } catch (Exception e) {
            throw new BusinessException("更新在线支付信息异常");
        }
    }

    public PurPoOnlinePayRpcDTO findOnlinePayInfo(Long poId) {
        PurPoOnlinePayRpcDTO onlinePayInfo = purPoProvider.findOnlinePayInfo(poId);
        log.info("查询采购订单:{},支付信息:{}", poId, JSONUtil.toJsonStr(onlinePayInfo));
        return onlinePayInfo;
    }

    /**
     * 关闭采购订单
     * @param ids
     */
    public void closePo(List<Long> ids) {
        try {
            purPoProvider.closePo(ids);
        } catch (Exception e) {
            throw new BusinessException("调用采购域：关闭采购订单异常" + e.toString());
        }
    }
}
