/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.mq;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.infr.repo.supalloc.ScpSupplyAllocationRepoProc;
import com.elitesland.scp.infr.repo.template.ScpDemandOrderTemplateRepoProc;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepoProc;
import com.elitesland.support.provider.out.ItmItemUpdateMqParam;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ItmItemUpdateListener
implements MessageQueueListener<ItmItemUpdateMqParam> {
    private static final Logger log = LoggerFactory.getLogger(ItmItemUpdateListener.class);
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final ScpWhNetRelationRepoProc scpWhNetRelationRepoProc;
    private final ScpSupplyAllocationRepoProc scpSupplyAllocationRepoProc;
    private final ScpDemandOrderTemplateRepoProc scpDemandOrderTemplateRepoProc;

    @NotEmpty
    public String[] channels() {
        return new String[]{"itm_item_update"};
    }

    @Transactional(rollbackFor={Exception.class})
    public void onConsume(@NotBlank String s, @NotNull ItmItemUpdateMqParam itmItemUpdateMqParam) {
        log.info("\u5546\u54c1\u53d8\u66f4\uff1a" + JSON.toJSONString((Object)itmItemUpdateMqParam));
        Long itemId = itmItemUpdateMqParam.getItemId();
        String itemName = itmItemUpdateMqParam.getItemName();
        this.scpWhNetRelationRepoProc.updateItemNameByItemId(itemId, itemName);
        this.scpSupplyAllocationRepoProc.updateItemNameByItemId(itemId, itemName);
        this.scpDemandOrderTemplateRepoProc.updateItemNameByItemId(itemId, itemName);
        this.scpCateItemRepoProc.updateItemNameByItemId(itemName, itemId);
    }

    public ItmItemUpdateListener(ScpCateItemRepoProc scpCateItemRepoProc, ScpWhNetRelationRepoProc scpWhNetRelationRepoProc, ScpSupplyAllocationRepoProc scpSupplyAllocationRepoProc, ScpDemandOrderTemplateRepoProc scpDemandOrderTemplateRepoProc) {
        this.scpCateItemRepoProc = scpCateItemRepoProc;
        this.scpWhNetRelationRepoProc = scpWhNetRelationRepoProc;
        this.scpSupplyAllocationRepoProc = scpSupplyAllocationRepoProc;
        this.scpDemandOrderTemplateRepoProc = scpDemandOrderTemplateRepoProc;
    }
}

