package com.elitesland.scp.application.service.export;

import com.elitescloud.boot.excel.common.DataImport;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightImportVO;
import com.elitesland.scp.application.service.freight.ScpStoreOrderFreightService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

@Component
@Slf4j
@RequiredArgsConstructor
public class ScpStoreOrderFreightServiceImportImpl implements DataImport<ScpStoreOrderFreightImportVO> {
    private final ScpStoreOrderFreightService scpStoreOrderFreightService;

    @Override
    public String getTmplCode() {
        return "scp_store_order_freight_import";
    }

    @Override
    public List<String> executeImport(List<ScpStoreOrderFreightImportVO> dataList, int startRowIndex) {
        return scpStoreOrderFreightService.executeImport(dataList, startRowIndex);
    }

    @Override
    public Integer stepSize() {
        return 1000;
    }

    @Override
    public Set<Integer> sheetNoList() {
        return Set.of(1);
    }
}
