package com.elitesland.scp.provider.lakalapay;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.application.facade.vo.boh.StoreReceivePageParam;
import com.elitesland.scp.application.service.boh.StoreReceiveService;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderDConvert;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.dto.order.*;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.lakalapay.service.LklPaymentService;
import com.elitesland.scp.lakalapay.vo.BalanceResponseVO;
import com.elitesland.scp.lakalapay.vo.QueryBalanceParamVO;
import com.elitesland.scp.param.BalanceRpcResponseVO;
import com.elitesland.scp.param.QueryBalanceRpcParamVO;
import com.elitesland.scp.param.ScpOrderUnRecvParamVO;
import com.elitesland.scp.service.lakalapay.LklPaymentRpcService;
import com.elitesland.scp.service.order.ScpDemandOrderDRpcService;
import jodd.bean.BeanCopy;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
@RestController
@RequiredArgsConstructor
@RequestMapping(ScpApplication.URI_PREFIX + LklPaymentRpcService.PATH)
public class LklPaymentRpcServiceImpl implements LklPaymentRpcService {

    private final LklPaymentService lklPaymentService;

    @Override
    public BalanceRpcResponseVO queryBalance(QueryBalanceRpcParamVO param) {
        QueryBalanceParamVO queryBalanceParamVO = new QueryBalanceParamVO();
        queryBalanceParamVO.setStoreCode(param.getStoreCode());
        BalanceResponseVO balanceResponseVO = lklPaymentService.queryBalance(queryBalanceParamVO);
        BalanceRpcResponseVO balanceRpcResponseVO = new BalanceRpcResponseVO();
        BeanCopyUtil.beanCopy(balanceResponseVO, balanceRpcResponseVO);
        return balanceRpcResponseVO;
    }
}
