package com.elitesland.scp.application.facade.vo.cart;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/3/26 17:10
 * @Description:
 */
@Data
@ApiModel(description = "采购车数量更新参数")
public class CartCountParamVO implements Serializable {

    @ApiModelProperty("门店编码")
    @NotBlank(message = "门店编码不能为空")
    private String demandWhStCode;

    @ApiModelProperty("采购车类型")
    @NotBlank(message = "采购车类型不能为空")
    private String cartType;

    @ApiModelProperty("商品明细")
    private List<ItemSpecObjectVO> itemSpecObjectVOS;


    @Data
    public static class ItemSpecObjectVO {

        @ApiModelProperty("商品SPU编码")
        private String spuCode;

        private List<InnerItemSpecObjectVO> innerItemSpecObjectVOS;
    }

    @Data
    public static class InnerItemSpecObjectVO {

        @ApiModelProperty("组合商品编码")
        private String combineItemCode;

        @ApiModelProperty("商品规格编码")
        private String itemCode;

        @ApiModelProperty("商品ID")
        private Long itemId;

        @ApiModelProperty("数量")
        private BigDecimal qty;

    }
}
