package com.elitesland.scp.application.facade.vo.supalloc;

import com.elitesland.support.provider.item.dto.ItmItemCateSimpleTreeRpcDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 25日 11:46
 * @version: 1.0
 */
@Data
@ApiModel(value = "ScpSupplyAllocationImportVO", description = "供应商份额导入")
public class ScpSupplyAllocationImportVO implements Serializable {

    @ApiModelProperty(value = "供应仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty(value = "供应商编码")
    private String suppCode;

    @ApiModelProperty(value = "供应商名称")
    private String suppName;

    @ApiModelProperty("采购公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("采购公司编码")
    private String ouCode;

    @ApiModelProperty("采购公司名称")
    private String ouName;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "类型名")
    private String typeName;

    @ApiModelProperty(value = "门店id/门店仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long storeWhId;

    @ApiModelProperty(value = "仓库编码/门店编码")
    private String storeWhCode;

    @ApiModelProperty(value = "仓库名称/门店名称")
    private String storeWhName;

    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品品类名称")
    private String itemCateName;

    @ApiModelProperty(value = "商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "配额")
    private BigDecimal allocation;

    @ApiModelProperty(value = "最小订货量")
    private BigDecimal minimumOrderQuantity;

    @ApiModelProperty(value = "采购提前期")
    private BigDecimal purchaseLeadTime;

    @ApiModelProperty(value = "有效日期从")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "有效日期至")
    private LocalDateTime endTime;

    @ApiModelProperty("分组编号")
    private String importBillNum;

    private int line;

    @ApiModelProperty(value = "商品品类全路径")
    private List<ItmItemCateSimpleTreeRpcDTO> itemCatePath;


}
