package com.elitesland.scp.domain.convert.order;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetSelectRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandSetSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandUrgentSetSaveVO;
import com.elitesland.scp.domain.entity.order.ScpDemandSetDO;
import com.elitesland.scp.infr.dto.order.ScpDemandSetDTO;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;

/**
 * @Author: ryan.xu
 * @since 2024/03/18
 */
@Mapper(config = BaseMapperConfig.class)
public interface ScpDemandSetConvert {
    ScpDemandSetConvert INSTANCE = Mappers.getMapper(ScpDemandSetConvert.class);

    ScpDemandSetRespVO dtoToRespVO(ScpDemandSetDTO demandSetDTO);

    ScpDemandSetSelectRespVO dtoToSelectRespVO(ScpDemandSetDTO demandSetDTO);

    ScpDemandSetDTO doToDto(ScpDemandSetDO invCkDO);

    ScpDemandSetDO saveVoToDO(ScpDemandSetSaveVO saveVO);

    ScpDemandSetSaveVO saveVoToUrgentSaveVO(ScpDemandUrgentSetSaveVO saveVO);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void copySaveParamToDo(ScpDemandSetSaveVO saveVO, @MappingTarget ScpDemandSetDO intentDO);

}
