package com.elitesland.scp.provider.order;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.application.facade.vo.boh.StoreRtnConfirmParam;
import com.elitesland.scp.application.service.boh.StoreReceiveService;
import com.elitesland.scp.dto.both.StoreRtnConfirmRpcParam;
import com.elitesland.scp.service.order.ScpDemandOrderDRpcService;
import com.elitesland.scp.service.order.StoreReceiveProvider;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@Service
@RestController
@RequiredArgsConstructor
@RequestMapping(ScpApplication.URI_PREFIX + ScpDemandOrderDRpcService.PATH)
public class StoreReceiveProviderImpl implements StoreReceiveProvider {
    String PATH = "/rtn";

    private final StoreReceiveService storeReceiveService;
    /**
     * 门店小程序确认退货（出库）
     *
     * @param paramVO
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult rtn(StoreRtnConfirmRpcParam paramVO){
        StoreRtnConfirmParam param = BeanUtil.copyProperties(paramVO, StoreRtnConfirmParam.class);
        storeReceiveService.rtnConfirm(param);
        return ApiResult.ok();
    }


}
