/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.mrp;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpMrpDPageParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDExportRespVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDPlanRespVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDRespVO;
import com.elitesland.scp.application.facade.vo.save.mrp.ScpMrpDPlanSaveVO;
import com.elitesland.scp.application.service.mrp.ScpMrpDService;
import com.elitesland.scp.domain.service.mrp.ScpMrpDDomainService;
import com.elitesland.scp.domain.service.mrp.ScpMrpDPlanDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.stock.ScpPredictStStockRepoProc;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpMrpDServiceImpl
implements ScpMrpDService {
    private static final Logger log = LoggerFactory.getLogger(ScpMrpDServiceImpl.class);
    private final ScpMrpDDomainService scpMrpDDomainService;
    private final ScpMrpDPlanDomainService scpMrpDPlanDomainService;
    private final ScpPredictStStockRepoProc scpPredictStStockRepoProc;

    @Override
    public PagingVO<ScpMrpDRespVO> page(ScpMrpDPageParam param) {
        PagingVO<ScpMrpDRespVO> pagingVO = this.scpMrpDDomainService.searchPage(param);
        return pagingVO;
    }

    @Override
    public List<ScpMrpDRespVO> findByMasId(Long masId) {
        return this.scpMrpDDomainService.findByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePlan(List<ScpMrpDPlanSaveVO> scpMrpDPlanSaveVOList) {
        List<Long> deleteIds;
        if (CollectionUtil.isEmpty(scpMrpDPlanSaveVOList)) {
            throw new BusinessException("\u91c7\u8d2d\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long masId = scpMrpDPlanSaveVOList.get(0).getMasId();
        ScpMrpDRespVO scpMrpDRespVO = this.scpMrpDDomainService.findById(masId);
        if (scpMrpDRespVO == null) {
            throw new BusinessException("MRP\u8ba1\u5212\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        BigDecimal sumQty = scpMrpDPlanSaveVOList.stream().map(ScpMrpDPlanSaveVO::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (sumQty.compareTo(scpMrpDRespVO.getNetDemand()) != 0) {
            throw new BusinessException("\u91c7\u8d2d\u8ba1\u5212\u6570\u91cf\u4e4b\u548c\u9700\u8981\u7b49\u4e8e\u51c0\u9700\u6c42");
        }
        scpMrpDPlanSaveVOList.forEach(plan -> {
            plan.setMrpId(scpMrpDRespVO.getMasId());
            plan.setPushStatus(ScpUdcEnum.MRP_PUSH_STATUS_NOT.getValueCode());
        });
        List<ScpMrpDPlanRespVO> scpMrpDPlanRespVOList = this.scpMrpDPlanDomainService.findByMasIds(List.of(masId));
        if (CollectionUtil.isNotEmpty(scpMrpDPlanRespVOList) && CollectionUtil.isNotEmpty(deleteIds = scpMrpDPlanRespVOList.stream().filter(o -> scpMrpDPlanSaveVOList.stream().noneMatch(n -> o.getId().equals(n.getId()))).map(BaseViewModel::getId).collect(Collectors.toList()))) {
            this.scpMrpDPlanDomainService.deleteByIds(deleteIds);
        }
        this.scpMrpDDomainService.savePlan(scpMrpDPlanSaveVOList);
    }

    @Override
    public PagingVO<ScpMrpDExportRespVO> queryExport(ScpMrpDPageParam param) {
        return this.scpMrpDDomainService.queryExport(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        List<ScpMrpDRespVO> scpMrpDRespVOList = this.scpMrpDDomainService.findByIds(ids);
        if (CollectionUtil.isEmpty(scpMrpDRespVOList)) {
            throw new BusinessException("ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ScpMrpDPlanRespVO> scpMrpDPlanRespVOList = this.scpMrpDPlanDomainService.findByMasIds(ids);
        if (scpMrpDPlanRespVOList.stream().anyMatch(plan -> StringUtils.isNotBlank((CharSequence)plan.getPoNo()))) {
            throw new BusinessException("MRP\u8ba1\u5212\u660e\u7ec6\u5df2\u7ecf\u63a8\u9001\u91c7\u8d2d\u8ba2\u5355\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        List<Long> predIds = scpMrpDRespVOList.stream().map(ScpMrpDRespVO::getRelateDocDid).collect(Collectors.toList());
        this.scpMrpDDomainService.deleteByIds(ids);
        this.scpMrpDPlanDomainService.deleteByMasIds(ids);
        this.scpPredictStStockRepoProc.updateMrpFlag(predIds, Boolean.FALSE);
    }

    public ScpMrpDServiceImpl(ScpMrpDDomainService scpMrpDDomainService, ScpMrpDPlanDomainService scpMrpDPlanDomainService, ScpPredictStStockRepoProc scpPredictStStockRepoProc) {
        this.scpMrpDDomainService = scpMrpDDomainService;
        this.scpMrpDPlanDomainService = scpMrpDPlanDomainService;
        this.scpPredictStStockRepoProc = scpPredictStStockRepoProc;
    }
}

