/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.wqf;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountPageParam;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountPageVO;
import com.elitesland.scp.application.service.wqf.ScpWqfEntAccountService;
import com.elitesland.scp.domain.entity.wqf.ScpWqfEntAccountDO;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountRepo;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountRepoProc;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpWqfEntAccountServiceImpl
implements ScpWqfEntAccountService {
    private static final Logger log = LoggerFactory.getLogger(ScpWqfEntAccountServiceImpl.class);
    private final ScpWqfEntAccountRepoProc scpWqfEntAccountRepoProc;
    private final OrgOuRpcService orgOuRpcService;
    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpWqfEntAccountRepo scpWqfEntAccountRepo;

    @Override
    @SysCodeProc
    public PagingVO<ScpWqfEntAccountPageVO> page(ScpWqfEntAccountPageParam paramVO) {
        PagingVO<ScpWqfEntAccountPageVO> page = this.scpWqfEntAccountRepoProc.page(paramVO);
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            List ouIds = page.getRecords().stream().map(ScpWqfEntAccountPageVO::getOuId).distinct().collect(Collectors.toList());
            List storeIds = page.getRecords().stream().map(ScpWqfEntAccountPageVO::getStoreId).distinct().collect(Collectors.toList());
            List simpleOuDto = this.orgOuRpcService.findSimpleOuDto(ouIds);
            Map<Long, OrgOuRpcSimpleDTO> ouMap = simpleOuDto.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getId, v -> v, (e1, e2) -> e1));
            List storeDetailRpcDTOS = this.orgStoreRpcService.queryByIds(storeIds);
            Map<Long, OrgStoreDetailRpcDTO> storeMap = storeDetailRpcDTOS.stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getId, v -> v, (e1, e2) -> e1));
            for (ScpWqfEntAccountPageVO vo : page.getRecords()) {
                OrgStoreDetailRpcDTO storeDetailRpcDTO;
                OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(vo.getOuId());
                if (ouRpcSimpleDTO != null) {
                    vo.setOuName(ouRpcSimpleDTO.getOuName());
                    vo.setOuCode(ouRpcSimpleDTO.getOuCode());
                }
                if ((storeDetailRpcDTO = storeMap.get(vo.getStoreId())) == null) continue;
                vo.setStoreName(storeDetailRpcDTO.getStoreName());
            }
        }
        return page;
    }

    @Override
    @Transactional
    public List<Long> enable(List<Long> ids) {
        List<ScpWqfEntAccountDO> wqfEntAccountDOS = this.scpWqfEntAccountRepo.findByIdIn(ids);
        wqfEntAccountDOS.stream().filter(d -> Boolean.TRUE.equals(d.getStatus())).findAny().ifPresent(d -> {
            throw new RuntimeException("\u542f\u7528\u5931\u8d25,\u8bf7\u9009\u62e9\u3010\u672a\u542f\u7528\u3011\u72b6\u6001\u5355\u636e");
        });
        wqfEntAccountDOS.forEach(d -> d.setStatus(Boolean.TRUE));
        this.scpWqfEntAccountRepo.saveAll(wqfEntAccountDOS);
        return ids;
    }

    @Override
    @Transactional
    public List<Long> disable(List<Long> ids) {
        List<ScpWqfEntAccountDO> wqfEntAccountDOS = this.scpWqfEntAccountRepo.findByIdIn(ids);
        wqfEntAccountDOS.stream().filter(d -> Boolean.FALSE.equals(d.getStatus())).findAny().ifPresent(d -> {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u3010\u542f\u7528\u3011\u72b6\u6001\u5355\u636e");
        });
        wqfEntAccountDOS.forEach(d -> d.setStatus(Boolean.FALSE));
        this.scpWqfEntAccountRepo.saveAll(wqfEntAccountDOS);
        return ids;
    }

    public ScpWqfEntAccountServiceImpl(ScpWqfEntAccountRepoProc scpWqfEntAccountRepoProc, OrgOuRpcService orgOuRpcService, OrgStoreRpcService orgStoreRpcService, ScpWqfEntAccountRepo scpWqfEntAccountRepo) {
        this.scpWqfEntAccountRepoProc = scpWqfEntAccountRepoProc;
        this.orgOuRpcService = orgOuRpcService;
        this.orgStoreRpcService = orgStoreRpcService;
        this.scpWqfEntAccountRepo = scpWqfEntAccountRepo;
    }
}

