/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.pay.controller;

import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitesland.scp.pay.service.PaymentService;
import com.elitesland.scp.pay.vo.OnlinePayOrderParamVO;
import com.tenpay.business.entpay.mse.sdk.api.Payment;
import com.tenpay.business.entpay.mse.sdk.api.Redirect;
import com.tenpay.business.entpay.mse.sdk.api.Withdraw;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import com.tenpay.business.entpay.mse.sdk.model.PaymentClose;
import com.tenpay.business.entpay.mse.sdk.model.PaymentCloseParam;
import com.tenpay.business.entpay.mse.sdk.model.RetrieveBalanceGetParam;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/payments"})
@Validated
public class PaymentController {
    private static final Logger log = LoggerFactory.getLogger(PaymentController.class);
    private final PaymentService paymentService;

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u4e0b\u5355")
    @PostMapping(value={"/online/mp-pay"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.ELSE, operationDescription="\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u4e0b\u5355", allowRepeatRequest=false)
    public Redirect createOnlineMPPay(HttpServletRequest request, @RequestBody @Validated OnlinePayOrderParamVO param) {
        log.info("\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONUtil.toJsonStr((Object)param));
        String clientIP = ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
        param.setClientIp(clientIP);
        return this.paymentService.createMpPayOnline(param);
    }

    @ApiOperation(value="\u4e8c\u7ef4\u7801\u652f\u4ed8\u4e0b\u5355")
    @PostMapping(value={"/online/qrcode_pay"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.ELSE, operationDescription="\u4e8c\u7ef4\u7801\u652f\u4ed8\u4e0b\u5355", allowRepeatRequest=false)
    public Redirect createOnlineQRPay(HttpServletRequest request, @RequestBody @Validated OnlinePayOrderParamVO param) {
        log.info("\u4e8c\u7ef4\u7801\u652f\u4ed8\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        String clientIP = ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
        param.setClientIp(clientIP);
        return this.paymentService.createQrCodePayOnline(param);
    }

    @GetMapping(value={"/{paymentId}"})
    public Payment innerQuery(@PathVariable(value="paymentId") String paymentId) throws EntpayException {
        log.info("\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6(\u5185\u5355\u53f7)\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)paymentId);
        return Payment.retrieve((String)paymentId);
    }

    @GetMapping(value={"/out-payment-id/{outPaymentId}"})
    public Payment externalQuery(@PathVariable(value="outPaymentId") String outPaymentId) throws EntpayException {
        log.info("\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6(\u5916\u5355\u53f7)\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)outPaymentId);
        return Payment.retrieveByOutPaymentId((String)outPaymentId);
    }

    @GetMapping(value={"/{paymentId}/close"})
    public PaymentClose close(@PathVariable(value="paymentId") String paymentId) throws EntpayException {
        PaymentCloseParam paymentCloseParam = PaymentCloseParam.builder().closeReason("\u5173\u5355\u539f\u56e0").build();
        return Payment.close((String)paymentId, (PaymentCloseParam)paymentCloseParam);
    }

    @GetMapping(value={"/fee/{paymentId}"})
    public Payment retrieveFee(@PathVariable(value="paymentId") String paymentId) throws EntpayException {
        log.info("\u67e5\u8be2\u8ba2\u5355\u624b\u7eed\u8d39\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)paymentId);
        return Payment.retrieveFee((String)paymentId);
    }

    @GetMapping(value={"/withdraws/amounts"})
    public Withdraw retrieveBalance() throws EntpayException {
        RetrieveBalanceGetParam param = RetrieveBalanceGetParam.builder().accountType("RECEIVER_ACCOUNT").entId("100403095693").entAcctId("61141004030956933600000020009131").build();
        return Withdraw.retrieveBalance((RetrieveBalanceGetParam)param);
    }

    public PaymentController(PaymentService paymentService) {
        this.paymentService = paymentService;
    }
}

