/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.utils;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.scp.domain.entity.item.ScpStoreItemDO;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Component;

@Component
public class ScpCacheUtils {
    private static final Logger log = LoggerFactory.getLogger(ScpCacheUtils.class);
    private final RedisTemplate redisClient;

    public List<ScpStoreItemDO> getItemBySpuId(Long spuId) {
        String redisKey = this.generateItemKey(spuId);
        Object obj = this.redisClient.opsForValue().get((Object)redisKey);
        if (obj == null) {
            return null;
        }
        String str = (String)obj;
        return JSON.parseArray((String)str, ScpStoreItemDO.class);
    }

    public String generateItemKey(Long spuId) {
        return "SCP:ITEM:" + spuId;
    }

    public String generateLockKey(Long spuId) {
        return "SCP:ITEM:LOCK:" + spuId;
    }

    public void saveItem(Long spuId, List<ScpStoreItemDO> scpStoreItemDOS) {
        String redisKey = this.generateItemKey(spuId);
        String jsonString = JSON.toJSONString(scpStoreItemDOS);
        LocalDateTime now = LocalDateTime.now();
        long expire = ChronoUnit.SECONDS.between(now, now.with(LocalTime.MAX));
        this.redisClient.opsForValue().set((Object)redisKey, (Object)jsonString, expire, TimeUnit.SECONDS);
    }

    public void deleteKeys(Long spuId) {
        if (spuId == null) {
            throw new BusinessException("spuId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String cartKey = "*SCP:ITEM:" + spuId;
        Set<String> scan = this.scan((RedisTemplate<String, Object>)this.redisClient, cartKey);
        if (scan != null && scan.size() > 0) {
            this.redisClient.delete(scan);
        }
    }

    public void deleteAllKeys() {
        String cartKey = "*SCP:ITEM*";
        Set<String> scan = this.scan((RedisTemplate<String, Object>)this.redisClient, cartKey);
        if (scan != null && scan.size() > 0) {
            this.redisClient.delete(scan);
        }
    }

    public Set<String> scan(RedisTemplate<String, Object> redisTemplate, String pattern) {
        return (Set)redisTemplate.execute(connection -> {
            HashSet<String> keysTmp = new HashSet<String>();
            try (Cursor cursor = connection.scan(ScanOptions.scanOptions().match(pattern).count(10000L).build());){
                while (cursor.hasNext()) {
                    keysTmp.add(new String((byte[])cursor.next(), StandardCharsets.UTF_8));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return keysTmp;
        });
    }

    public void deleteSpecKeys(String spec) {
        String cartKey = "*" + spec + "*";
        Set<String> scan = this.scan((RedisTemplate<String, Object>)this.redisClient, cartKey);
        if (scan != null && scan.size() > 0) {
            this.redisClient.delete(scan);
        }
    }

    public ScpCacheUtils(RedisTemplate redisClient) {
        this.redisClient = redisClient;
    }
}

