package com.elitesland.scp.application.facade.vo.save.msg;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 运营消息保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/28
 */
@Getter
@Setter
@ApiModel(description = "运营消息保存信息")
public class ScpMessageSaveVO implements Serializable {
    private static final long serialVersionUID = 3194903270260000746L;

    @ApiModelProperty(value = "消息ID，编辑时不可为空", position = 1)
    private Long id;

    @NotBlank(message = "标题不可为空")
    @ApiModelProperty(value = "标题", position = 2, required = true)
    private String title;

    @ApiModelProperty(value = "摘要", position = 3)
    private String summaries;

    @ApiModelProperty(value = "作者用户ID，为空则取当前用户", position = 4)
    private Long authorId;

    @ApiModelProperty(value = "消息分类，[UDC]yst-suplan:MESSAGE_CATEGORY", position = 5, hidden = true)
    private String category;

    @ApiModelProperty(value = "消息类型", position = 6, hidden = true)
    private String noticeType;

    @ApiModelProperty(value = "是否置顶", position = 7)
    private Boolean top;

    @ApiModelProperty(value = "发布时间", position = 8)
    private LocalDateTime publishTime;

    @ApiModelProperty(value = "是否推送小程序", position = 22)
    private Boolean pushApplet;

    @ApiModelProperty(value = "门店编码", position = 22)
    private List<String> orgStoreCodes;

    @ApiModelProperty(value = "备注", position = 30)
    private String remark;

    @ApiModelProperty(value = "消息封面的唯一标识", position = 91, hidden = true)
    private List<String> fileCodes;

    @ApiModelProperty(value = "消息内容", position = 92)
    private String txt;

    @ApiModelProperty(value = "消息内容附件的唯一标识", position = 93, hidden = true)
    private List<String> txtFileCodes;

    @ApiModelProperty(value = "消息内容的扩展属性", position = 94, hidden = true)
    private Map<String, Object> txtExtAttr;
}
