package com.elitesland.scp.application.service.app;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.*;
import com.elitesland.scp.application.facade.vo.resp.app.*;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.domain.convert.app.ScpStoreItemConvert;
import com.elitesland.scp.domain.convert.authority.AppItmItemConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.entity.item.ScpStoreItemDO;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.CollectRedisUtil;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class AppItemActivityrServiceImpl implements AppItemActivityService {

    private final RmiItemService rmiItemService;
    private final CartRedisUtil cartRedisUtil;
    private final CollectRedisUtil collectRedisUtil;
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final ScpCacheService scpCacheService;
    private final CommonPriceService commonPriceService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;

    @Override
    @SysCodeProc
    public PagingVO<AppItemActivityRespVO> query(AppItemActivityParamVO paramVO) throws ExecutionException,
            InterruptedException {
        // 常定功能先返回空20240729
        return new PagingVO<>();
    }

    @Override
    public PagingVO<AppItmItemPageVO> itemPage(AppItemPageParamVO paramVO) {
        //根据单据类型查询绑定的商品分类
        if (StrUtil.isNotBlank(paramVO.getDocType())) {
            List<String> itemTypes = scpOrderSettingDomainService.findItemCatesByDocType(paramVO.getDocType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            paramVO.setItemTypes(itemTypes);
        }
        Long count = scpCateItemRepoProc.countAppItemSpu(paramVO);
        if (count == 0) {
            return new PagingVO<>();
        }
        List<AppItmItemPageVO> itemList = scpCateItemRepoProc.pageAppItemSpu(paramVO);
        // 商品信息查询,图片信息，同SPU下其他SKU信息
        this.itemMessageImageAndDetailsQuery(itemList, paramVO.getStoreCode(), paramVO.getDocType(), paramVO.getOuCode());
        //商品价格和库存查询
        this.getPriceAndStock(paramVO.getDocType(), itemList, paramVO.getStoreCode(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        return new PagingVO<>(count, itemList);
    }

    @Override
    public PagingVO<AppItmItemPageVO> commonItemPage(CommonItemPageParamVO paramVO) {
        if (StrUtil.isBlank(paramVO.getBrand())) {
            return new PagingVO<>();
        }
        Long count = scpCateItemRepoProc.countCommonItemSpu(paramVO);
        if (count == 0) {
            return new PagingVO<>();
        }
        List<AppItmItemPageVO> itemList = scpCateItemRepoProc.pageCommonItemSpu(paramVO);
        // 商品信息查询,图片信息，同SPU下其他SKU信息
        this.itemMessageImageAndDetailsQuery(itemList, null, null,paramVO.getOuCode());
        return new PagingVO<>(count, itemList);
    }

    /**
     * 商品价格查询
     *
     * @param docType
     * @param itemList
     * @param storeCode
     * @param type
     */
    public void getPriceAndStock(String docType, List<AppItmItemPageVO> itemList, String storeCode, String type) {
        List<AppItemActivityItemPriceParamVO> appItemActivityItemPriceParamVOS = CollUtil.newCopyOnWriteArrayList(new ArrayList<>());
        itemList.forEach(row -> {
            List<AppItemActivityItemPriceParamVO> inList = row.getDetails().stream()
                    .map(t -> {
                        AppItemActivityItemPriceParamVO appItemActivityItemPriceParamVO = new AppItemActivityItemPriceParamVO();
                        appItemActivityItemPriceParamVO.setStoreCode(storeCode);
                        appItemActivityItemPriceParamVO.setItemCode(t.getItemCode());
                        appItemActivityItemPriceParamVO.setItemCateCode(t.getItemCateCode());
                        appItemActivityItemPriceParamVO.setUom(t.getUom());
                        appItemActivityItemPriceParamVO.setItemId(t.getItemId());
                        appItemActivityItemPriceParamVO.setCombineItemCode(t.getCombineItemCode());
                        appItemActivityItemPriceParamVO.setCombineItemFlag(t.getCombineItemFlag());
                        return appItemActivityItemPriceParamVO;
                    }).collect(Collectors.toList());
            appItemActivityItemPriceParamVOS.addAll(inList);
        });
        //查询库存信息
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<>(new HashMap<>());
        //获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByDocType(docType, type);

        //获取购物车信息
        Long currentUserId = UserService.currentUserId();
        List<ScpStoreCartDO> cartDOS = cartRedisUtil.getStoreCartItems(storeCode, docType, currentUserId);


        List<String> filterItemCodes = new ArrayList<>();
        //获取价格和库存信息
        Map<String, List<PriPriceRpcDTO>> priceMap = commonPriceService.getPriceAndStockDetails(appItemActivityItemPriceParamVOS, storeCode, orderSetting, type, stockMapRef);
        Map<String, BigDecimal> stockMap = stockMapRef.get();
        itemList.forEach(item -> {
            BigDecimal mainStkQty = BigDecimal.ZERO;
            List<AppItmItemPageVO> details = item.getDetails();

            for (int i = 0; i < details.size(); i++) {
                AppItmItemPageVO detail = details.get(i);
                if (detail == null) continue;

                String itemKey = SysUtils.getItemKey(detail.getCombineItemCode(), detail.getItemCode());
                List<PriPriceRpcDTO> priceDList = priceMap.get(itemKey);
                if (CollUtil.isNotEmpty(priceDList)) {
                    detail.setPrice(priceDList.get(0).getPrice());
                }

                // 库存数据设置
                BigDecimal avalQty = stockMap.getOrDefault(detail.getItemCode(), BigDecimal.ZERO);
                detail.setAvalQty(avalQty);

                // 主商品库存计算
                if (Boolean.TRUE.equals(detail.getCombineItemFlag())) {
                    BigDecimal qty = detail.getCombineQty();
                    // 若 qty 为 0，divide 不执行，避免异常
                    if (qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal divide = detail.getAvalQty().divide(qty, 0, RoundingMode.FLOOR);
                        if (i == 1) {
                            mainStkQty = divide;
                        } else {
                            if (divide.compareTo(mainStkQty) < 0) {
                                mainStkQty = divide;
                            }
                        }
                    }
                }
            }

            if (item.getCombineItemFlag() != null && item.getCombineItemFlag()) {
                List<PriPriceRpcDTO> priPriceRpcDTOS = priceMap.get(SysUtils.getItemKey(item.getSpuCode(), item.getSpuCode()));
                if (CollUtil.isNotEmpty(priPriceRpcDTOS)) {
                    item.setCombineItemPrice(priPriceRpcDTOS.get(0).getPrice());
                    item.setPrice(priPriceRpcDTOS.get(0).getPrice());
                }
                item.setAvalQty(mainStkQty);
            }else {
                // 库存数据设置
                BigDecimal avalQty = stockMap.getOrDefault(item.getItemCode(), BigDecimal.ZERO);
                item.setAvalQty(avalQty);
            }

            //过滤无库存的
            if(item.getAvalQty().compareTo(BigDecimal.ZERO)<=0){
                filterItemCodes.add(item.getItemCode());
            }

            String itemKey = SysUtils.getItemKey(item.getCombineItemCode(), item.getItemCode());
            List<PriPriceRpcDTO> priceDList = priceMap.get(itemKey);
            if (CollUtil.isNotEmpty(priceDList)) {
                item.setPrice(priceDList.get(0).getPrice());
            }

            //赋值购物车的数量
            if(CollUtil.isNotEmpty(cartDOS)){
                cartDOS.stream().filter(row -> StringUtils.equals(row.getItemCode(), item.getItemCode())&&StringUtils.isEmpty(row.getCombineItemCode())).findFirst().ifPresentOrElse(cart -> {
                    item.setQty(cart.getQty());
                }, () -> {
                    item.setQty(BigDecimal.ZERO);
                });
            }else {
                item.setQty(BigDecimal.ZERO);
            }
        });

        List<AppItmItemPageVO> collect = itemList.stream().filter(item -> filterItemCodes.contains(item.getItemCode())).collect(Collectors.toList());
        itemList.removeAll( collect);
    }


    private static List<AppItmItemPageVO> mergeObjectsAndDetails(List<AppItmItemPageVO> outerList) {
        List<AppItmItemPageVO> mergedList = new ArrayList<>();

        for (AppItmItemPageVO outerObject : outerList) {
            // 添加外部对象到合并列表
            mergedList.add(outerObject);

            // 获取并遍历当前外部对象的 detail 列表
            List<AppItmItemPageVO> detailList = outerObject.getDetails();
            if (detailList != null) {
                for (AppItmItemPageVO detailObject : detailList) {
                    // 将 detail 列表中的每个对象添加到合并列表
                    mergedList.add(detailObject);
                }
            }
        }
        return mergedList;
    }

    @Override
    public AppItmSpuRespVO findIdOne(AppItemSpecParamVO paramVO) {
        ScpStoreItemParamVO scpStoreItemParamVO = new ScpStoreItemParamVO();
        scpStoreItemParamVO.setSpuId(paramVO.getSpuId());
        scpStoreItemParamVO.setOuCode(paramVO.getOuCode());
        List<ScpStoreItemDO> itemDOS = scpCacheService.getItem(scpStoreItemParamVO);
        if (CollUtil.isEmpty(itemDOS)) {
            throw new BusinessException("未查询到商品");
        }
        // 商品SKU图片
        List<ItmItemAttachmentRpcDTO> skuAttachmentList = itemDOS.stream().filter(row -> CollUtil.isNotEmpty(row.getSkuAttachmentList())).flatMap(item -> item.getSkuAttachmentList().stream()).collect(Collectors.toList());
        AppItmSpuRespVO appItmSpuRespVO = ScpStoreItemConvert.INSTANCE.doToRespVo(itemDOS.get(0));
        appItmSpuRespVO.setSkuAttchmentList(skuAttachmentList);
        appItmSpuRespVO.setSpuAttchmentList(itemDOS.get(0).getSpuAttachmentList());
        // 获取当前登录人信息
        Long currentUserId = UserService.currentUserId();
        appItmSpuRespVO.setCollectFlag(collectRedisUtil.existsSpuInUser(paramVO.getStoreCode(), currentUserId, paramVO.getItemCode()));
        return appItmSpuRespVO;
    }

    @Override
    public AppItemSpecRespVO specQuery(AppItemSpecParamVO paramVO) {
        ScpStoreItemParamVO scpStoreItemParamVO = new ScpStoreItemParamVO();
        scpStoreItemParamVO.setSpuId(paramVO.getSpuId());
        scpStoreItemParamVO.setOuCode(paramVO.getOuCode());
        List<ScpStoreItemDO> itemDOS = scpCacheService.getItem(scpStoreItemParamVO);
        if (CollUtil.isEmpty(itemDOS)) {
            throw new BusinessException("未查询到商品");
        }
        //商品价格查询
        //获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByDocType(paramVO.getDocType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        List<AppItemActivityItemPriceParamVO> priceParamVOS = itemDOS.stream().map(row -> {
            AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
            priceParamVO.setItemCode(row.getItemCode());
            priceParamVO.setItemId(row.getItemId());
            priceParamVO.setItemCateCode(row.getItemCateCode());
            priceParamVO.setUom(row.getUom());
            return priceParamVO;
        }).collect(Collectors.toList());
        Long currentUserId = UserService.currentUserId();
        Map<String, List<PriPriceRpcDTO>> priceMap = commonPriceService.getPriceAndStockDetails(priceParamVOS, paramVO.getStoreCode(), orderSetting, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        List<AppItmSkuRespVO> skuRespVOList = itemDOS.stream().map(row -> {
            AppItmSkuRespVO appItmSkuRespVO = ScpStoreItemConvert.INSTANCE.doToSkuRespVo(row);
            List<PriPriceRpcDTO> priceRpcDTOS = priceMap.get(row.getItemCode());
            if (CollUtil.isNotEmpty(priceRpcDTOS)) {
                appItmSkuRespVO.setPrice(priceRpcDTOS.get(0).getPrice());
            }
            ScpStoreCartDO storeCartItem = cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(null, row.getItemCode()), paramVO.getStoreCode(), paramVO.getDocType(), currentUserId);
            if (storeCartItem != null) {
                appItmSkuRespVO.setQty(storeCartItem.getQty());
            } else {
                appItmSkuRespVO.setQty(BigDecimal.ZERO);
            }
            return appItmSkuRespVO;
        }).collect(Collectors.toList());
        //封装返回
        AppItemSpecRespVO result = new AppItemSpecRespVO();
        //获取skuRespVOList 最大价格和最小价格
        result.setMaxPrice(skuRespVOList.stream().map(AppItmSkuRespVO::getPrice).filter(Objects::nonNull).max(BigDecimal::compareTo).orElse(BigDecimal.ZERO));
        result.setMinPrice(skuRespVOList.stream().map(AppItmSkuRespVO::getPrice).filter(Objects::nonNull).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO));
        result.setSkuRespVOList(skuRespVOList);
        return result;
    }

    /**
     * 商品信息查询,图片信息，同SPU下其他SKU信息
     *
     * @param collect
     */
    private void itemMessageImageAndDetailsQuery(List<AppItmItemPageVO> collect, String storeCode, String cartType, String ouCode) {
        Long currentUserId = UserService.currentUserId();
        List<Long> spuIdList = collect.stream().map(AppItmItemPageVO::getSpuId).collect(Collectors.toList());
        List<String> itemCodeList = scpCateItemRepoProc.pageItemCodesByParam(spuIdList);
        //查询采购车商品信息
        ItmItemScpBaseRpcParam param = new ItmItemScpBaseRpcParam();
        param.setItemCodes(itemCodeList);
        param.setBusinessBuCode(ouCode);
        param.setItmBusinessFlag(true);
        List<ItmItemScpBaseRpcDTO> itemRpcDtoByParam = rmiItemService.findItemScpBaseRpcDtoByParam(param);
        Map<Long, List<ItmItemScpBaseRpcDTO>> groupData =
                itemRpcDtoByParam.stream().collect(Collectors.groupingBy(ItmItemScpBaseRpcDTO::getSpuId));
        //减少遍历次数和查找逻辑，以提高性能
        collect.forEach(t -> {
            List<ItmItemScpBaseRpcDTO> itemScpBaseRpcDTOS = groupData.get(t.getSpuId());
            if(itemScpBaseRpcDTOS == null){
                return;
            }
            ItmItemScpBaseRpcDTO itmItemRpcDTO = itemScpBaseRpcDTOS.get(0);
            t.setItemId(itmItemRpcDTO.getId());
            t.setItemCode(itmItemRpcDTO.getItemCode());
            t.setItemName(itmItemRpcDTO.getItemName());
            t.setUom(itmItemRpcDTO.getUom2());
            t.setUomName(itmItemRpcDTO.getUom2Name());
            t.setItemType(itmItemRpcDTO.getItemType());
            t.setItemTypeName(itmItemRpcDTO.getItemTypeName());
            t.setItemType2(itmItemRpcDTO.getItemType2());
            t.setItemType2Name(itmItemRpcDTO.getItemType2Name());
            t.setBrand(itmItemRpcDTO.getBrand());
            t.setBrandName(itmItemRpcDTO.getBrandName());
            t.setItemAttr2(itmItemRpcDTO.getItemAttr2());
            t.setSpec(itmItemRpcDTO.getSpec());
            t.setItemCateCode(itmItemRpcDTO.getItemCateCode());
            t.setItemCateName(itmItemRpcDTO.getItemCateFullName());
            t.setSpuId(itmItemRpcDTO.getSpuId());
            t.setSpuCode(itmItemRpcDTO.getSpuCode());
            t.setSpuName(itmItemRpcDTO.getSpuName());
            t.setUom2(itmItemRpcDTO.getUom());
            t.setUom2Name(itmItemRpcDTO.getUomName());
            t.setDecimalPlaces(itmItemRpcDTO.getDecimalPlaces());
            t.setUomRatio(itmItemRpcDTO.getUomRatio2());
            t.setItemAttrName(StrUtil.isBlank(itmItemRpcDTO.getItemAttrName()) ? itmItemRpcDTO.getSpec() : itmItemRpcDTO.getItemAttrName());
            t.setAnotherName(itmItemRpcDTO.getAnotherName());
            t.setReceiveUom(itmItemRpcDTO.getReceiveUom());
            t.setReceiveUomRatio(itmItemRpcDTO.getReceiveUomRatio());
            t.setReceiveUomName(itmItemRpcDTO.getReceiveUomName());
            //图片信息
            t.setItemImageList(AppItmItemConvert.INSTANCE.attachmentRpcDtoToProviderDtoList(itmItemRpcDTO.getSpuAttchmentList()));
            //设置同一个SPU下其他SKU信息
            t.setDetails(getDetails(CollectionUtils.isNotEmpty(itmItemRpcDTO.getSubItems()) ? itmItemRpcDTO.getSubItems() : itemScpBaseRpcDTOS,
                    storeCode,
                    cartType,
                    currentUserId,
                    itmItemRpcDTO
                    ));
            t.setCombineItemFlag(CollectionUtils.isNotEmpty(itmItemRpcDTO.getSubItems()));
            if (Boolean.TRUE.equals(t.getCombineItemFlag())) {
                t.setDecimalPlaces(0);
            }
            log.info("当前商品：{}", JSON.toJSONString(t));
        });

        //移除未查询到的商品
        collect.removeIf(t -> !groupData.containsKey(t.getSpuId()));

    }

    @SysCodeProc
    private List<AppItmItemPageVO> getDetails(List<ItmItemScpBaseRpcDTO> source, String storeCode, String cartType, Long currentUserId, ItmItemScpBaseRpcDTO parentItem) {
        log.info("获取详情，入参：{}", JSON.toJSONString(source));
        return source.stream().map(
                itmItemRpcDTO -> {
                    AppItmItemPageVO t = new AppItmItemPageVO();
                    t.setItemName(itmItemRpcDTO.getItemName());
                    t.setUom(itmItemRpcDTO.getUom2());
                    t.setUomName(itmItemRpcDTO.getUom2Name());
                    t.setItemType(itmItemRpcDTO.getItemType());
                    t.setItemTypeName(itmItemRpcDTO.getItemTypeName());
                    t.setBrand(itmItemRpcDTO.getBrand());
                    t.setBrandName(itmItemRpcDTO.getBrandName());
                    t.setItemAttr2(itmItemRpcDTO.getItemAttr2());
                    t.setSpec(itmItemRpcDTO.getSpec());
                    t.setItemCateCode(itmItemRpcDTO.getItemCateCode());
                    t.setItemCateName(itmItemRpcDTO.getItemCateFullName());
                    t.setSpuId(itmItemRpcDTO.getSpuId());
                    t.setSpuCode(itmItemRpcDTO.getSpuCode());
                    t.setSpuName(itmItemRpcDTO.getSpuName());
                    if (StrUtil.isNotBlank(cartType)) {
                        ScpStoreCartDO storeCartItem;
                        if (itmItemRpcDTO.getBomPid() != null) {
                            storeCartItem = cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(parentItem.getItemCode(), itmItemRpcDTO.getItemCode()), storeCode, cartType, currentUserId);
                        } else {
                            storeCartItem = cartRedisUtil.getStoreCartItem(itmItemRpcDTO.getItemCode(), storeCode, cartType, currentUserId);
                        }
                        if (storeCartItem != null) {
                            t.setQty(storeCartItem.getQty());
                        } else {
                            t.setQty(BigDecimal.ZERO);
                        }
                    }
                    t.setItemAttrName(StrUtil.isBlank(itmItemRpcDTO.getItemAttrName()) ? itmItemRpcDTO.getSpec() : itmItemRpcDTO.getItemAttrName());
                    t.setAnotherName(itmItemRpcDTO.getAnotherName());
                    //图片信息
                    t.setItemImageList(AppItmItemConvert.INSTANCE.attachmentRpcDtoToProviderDtoList(itmItemRpcDTO.getSpuAttchmentList()));
                    t.setItemId(itmItemRpcDTO.getId());
                    t.setItemCode(itmItemRpcDTO.getItemCode());
                    t.setUom2(itmItemRpcDTO.getUom());
                    t.setUom2Name(itmItemRpcDTO.getUomName());
                    t.setDecimalPlaces(itmItemRpcDTO.getDecimalPlaces());
                    t.setUomRatio(itmItemRpcDTO.getUomRatio2());
                    t.setReceiveUom(itmItemRpcDTO.getReceiveUom());
                    t.setReceiveUomRatio(itmItemRpcDTO.getReceiveUomRatio());
                    t.setReceiveUomName(itmItemRpcDTO.getReceiveUomName());
                    t.setMoq(itmItemRpcDTO.getMoq());
                    t.setPrice(itmItemRpcDTO.getPrice());
                    t.setCombineQty(itmItemRpcDTO.getBomQty());
                    if (itmItemRpcDTO.getBomPid() != null) {
                        t.setCombineItemFlag(Boolean.TRUE);
                        t.setCombineItemCode(parentItem.getItemCode());
                        t.setCombineItemName(parentItem.getItemName());
                    } else {
                        t.setCombineItemFlag(Boolean.FALSE);
                    }
                    log.info("get detail:当前商品：{}", JSON.toJSONString(t));
                    return t;
                }
        ).collect(Collectors.toList());
    }

}
