package com.elitesland.scp.infr.dto.whnet;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2024-03-20
* @Version 1.0
**/

@Data
public class ScpWhNetRelationDTO extends BaseViewModel implements Serializable {

    @ApiModelProperty(value = "供应仓库id")
    private Long supplyWhId;

    @ApiModelProperty(value = "供应仓库编码")
    private String supplyWhCode;

    @ApiModelProperty(value = "供应仓库名称")
    private String supplyWhName;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "需求门店id/门店仓库id")
    private Long demandWhStId;

    @ApiModelProperty(value = "需求仓库编码/门店编码")
    private String demandWhStCode;

    @ApiModelProperty(value = "需求仓库名称/门店名称")
    private String demandWhStName;

    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品品类名称")
    private String itemCateName;

    @ApiModelProperty(value = "商品id")
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "转移提前期")
    private BigDecimal transferLeadTime;

    @ApiModelProperty(value = "供应百分比")
    private BigDecimal supplyPercentage;

    @ApiModelProperty(value = "供应百分比之和")
    private BigDecimal supplyPercentageSum;

    @ApiModelProperty(value = "有效日期从")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "有效日期至")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "状态")
    private Boolean status;

    private String es1;

    private Integer lineNo;

    @ApiModelProperty("销售公司编码")
    private String ouCode;

    @ApiModelProperty("销售公司名称")
    private String ouName;

    @ApiModelProperty("客户编码")
    private String custCode;
}