package com.elitesland.scp.application.service.scpsman;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.*;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeUpsertDTO;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.scp.application.facade.vo.save.authority.ScpManAuthorityDSaveVO;
import com.elitesland.scp.application.facade.vo.save.authority.ScpManAuthoritySaveVO;
import com.elitesland.scp.application.facade.vo.scpsman.*;
import com.elitesland.scp.application.service.authority.ScpsmanAuthorityService;
import com.elitesland.scp.common.Constant;
import com.elitesland.scp.domain.convert.scpsman.SalesmanInfoConvert;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDDO;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanRegionDO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityDService;
import com.elitesland.scp.dto.scpsman.SalesmanLevelInfoDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityDRepo;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepo;
import com.elitesland.scp.infr.repo.scpsman.SalesmanRegionRepo;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepoProc;
import com.elitesland.scp.rmi.RmiOrgOuService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.support.provider.org.dto.OrgContactRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.google.common.collect.Lists;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 17:42
 * @Description:
 */
@Log4j2
@Service
@RequiredArgsConstructor
public class ScpsmanInfoServiceImpl implements ScpsmanInfoService {

    private final TransactionTemplate transactionTemplate;

    public static final String SCPSMAN = "scpsman";
    @Autowired
    private ScpsmanInfoRepo scpsmanInfoRepo;
    @Autowired
    private ScpsmanInfoRepoProc scpsmanInfoRepoProc;
    @Autowired
    private RmiSysUDCService rmiSysUDCService;
    @Autowired
    private EmployeeRpcService employeeRpcService;
    @Autowired
    private OrgRpcService orgRpcService;
    @Autowired
    private Constant constant;
    @Autowired
    private SalesmanRegionRepo salesmanRegionRepo;
    @Autowired
    private OrgOuRpcService orgOuRpcService;
    @Autowired
    private SysAreaRpcService sysAreaRpcService;

    private final ScpDemandAuthorityDService scpDemandAuthorityDService;

    @Autowired
    private final ScpDemandAuthorityRepo scpDemandAuthorityRepo;


    @Autowired
    private final ScpDemandAuthorityDRepo scpDemandAuthorityDRepo;

    @Autowired
    private RmiOrgStoreRpcService rmiOrgStoreRpcService;


    @Autowired
    private RmiOrgOuService rmiOrgOuService;
    @Autowired
    private UserRpcService userRpcService;

    @Autowired
    private SysSettingService settingService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> save(SalesmanInfoSaveVO salesmanInfoSaveVO) {

        log.info("计划员信息保存入参 {}", salesmanInfoSaveVO.toString());
//        if (salesmanInfoSaveVO.getSalesmanType().equals(UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getValueCode())
//                && CollUtil.isEmpty(salesmanInfoSaveVO.getJurisdictions())) {
//            return ApiResult.fail("销售总监必须填写管辖区域！");
//        }
//        if (salesmanInfoSaveVO.getSalesmanType().equals(UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getValueCode())
//                && salesmanInfoSaveVO.getLeaderUserId() != null) {
//            return ApiResult.fail("销售总监不允许有上级");
//        }

        ScpsmanInfoDO bySalesmanNo = scpsmanInfoRepo.findByScpsmanNo(salesmanInfoSaveVO.getScpsmanNo());
        if (Optional.ofNullable(bySalesmanNo).isPresent() && (salesmanInfoSaveVO.getId() == null || salesmanInfoSaveVO.getId() == 0)) {
            return ApiResult.fail("该编号已存在，请重新输入");
        }
        ScpsmanInfoDO byLoginAccount = scpsmanInfoRepo.findByLoginAccount(salesmanInfoSaveVO.getLoginAccount());
        if (Optional.ofNullable(byLoginAccount).isPresent() && (salesmanInfoSaveVO.getId() == null || salesmanInfoSaveVO.getId() == 0)){
            throw new BusinessException("该登录账号已存在，请重新输入");
        }
        if (salesmanInfoSaveVO.getId() != null){
            salesmanRegionRepo.deleteByMasId(salesmanInfoSaveVO.getId());
        }
        ScpsmanInfoDO scpsmanInfoDO = SalesmanInfoConvert.INSTANCE.salesmanInfoSaveToDO(salesmanInfoSaveVO);
        scpsmanInfoDO.setEnableStatus(1);

        EmployeeUpsertDTO upsertDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoSaveVOToUpsertDTO(salesmanInfoSaveVO);
        if (StringUtils.isNotBlank(salesmanInfoSaveVO.getBirthdayTime())){
            upsertDTO.setBirthDate(constant.stringToLocalDate(salesmanInfoSaveVO.getBirthdayTime()));
        }
        if (StringUtils.isNotBlank(salesmanInfoSaveVO.getJoinTime())) {
            upsertDTO.setJoinTime(constant.swapTimeMin(salesmanInfoSaveVO.getJoinTime()));
        }
        if("EMP".equals(scpsmanInfoDO.getSource())){
            upsertDTO.setType("SCPSMAN");
        }

        //保存计划员信息
        ScpsmanInfoDO save = scpsmanInfoRepo.save(scpsmanInfoDO);

        //保存员工信息
        buildEmployee(salesmanInfoSaveVO, scpsmanInfoDO, upsertDTO,String.valueOf(save.getId()) );

        //保存计划员区域
        List<ScpsmanRegionDO> scpsmanRegionDOS = new ArrayList<>();
        if (CollUtil.isNotEmpty(salesmanInfoSaveVO.getJurisdictions())){
            for (String jurisdiction : salesmanInfoSaveVO.getJurisdictions()) {
                ScpsmanRegionDO scpsmanRegionDO = new ScpsmanRegionDO();
                scpsmanRegionDO.setRegionCode(jurisdiction);
                scpsmanRegionDO.setMasId(save.getId());
                scpsmanRegionDOS.add(scpsmanRegionDO);
            }
        }
        salesmanRegionRepo.saveAll(scpsmanRegionDOS);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<PagingVO<SalesmanInfoRespVO>> query(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        log.info("计划员信息分页查询入参 {}", salesmanInfoQueryVO);

        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-suplan", "SCPSMAN_TYPE");
        Map<String, String> regionUDCMap = rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        //无条件查询（只查询没有上级的）
        if (salesmanInfoQueryVO.getNoQueryParam() == 1) {
            //先找出计划员编码
            JPAQuery<SalesmanSimpleInfoRespVO> jpaQuery = scpsmanInfoRepoProc.findAllSalesmanCode();
            List<SalesmanSimpleInfoRespVO> salesmanCodeList = jpaQuery.fetch();
            if (CollUtil.isEmpty(salesmanCodeList)) {
             return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                     .total(0)
                     .build());
            }
            Set<String> codes =
                    salesmanCodeList.stream().map(SalesmanSimpleInfoRespVO::getScpsmanNo).filter(Objects::nonNull).collect(Collectors.toSet());
            log.info("计划员编码数量大小:{}", codes.size());
            //查询员工数据

            EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
            employeePageQueryDTO.setCodes(codes);
            //employeePageQueryDTO.setWithoutLeader(true);
            employeePageQueryDTO.setSize(salesmanInfoQueryVO.getSize());
            employeePageQueryDTO.setCurrent(salesmanInfoQueryVO.getCurrent() + 2);
            ApiResult<PagingVO<EmployeePageRespDTO>> result = employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!result.isSuccess()) {
                throw new BusinessException("员工信息查询失败！" + result.getMsg());
            }
            long total = result.getData().getTotal();
            //员工数据
            List<EmployeePageRespDTO> employeePageRespDTOList = result.getData().getRecords();
            log.info("查询员工数据结果:{}", JSONUtil.toJsonStr(employeePageRespDTOList));
            if (CollUtil.isEmpty(employeePageRespDTOList)) {
                return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                        .total(0)
                        .build());
            }
            List<EmployeeInfoRespVO> employeeInfoRespVOS =
                    SalesmanInfoConvert.INSTANCE.employeePageRespDTOToEmployeeInfoRespVO(employeePageRespDTOList);
            Map<String, EmployeeInfoRespVO> employeeInfoRespVOMap = employeeInfoRespVOS.stream()
                    .collect(Collectors.toMap(EmployeeInfoRespVO::getCode, Function.identity(), (k1, k2) -> k1));

            List<String> scpManNoList =
                    employeePageRespDTOList.stream().map(EmployeePageRespDTO::getCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            log.info("scpManNoList的值:{}", JSONUtil.toJsonStr(scpManNoList));

            SalesmanInfoQueryVO queryVO = new SalesmanInfoQueryVO();
            queryVO.setCodes(scpManNoList);
            List<SalesmanInfoRespVO> salesmanInfoRespVOList = scpsmanInfoRepoProc.findSalesmanInfo(queryVO).fetch();

            Map<Long, List<SalesmanRegionVO>> regionMap = getSalesmanRegionMap(regionUDCMap,
                    salesmanInfoRespVOList.stream().map(SalesmanInfoRespVO::getId).collect(Collectors.toList()));
            // 拼接数据
            for (SalesmanInfoRespVO salesmanInfoRespVO : salesmanInfoRespVOList) {
                salesmanInfoRespVO.setEmployeeInfoRespVO(employeeInfoRespVOMap.get(salesmanInfoRespVO.getScpsmanNo()));
                salesmanInfoRespVO.setEnableStatusName(salesmanInfoRespVO.getEnableStatus() == 1 ? "启用" : "禁用");
                salesmanInfoRespVO.setScpsmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRespVO.getScpsmanType()));
                salesmanInfoRespVO.setJurisdiction(regionMap.get(salesmanInfoRespVO.getId()));
            }
            return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                    .total(total)
                    .records(salesmanInfoRespVOList)
                    .build());
        }

        //查询符合条件的计划员数据
        SalesmanInfoQueryVO queryParam = new SalesmanInfoQueryVO();
        if (StringUtils.isNotBlank(salesmanInfoQueryVO.getScpsman())) {
            queryParam.setScpsman(salesmanInfoQueryVO.getScpsman());
        }
        if (StringUtils.isNotBlank(salesmanInfoQueryVO.getLoginAccount())) {
            queryParam.setLoginAccount(salesmanInfoQueryVO.getLoginAccount());
        }
        if (StringUtils.isNotBlank(salesmanInfoQueryVO.getOuCode())) {
            queryParam.setOuCode(salesmanInfoQueryVO.getOuCode());
        }
        if (salesmanInfoQueryVO.getEnableStatus() != null) {
            queryParam.setEnableStatus(salesmanInfoQueryVO.getEnableStatus());
        }
        if (StringUtils.isNotBlank(salesmanInfoQueryVO.getScpsmanType())) {
            queryParam.setScpsmanType(salesmanInfoQueryVO.getScpsmanType());
        }
        List<SalesmanSimpleInfoRespVO> salesmanCodeList = scpsmanInfoRepoProc.findAllSalesmanCode(queryParam).fetch();
        if (CollUtil.isEmpty(salesmanCodeList)) {
            return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                    .total(0)
                    .build());
        }
        Set<String> codes =
                salesmanCodeList.stream().map(SalesmanSimpleInfoRespVO::getScpsmanNo).filter(Objects::nonNull).collect(Collectors.toSet());
        log.info("计划员编码数量大小:{}", codes.size());


        //查询所有符合条件的员工信息
        EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
        employeePageQueryDTO.setCodes(codes);
        employeePageQueryDTO.setCurrent(salesmanInfoQueryVO.getCurrent());
        employeePageQueryDTO.setSize(salesmanInfoQueryVO.getSize());
        if (StringUtils.isNotBlank(salesmanInfoQueryVO.getOrgId())) {
            employeePageQueryDTO.setOrgId(Long.parseLong(salesmanInfoQueryVO.getOrgId()));
        }
        if (StringUtils.isNotBlank(salesmanInfoQueryVO.getPhone())) {
            employeePageQueryDTO.setPhone(salesmanInfoQueryVO.getPhone());
        }
        ApiResult<PagingVO<EmployeePageRespDTO>> result = employeeRpcService.queryByPage(employeePageQueryDTO);
        if (!result.isSuccess()) {
            throw new BusinessException("员工信息查询失败！" + result.getMsg());
        }
        //员工数据
        List<EmployeePageRespDTO> employeePageRespDTOList = result.getData().getRecords();
        log.info("查询员工数据结果:{}", JSONUtil.toJsonStr(employeePageRespDTOList));
        if (CollUtil.isEmpty(employeePageRespDTOList)) {
            return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                    .total(0)
                    .build());
        }
        long total = result.getData().getTotal();

        List<String> scpManNoList =
                employeePageRespDTOList.stream().map(EmployeePageRespDTO::getCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        log.info("scpManNoList的值:{}", JSONUtil.toJsonStr(scpManNoList));

        List<EmployeeInfoRespVO> employeeInfoRespVOS =
                SalesmanInfoConvert.INSTANCE.employeePageRespDTOToEmployeeInfoRespVO(employeePageRespDTOList);
        Map<String, EmployeeInfoRespVO> employeeInfoRespVOMap = employeeInfoRespVOS.stream()
                .collect(Collectors.toMap(EmployeeInfoRespVO::getCode, Function.identity(), (k1, k2) -> k1));

        salesmanInfoQueryVO.setCodes(scpManNoList);
        JPAQuery<SalesmanInfoRespVO> jpaQuery = scpsmanInfoRepoProc.findSalesmanInfo(salesmanInfoQueryVO);
        List<SalesmanInfoRespVO> salesmanInfoRespVOList = jpaQuery.fetch();
        if (CollUtil.isEmpty(salesmanInfoRespVOList)) {
            return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                    .total(0)
                    .build());
        }

        Map<Long, List<SalesmanRegionVO>> regionMap = getSalesmanRegionMap(regionUDCMap,
                salesmanInfoRespVOList.stream().map(SalesmanInfoRespVO::getId).collect(Collectors.toList()));
        // 拼接数据
        for (SalesmanInfoRespVO salesmanInfoRespVO : salesmanInfoRespVOList) {
            salesmanInfoRespVO.setEmployeeInfoRespVO(employeeInfoRespVOMap.get(salesmanInfoRespVO.getScpsmanNo()));
            salesmanInfoRespVO.setEnableStatusName(salesmanInfoRespVO.getEnableStatus() == 1 ? "启用" : "禁用");
            salesmanInfoRespVO.setScpsmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRespVO.getScpsmanType()));
            salesmanInfoRespVO.setJurisdiction(regionMap.get(salesmanInfoRespVO.getId()));
        }

        return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                .total(total)
                .records(salesmanInfoRespVOList)
                .build());
    }

    @Override
    public ApiResult<SalesmanInfoDetailRespVO> queryDetail(Long id) {
        log.info("计划员详细信息查询入参 {}", id);
        Optional<ScpsmanInfoDO> ScpsmanInfoDOOptional = scpsmanInfoRepo.findById(id);
        if (ScpsmanInfoDOOptional.isEmpty()) {
            return ApiResult.ok();
        }
        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-suplan", "SCPSMAN_TYPE");
        Map<String, String> regionUDCMap = rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        ScpsmanInfoDO scpsmanInfoDO = ScpsmanInfoDOOptional.get();
        ApiResult<SysEmployeeDetailDTO> detailByCode = employeeRpcService.getDetailByCode(scpsmanInfoDO.getScpsmanNo());
        if (!detailByCode.isSuccess()) {
            throw new BusinessException("查询员工详情信息失败！" + detailByCode.getMsg());
        }
        EmployeeDetailInfoRespVO employeeDetailInfoRespVO = SalesmanInfoConvert.INSTANCE.SysEmployeeDetailDTOToRespVO(detailByCode.getData());
        SalesmanInfoDetailRespVO salesmanInfoDetailRespVO = SalesmanInfoConvert.INSTANCE.salesmanInfoDOToDetailRespVO(scpsmanInfoDO);
        //查询区域信息
        Map<Long, List<SalesmanRegionVO>> salesmanRegionMap = getSalesmanRegionMap(regionUDCMap, List.of(scpsmanInfoDO.getId()));
        salesmanInfoDetailRespVO.setEnableStatusName(salesmanInfoDetailRespVO.getEnableStatus() == 1 ? "启用" : "禁用");
        salesmanInfoDetailRespVO.setScpsmanTypeName(salesmanTypeUDCMap.get(salesmanInfoDetailRespVO.getScpsmanType()));
        salesmanInfoDetailRespVO.setJurisdiction(salesmanRegionMap.get(scpsmanInfoDO.getId()));
        salesmanInfoDetailRespVO.setEmployeeDetailInfoRespVO(employeeDetailInfoRespVO);
        return ApiResult.ok(salesmanInfoDetailRespVO);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> changeStatus(SalesmanInfoChangeVO salesmanInfoChangeVO) {

        log.info("计划员状态信息更改入参 {}", salesmanInfoChangeVO);
        Optional<ScpsmanInfoDO> ScpsmanInfoDO = scpsmanInfoRepo.findById(salesmanInfoChangeVO.getId());
        if (ScpsmanInfoDO.isEmpty()) {
            return ApiResult.fail("未查询到信息");
        }
        if (salesmanInfoChangeVO.isSync()) {
            ApiResult<String> result = employeeRpcService.updateEnabledByCode(salesmanInfoChangeVO.getCode()
                    , salesmanInfoChangeVO.getEnableStatus() == 1);
            if (!result.isSuccess()) {
                throw new BusinessException("更新员工状态失败！" + result.getMsg());
            }
        }
        scpsmanInfoRepoProc.changeEnableStatus(salesmanInfoChangeVO.getId(), salesmanInfoChangeVO.getEnableStatus());
        return ApiResult.ok();
    }

    @Override
    public ScpsmanImportRespVO salesmanImport(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        log.info("计划员导入数据参数:{}",JSONUtil.toJsonStr(recommendRelateCustVOS));
        ScpsmanImportRespVO respVO =  new ScpsmanImportRespVO();
        Map<String, String> errorInfoMap = new HashMap<>();

        List<String> list =
                recommendRelateCustVOS.stream().map(SalesmanImportSaveVO::getScpsmanNo).collect(Collectors.toList());
        if (CollUtil.isEmpty(recommendRelateCustVOS)) {
            throw new BusinessException("导入数据为空");
        }
        StringBuffer failMsg = new StringBuffer();
        boolean failFlag = false;
        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-suplan", "SCPSMAN_TYPE");
        Map<String, String> newTypeMap = salesmanTypeUDCMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map<String, String> regionUDCMap = rmiSysUDCService.getCodeMap("yst-supp", "REGION");
        Map<String, String> newRegionMap = regionUDCMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        //查询填写的业务员编码是否已存在
        Map<String, List<ScpsmanInfoDO>> salesmanMap = getSalesMap(list);
        //查询填写的登陆账号是否已存在
        Map<String, List<ScpsmanInfoDO>> loginMap = getLoginMap(recommendRelateCustVOS);
        //查询填写的组织信息
        Map<String, List<SysOrgBasicDTO>> buMap = getBuMap(recommendRelateCustVOS);
        //查询填写的公司信息是否存在
        Map<String, List<OrgOuRpcDTO>> ouMap = getOuMap(recommendRelateCustVOS);
        //根据上级编码查询上级id
        Map<String, Long> userCodeIdMap = getLeaderMap(recommendRelateCustVOS);
        //查询所有的省市区
        List<String> areaNameList = new ArrayList<>();
        Map<String, List<SysAreaRespDTO>> areaMap = new HashMap<>();
        ApiResult<List<SysAreaRespDTO>> areaList = sysAreaRpcService.queryList(new SysAreaQueryDTO());
        if (!areaList.isSuccess()){
            throw new BusinessException("查询省市区信息失败！" + areaList.getMsg());
        }
        List<SysAreaRespDTO> areaListData = areaList.getData();
        if (CollUtil.isNotEmpty(areaListData)){
            areaNameList = areaListData.stream().map(SysAreaRespDTO::getAreaName).collect(Collectors.toList());
            areaMap = areaListData.stream().collect(Collectors.groupingBy(SysAreaRespDTO::getAreaName));
        }else {
            throw new BusinessException("未查询到省市区信息！" );
        }

        //检查导入数据
        failFlag = checkData(errorInfoMap,failFlag, recommendRelateCustVOS, failMsg, salesmanMap, loginMap, buMap,
                userCodeIdMap,
                ouMap, newTypeMap, newRegionMap, areaNameList);
        /*if(failFlag){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, failMsg.toString());
        }*/
        //校验员工数据是否可以保存
        failFlag = checkEmployee(errorInfoMap,recommendRelateCustVOS, failMsg, failFlag, buMap);
       /* if(failFlag){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, failMsg.toString());
        }*/

       //过滤掉有错误信息的行数据
        List<SalesmanImportSaveVO> filterdRecommendRelateCustVOS=
                recommendRelateCustVOS.stream().filter(e->!errorInfoMap.containsKey(e.getScpsmanNo())).collect(Collectors.toList());
        log.info("过滤后的数据行:{},数据大小:{}",JSONUtil.toJsonStr(filterdRecommendRelateCustVOS),
                filterdRecommendRelateCustVOS.size());
        if(CollUtil.isEmpty(filterdRecommendRelateCustVOS)){
            log.info("过滤后无数据需要处理,返回");
            respVO.setErrorInfoMap(errorInfoMap);
            return respVO;
        }
       // int line = 1;
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        //一个一个保存
        Map<String, List<SysAreaRespDTO>> finalAreaMap = areaMap;
        for (SalesmanImportSaveVO recommendRelateCustVO : filterdRecommendRelateCustVOS) {
            transactionTemplate.execute(transactionStatus -> {
                try {
                    //业务员信息
                    ScpsmanInfoDO ScpsmanInfoDO = SalesmanInfoConvert.INSTANCE.salesmanImportSaveToDO(recommendRelateCustVO);
                    ScpsmanInfoDO.setEnableStatus(1);
                    ScpsmanInfoDO.setScpsmanType(newTypeMap.get(ScpsmanInfoDO.getScpsmanType()));
                    ScpsmanInfoDO.setOuName(ouMap.get(ScpsmanInfoDO.getOuCode()).get(0).getOuName());
                    //区域
                    List<String> regions = new ArrayList<>();
                    if (StringUtils.isNotBlank(ScpsmanInfoDO.getJurisdiction())) {
                        String[] jurisdictions = ScpsmanInfoDO.getJurisdiction().split("[;；]");
                        regions = List.of(jurisdictions);
                    }

                    //创建新员工
                    EmployeeUpsertDTO upsertDTO = SalesmanInfoConvert.INSTANCE.salesmanImportSaveVOToUpsertDTO(recommendRelateCustVO);
                    if (recommendRelateCustVO.getSex()!=null) {
                        upsertDTO.setGender(recommendRelateCustVO.getSex().equals("1") ? "MALE" : "FEMALE");
                    }
                    AreaVO areaVO = new AreaVO();
                    List<String> patterns = Lists.newArrayList("yyyy-MM-dd","yyyy-M-d","yyyy/MM/dd","yyyy/M/d");
                    if (StringUtils.isNotBlank(recommendRelateCustVO.getBirthdayTimeStr())){
                        String pattern = isValid(recommendRelateCustVO.getBirthdayTimeStr(),patterns);
                        if(StringUtils.isBlank(pattern)){
                           // putFailMsg(errorInfoMap,recommendRelateCustVO.getScpsmanNo(),"出生日期请按照指定的日期格式");
                            throw new BusinessException("出生日期请按照指定的日期格式");
                        }
                        upsertDTO.setBirthDate(constant.stringToLocalDatePattern(recommendRelateCustVO.getBirthdayTimeStr(),pattern));
                    }
                    if (StringUtils.isNotBlank(recommendRelateCustVO.getJoinTimeStr())) {
                        String pattern = isValid(recommendRelateCustVO.getJoinTimeStr(),patterns);
                        if(StringUtils.isBlank(pattern)){
                          //  putFailMsg(errorInfoMap,recommendRelateCustVO.getScpsmanNo(),"入职日期请按照指定的日期格式");
                            throw new BusinessException("入职日期请按照指定的日期格式");

                        }
                        upsertDTO.setJoinTime(constant.parseLocalDate(recommendRelateCustVO.getJoinTimeStr(),pattern));
                    }
                    //省市区信息
                    areaVO.setProvinceName(recommendRelateCustVO.getProvince());
                    areaVO.setCityName(recommendRelateCustVO.getCity());
                    areaVO.setCountyName(recommendRelateCustVO.getArea());
                    if (CollUtil.isNotEmpty(finalAreaMap.get(recommendRelateCustVO.getProvince()))){
                        areaVO.setProvinceCode(finalAreaMap.get(recommendRelateCustVO.getProvince()).get(0).getAreaCode());
                    }
                    if (CollUtil.isNotEmpty(finalAreaMap.get(recommendRelateCustVO.getCity()))){
                        areaVO.setCityCode(finalAreaMap.get(recommendRelateCustVO.getCity()).get(0).getAreaCode());
                    }
                    if (CollUtil.isNotEmpty(finalAreaMap.get(recommendRelateCustVO.getArea()))){
                        areaVO.setCountyCode(finalAreaMap.get(recommendRelateCustVO.getArea()).get(0).getAreaCode());
                    }
                    upsertDTO.setAreaVO(areaVO);
                    EmployeeUpsertDTO.EmployeeOrg employeeOrg = new EmployeeUpsertDTO.EmployeeOrg();
                    if (StringUtils.isNotBlank(recommendRelateCustVO.getLeaderUserCode())) {
                        employeeOrg.setLeaderUserId(userCodeIdMap.get(recommendRelateCustVO.getLeaderUserCode()));
                    }
                    if (CollUtil.isNotEmpty(buMap.get(recommendRelateCustVO.getBuCode()))){
                        employeeOrg.setOrgId(buMap.get(recommendRelateCustVO.getBuCode()).get(0).getId());
                    }
                    upsertDTO.setOrgList(List.of(employeeOrg));
                    upsertDTO.setCode(recommendRelateCustVO.getScpsmanNo());
                //    upsertDTO.setType(UdcEnum.CUST_TYPE_SCPSMAN.getValueCode());

                    //保存业务员信息
                    ScpsmanInfoDO save = scpsmanInfoRepo.save(ScpsmanInfoDO);
                    if (Optional.ofNullable(save).isEmpty()) {
                        throw new BusinessException("调用计划员保存接口失败！");
                    }

                    //传递业务员id和类型
                    appendUserTypeToEmployeeUpsertDTO(upsertDTO, String.valueOf(save.getId()));

                    //创建新用户
                    ApiResult<String> result = employeeRpcService.upsert(upsertDTO);
                    if (!result.isSuccess()) {
                        throw new BusinessException("调用创建新员工接口失败！ "+result.getMsg());
                    }
                    //保存业务员区域信息
                    List<ScpsmanRegionDO> regionDOS = new ArrayList<>();
                    if (CollUtil.isNotEmpty(regions)) {
                        for (String jurisdiction : regions) {
                            ScpsmanRegionDO ScpsmanRegionDO = new ScpsmanRegionDO();
                            ScpsmanRegionDO.setRegionCode(newRegionMap.get(jurisdiction));
                            ScpsmanRegionDO.setMasId(save.getId());
                            regionDOS.add(ScpsmanRegionDO);
                        }
                        salesmanRegionRepo.saveAll(regionDOS);
                    }
                } catch (BusinessException e) {
                    log.error("计划员导入报错：" + e);
                    putFailMsg(errorInfoMap,recommendRelateCustVO.getScpsmanNo(),e.getMessage());
                    // 回滚数据
                    transactionStatus.setRollbackOnly();
                }
                return null;
                // line++;
            });
        }
        respVO.setErrorInfoMap(errorInfoMap);
        return respVO;
    }

    @Override
    public SalesmanLevelInfoDTO queryLevelInfo(Long id) {
        if (id == null){
            throw new BusinessException("id 不允许为空!");
        }
        SalesmanLevelInfoDTO salesmanLevelInfoDTO = new SalesmanLevelInfoDTO();
        List<SalesmanLevelInfoDTO.path> paths = new ArrayList<>();
        StringBuffer codeBuffer = new StringBuffer();
        //业务员信息
        ScpsmanInfoDO infoDO = scpsmanInfoRepoProc.get(id);
        if (Optional.ofNullable(infoDO).isEmpty()){
            throw new BusinessException(" 未获取到业务员信息，请稍后重试");
        }

        SalesmanLevelInfoDTO.path path = new SalesmanLevelInfoDTO.path();
        salesmanLevelInfoDTO.setId(infoDO.getId());
        salesmanLevelInfoDTO.setScpsmanNo(infoDO.getScpsmanNo());
        //查询上级和自己的信息（区域经理）
        ApiResult<SysEmployeeDetailDTO> salesmanDetailInfo = employeeRpcService.getDetailByCode(infoDO.getScpsmanNo());
        SysEmployeeDetailDTO salesmanDetailInfoData = salesmanDetailInfo.getData();
        if (!salesmanDetailInfo.isSuccess() || Optional.ofNullable(salesmanDetailInfoData).isEmpty()){
            return salesmanLevelInfoDTO;
        }
        path.setLevel(0);
        path.setCode(infoDO.getScpsmanNo());
        path.setType(infoDO.getScpsmanType());
        path.setName(salesmanDetailInfoData.getFullName());
        codeBuffer.append(infoDO.getScpsmanNo());
        paths.add(path);
        salesmanLevelInfoDTO.setSalesmanPathCode(codeBuffer.toString());
        salesmanLevelInfoDTO.setSalesman_path(paths);

        //业务员信息
        salesmanLevelInfoDTO.setId(infoDO.getId());
        salesmanLevelInfoDTO.setScpsmanNo(salesmanDetailInfoData.getCode());
        salesmanLevelInfoDTO.setSalesmanName(salesmanDetailInfoData.getFullName());
        salesmanLevelInfoDTO.setSalesmanId(salesmanDetailInfoData.getId());
        String reCode = "";
        if (CollUtil.isNotEmpty(salesmanDetailInfoData.getOrgList()) && StringUtils.isNotBlank(salesmanDetailInfoData.getOrgList().get(0).getLeaderEmployeeCode())){
            reCode = salesmanDetailInfoData.getOrgList().get(0).getLeaderEmployeeCode();
            Long reCId = salesmanDetailInfoData.getOrgList().get(0).getLeaderEmployeeId();
            String leaderUserFullName = salesmanDetailInfoData.getOrgList().get(0).getLeaderUserFullName();
            salesmanLevelInfoDTO.setSalesmanPathCode(buildPath(reCode, 1, paths, codeBuffer, leaderUserFullName));
            salesmanLevelInfoDTO.setSalesman_path(paths);
            salesmanLevelInfoDTO.setRemanageId(reCId);
            salesmanLevelInfoDTO.setRemanageNo(reCode);
            salesmanLevelInfoDTO.setRemanagerName(leaderUserFullName);
        }
        //查询上级信息（省区经理）
        if (StringUtils.isBlank(reCode)){
            return salesmanLevelInfoDTO;
        }
        ApiResult<SysEmployeeDetailDTO> remanagerDetailInfo = employeeRpcService.getDetailByCode(reCode);
        SysEmployeeDetailDTO remanagerDetailInfoData = remanagerDetailInfo.getData();
        if (!remanagerDetailInfo.isSuccess() || Optional.ofNullable(remanagerDetailInfoData).isEmpty()
                || StringUtils.isBlank(remanagerDetailInfoData.getOrgList().get(0).getLeaderEmployeeCode())){
            return salesmanLevelInfoDTO;
        }
        String prCode = remanagerDetailInfoData.getOrgList().get(0).getLeaderEmployeeCode();
        Long prId = remanagerDetailInfoData.getOrgList().get(0).getLeaderEmployeeId();
        String leaderUserFullName = remanagerDetailInfoData.getOrgList().get(0).getLeaderUserFullName();
        salesmanLevelInfoDTO.setSalesmanPathCode(buildPath(prCode, 2, paths, codeBuffer, leaderUserFullName));
        salesmanLevelInfoDTO.setSalesman_path(paths);
        salesmanLevelInfoDTO.setPrmanagerNo(prCode);
        salesmanLevelInfoDTO.setPrmanagerId(prId);
        salesmanLevelInfoDTO.setPrmanagerName(leaderUserFullName);
        //查询上级信息（销售总监）
        if (StringUtils.isBlank(prCode)){
            return salesmanLevelInfoDTO;
        }
        ApiResult<SysEmployeeDetailDTO> prmanagerDetailInfo = employeeRpcService.getDetailByCode(prCode);
        SysEmployeeDetailDTO prmanagerDetailInfoData = prmanagerDetailInfo.getData();
        if (!prmanagerDetailInfo.isSuccess() || Optional.ofNullable(prmanagerDetailInfoData).isEmpty()
                || StringUtils.isBlank(prmanagerDetailInfoData.getOrgList().get(0).getLeaderEmployeeCode())){
            return salesmanLevelInfoDTO;
        }
        String chCode = prmanagerDetailInfoData.getOrgList().get(0).getLeaderEmployeeCode();
        Long chId = prmanagerDetailInfoData.getOrgList().get(0).getLeaderEmployeeId();
        String leaderUserFullNameEnd = prmanagerDetailInfoData.getOrgList().get(0).getLeaderUserFullName();
        salesmanLevelInfoDTO.setSalesmanPathCode(buildPath(chCode, 3, paths, codeBuffer, leaderUserFullNameEnd));
        salesmanLevelInfoDTO.setSalesman_path(paths);
        salesmanLevelInfoDTO.setChiefNo(chCode);
        salesmanLevelInfoDTO.setChiefId(chId);
        salesmanLevelInfoDTO.setChiefName(leaderUserFullNameEnd);
        salesmanLevelInfoDTO.setSalesman_path(paths);
        return salesmanLevelInfoDTO;
    }

    @Override
    public ApiResult<PagingVO<SalesmanDetailInfoRespVO>> querySalesmanAllInfo(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        log.info("业务员全部信息查询入参 {}", salesmanInfoQueryVO);
        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-suplan", "SCPSMAN_TYPE");
        Map<String, String> regionUDCMap = rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        //返回的数据
        List<SalesmanDetailInfoRespVO> salesmanDetailInfoRespVOS = new ArrayList<>();
        //包含业务员条件查询或无条件查询
        if (salesmanInfoQueryVO.getEnableStatus() != null
                || StringUtils.isNotBlank(salesmanInfoQueryVO.getOuCode())
                || StringUtils.isNotBlank(salesmanInfoQueryVO.getScpsmanType())
                || salesmanInfoQueryVO.getNoQueryParam() == 1) {
            JPAQuery<SalesmanDetailInfoRespVO> jpaQuery =
                    scpsmanInfoRepoProc.findSalesmanInfoDetail(salesmanInfoQueryVO);
            List<SalesmanDetailInfoRespVO> salesmanInfoRespVOList = jpaQuery.fetch();
            if (CollUtil.isEmpty(salesmanInfoRespVOList)) {
                return ApiResult.ok();
            }
            //组装区域信息
            Map<String, String> regionMap = buildReion(regionUDCMap, salesmanInfoRespVOList);

            //业务员map
            Map<String, SalesmanDetailInfoRespVO> salesmanMap = salesmanInfoRespVOList.stream()
                    .collect(Collectors.toMap(SalesmanDetailInfoRespVO::getScpsmanNo, Function.identity(), (k1, k2) -> k1));
            Set<String> codeList =
                    salesmanInfoRespVOList.stream().map(SalesmanDetailInfoRespVO::getScpsmanNo).collect(Collectors.toSet());
            EmployeePageQueryDTO employeePageQueryDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoQueryVOToQueryDTO(salesmanInfoQueryVO);
            employeePageQueryDTO.setKeyword(salesmanInfoQueryVO.getScpsman());
            employeePageQueryDTO.setCodes(codeList);
            ApiResult<PagingVO<EmployeePageRespDTO>> result = employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!result.isSuccess()) {
                throw new BusinessException("员工信息查询失败！" + result.getMsg());
            }

            //员工数据
            List<EmployeePageRespDTO> employeePageRespDTOList = new ArrayList<>();
            if (Optional.ofNullable(result.getData()).isPresent()){
                employeePageRespDTOList = result.getData().getRecords();
            }
            if (CollUtil.isEmpty(employeePageRespDTOList)){
                ApiResult.ok(PagingVO.<SalesmanDetailInfoRespVO>builder()
                        .records(salesmanDetailInfoRespVOS));
            }
            Set<String> detailCodeSet = employeePageRespDTOList.stream().map(EmployeePageRespDTO::getCode).collect(Collectors.toSet());
            ApiResult<List<SysEmployeeDetailDTO>> apiResult = employeeRpcService.getDetailListByCode(detailCodeSet);
            if (!apiResult.isSuccess()) {
                throw new BusinessException("员工信息查询失败！" + apiResult.getMsg());
            }
            //需要的员工详情
            List<SysEmployeeDetailDTO> detailDTOS = apiResult.getData();
            if (CollUtil.isEmpty(detailDTOS)){
                return ApiResult.ok();
            }
            for (SysEmployeeDetailDTO detailDTO : detailDTOS) {
                SalesmanDetailInfoRespVO salesmanDetailInfoRespVO = new SalesmanDetailInfoRespVO();
                if (Optional.ofNullable(salesmanMap.get(detailDTO.getCode())).isPresent()){
                    salesmanDetailInfoRespVO.setOuName(salesmanMap.get(detailDTO.getCode()).getOuName());
                    salesmanDetailInfoRespVO.setId(salesmanMap.get(detailDTO.getCode()).getId());
                    salesmanDetailInfoRespVO.setScpsmanNo(salesmanMap.get(detailDTO.getCode()).getScpsmanNo());
                    salesmanDetailInfoRespVO.setScpsmanType(salesmanTypeUDCMap.get(salesmanMap.get(detailDTO.getCode()).getScpsmanType()));
                    salesmanDetailInfoRespVO.setEnableStatusName(salesmanMap.get(detailDTO.getCode()).getEnableStatus() == 1 ? "启用" : "禁用");
                }
                salesmanDetailInfoRespVO.setJurisdiction(regionMap.get(detailDTO.getCode()));
                salesmanDetailInfoRespVO.setJoinTime(detailDTO.getJoinTime());
                if(ObjectUtils.isNotEmpty(detailDTO.getJoinTime())){
                    salesmanDetailInfoRespVO.setJoinTimeLocalDate(detailDTO.getJoinTime().toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                }
                salesmanDetailInfoRespVO.setUsername(detailDTO.getUsername());
                salesmanDetailInfoRespVO.setFullName(detailDTO.getFullName());
                salesmanDetailInfoRespVO.setGenderName(detailDTO.getGenderName());
                salesmanDetailInfoRespVO.setEmail(detailDTO.getEmail());
                salesmanDetailInfoRespVO.setPhone(detailDTO.getPhone());
                salesmanDetailInfoRespVO.setBirthDate(detailDTO.getBirthDate() == null ? null : detailDTO.getBirthDate().format(DateTimeFormatter.ISO_LOCAL_DATE));
                salesmanDetailInfoRespVO.setIdCard(detailDTO.getIdCard());
                salesmanDetailInfoRespVO.setProvinceName(detailDTO.getAreaVO().getProvinceName());
                salesmanDetailInfoRespVO.setCityName(detailDTO.getAreaVO().getCityName());
                salesmanDetailInfoRespVO.setCountyName(detailDTO.getAreaVO().getCountyName());
                salesmanDetailInfoRespVO.setAddress(detailDTO.getAddress());
                if (CollUtil.isNotEmpty(detailDTO.getOrgList())) {
                    salesmanDetailInfoRespVO.setOrgName(detailDTO.getOrgList().get(0).getOrgName());
                    salesmanDetailInfoRespVO.setLeaderUserFullName(detailDTO.getOrgList().get(0).getLeaderUserFullName());
                }
                salesmanDetailInfoRespVOS.add(salesmanDetailInfoRespVO);
            }
            log.info("计划员导出结果:{}", JSONUtil.toJsonStr(salesmanDetailInfoRespVOS));
            return ApiResult.ok(PagingVO.<SalesmanDetailInfoRespVO>builder()
                    .records(salesmanDetailInfoRespVOS)
                    .total(salesmanDetailInfoRespVOS.size())
                    .build());

            //只包含员工查询条件
        } else if (salesmanInfoQueryVO.getNoQueryParam() != 1) {
            EmployeePageQueryDTO employeePageQueryDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoQueryVOToQueryDTO(salesmanInfoQueryVO);
            employeePageQueryDTO.setKeyword(salesmanInfoQueryVO.getScpsman());
            //先查询员工信息
            ApiResult<PagingVO<EmployeePageRespDTO>> result = employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!result.isSuccess()) {
                throw new BusinessException("员工信息查询失败！" + result.getMsg());
            }
            if (result.getData().getTotal() == 0) {
                return ApiResult.ok();
            }
            List<EmployeePageRespDTO> employeePageRespDTOS = result.getData().getRecords();
            Set<String> codeSet = employeePageRespDTOS.stream().map(EmployeePageRespDTO::getCode).collect(Collectors.toSet());
            ApiResult<List<SysEmployeeDetailDTO>> apiResult = employeeRpcService.getDetailListByCode(codeSet);
            if (!apiResult.isSuccess()) {
                throw new BusinessException("员工详情信息查询失败！" + apiResult.getMsg());
            }
            List<SysEmployeeDetailDTO> employeeDetailDTOS = apiResult.getData();
            if (CollUtil.isEmpty(employeeDetailDTOS)) {
                return ApiResult.ok();
            }
            List<String> codes = employeeDetailDTOS.stream().map(SysEmployeeDetailDTO::getCode).collect(Collectors.toList());
            //业务员信息
            List<ScpsmanInfoDO> salesmanInfoDOS = scpsmanInfoRepo.findByScpsmanNoIn(codes);
            if (CollUtil.isEmpty(salesmanInfoDOS)){
                return ApiResult.ok();
            }
            //组装区域信息
            Map<String, String> regionMap = new HashMap<>();
            Map<Long, List<SalesmanRegionVO>> idRegionMap = getSalesmanRegionMap(regionUDCMap, salesmanInfoDOS.stream().map(ScpsmanInfoDO::getId).collect(Collectors.toList()));
            for (ScpsmanInfoDO salesmanInfoDO : salesmanInfoDOS) {
                StringBuffer stringBuffer = new StringBuffer();
                if (CollUtil.isNotEmpty(idRegionMap.get(salesmanInfoDO.getId()))){
                    for (SalesmanRegionVO regionVO : idRegionMap.get(salesmanInfoDO.getId())) {
                        if (StringUtils.isNotBlank(regionVO.getRegionName())) {
                            stringBuffer = stringBuffer.append(regionVO.getRegionName() + " ");
                        }
                    }
                    regionMap.put(salesmanInfoDO.getScpsmanNo(), stringBuffer.toString());
                }
            }
            //业务员map
            Map<String, ScpsmanInfoDO> salesmanInfoDOMap = salesmanInfoDOS.stream()
                    .collect(Collectors.toMap(ScpsmanInfoDO::getScpsmanNo, Function.identity(), (k1, k2) -> k1));
            for (SysEmployeeDetailDTO detailDTO : employeeDetailDTOS) {
                SalesmanDetailInfoRespVO salesmanDetailInfoRespVO = new SalesmanDetailInfoRespVO();
                if (Optional.ofNullable(salesmanInfoDOMap.get(detailDTO.getCode())).isPresent()){
                    salesmanDetailInfoRespVO.setId(salesmanInfoDOMap.get(detailDTO.getCode()).getId());
                    salesmanDetailInfoRespVO.setOuName(salesmanInfoDOMap.get(detailDTO.getCode()).getOuName());
                    salesmanDetailInfoRespVO.setScpsmanNo(salesmanInfoDOMap.get(detailDTO.getCode()).getScpsmanNo());
                    salesmanDetailInfoRespVO.setScpsmanType(salesmanTypeUDCMap.get(salesmanInfoDOMap.get(detailDTO.getCode()).getScpsmanType()));
                    salesmanDetailInfoRespVO.setEnableStatusName(salesmanInfoDOMap.get(detailDTO.getCode()).getEnableStatus() == 1 ? "启用" : "禁用");
                }
                salesmanDetailInfoRespVO.setJurisdiction(regionMap.get(detailDTO.getCode()));
                salesmanDetailInfoRespVO.setJoinTime(detailDTO.getJoinTime());
                if(ObjectUtils.isNotEmpty(detailDTO.getJoinTime())){
                    salesmanDetailInfoRespVO.setJoinTimeLocalDate(detailDTO.getJoinTime().toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                }
                salesmanDetailInfoRespVO.setUsername(detailDTO.getUsername());
                salesmanDetailInfoRespVO.setFullName(detailDTO.getFullName());
                salesmanDetailInfoRespVO.setGenderName(detailDTO.getGenderName());
                salesmanDetailInfoRespVO.setEmail(detailDTO.getEmail());
                salesmanDetailInfoRespVO.setPhone(detailDTO.getPhone());
                salesmanDetailInfoRespVO.setBirthDate(detailDTO.getBirthDate()==null?null:detailDTO.getBirthDate().format(DateTimeFormatter.ISO_LOCAL_DATE));
                salesmanDetailInfoRespVO.setIdCard(detailDTO.getIdCard());
                salesmanDetailInfoRespVO.setProvinceName(detailDTO.getAreaVO().getProvinceName());
                salesmanDetailInfoRespVO.setCityName(detailDTO.getAreaVO().getCityName());
                salesmanDetailInfoRespVO.setCountyName(detailDTO.getAreaVO().getCountyName());
                salesmanDetailInfoRespVO.setAddress(detailDTO.getAddress());
                if (CollUtil.isNotEmpty(detailDTO.getOrgList())){
                    salesmanDetailInfoRespVO.setOrgName(detailDTO.getOrgList().get(0).getOrgName());
                    salesmanDetailInfoRespVO.setLeaderUserFullName(detailDTO.getOrgList().get(0).getLeaderUserFullName());
                }
                salesmanDetailInfoRespVOS.add(salesmanDetailInfoRespVO);
            }
            log.info("计划员导出结果:{}", JSONUtil.toJsonStr(salesmanDetailInfoRespVOS));
            return ApiResult.ok(PagingVO.<SalesmanDetailInfoRespVO>builder()
                    .records(salesmanDetailInfoRespVOS)
                    .total(salesmanDetailInfoRespVOS.size())
                    .build());
        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<PagingVO<SalesmanInfoRespVO>> querySubordinate(SalesmanSubordinateQueryVO salesmanSubordinateQueryVO) {
        log.info("业务员下级信息查询入参 {}", salesmanSubordinateQueryVO);
        ApiResult<List<EmployeeUnderlingDTO>> apiResult = employeeRpcService.getUnderlingByCode(salesmanSubordinateQueryVO.getCode(), true, null);
        if (!apiResult.isSuccess()) {
            throw new BusinessException("查询员工下级信息失败！" + apiResult.getMsg());
        }
        //员工信息
        List<EmployeeUnderlingDTO> resultData = apiResult.getData();
        List<String> codeList = new ArrayList<>();
        if (CollUtil.isEmpty(resultData)) {
            return ApiResult.ok();
        }
        codeList.addAll(resultData.stream().map(EmployeeUnderlingDTO::getCode).collect(Collectors.toList()));
        List<EmployeeInfoRespVO> employeeInfoRespVOS = SalesmanInfoConvert.INSTANCE.employeeUnderlingDTOToRespVO(resultData);
        Map<String, EmployeeInfoRespVO> employeeInfoRespVOMap = employeeInfoRespVOS.stream()
                .collect(Collectors.toMap(EmployeeInfoRespVO::getCode, Function.identity(), (k1, k2) -> k1));
        //业务员信息
        JPAQuery<SalesmanInfoRespVO> jpaQuery = scpsmanInfoRepoProc.findByRelateCode(codeList,
                salesmanSubordinateQueryVO);
        List<SalesmanInfoRespVO> salesmanInfoRespVOS = jpaQuery.fetch();
        if (CollUtil.isEmpty(salesmanInfoRespVOS)) {
            return ApiResult.ok();
        }
        //翻译UDC,拼接数据
        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-suplan", "SCPSMAN_TYPE");
        Map<String, String> regionUDCMap = rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());

        Map<Long, List<SalesmanRegionVO>> salesmanRegionMap = getSalesmanRegionMap(regionUDCMap, salesmanInfoRespVOS.stream().map(SalesmanInfoRespVO::getId).collect(Collectors.toList()));
        for (SalesmanInfoRespVO salesmanInfoRespVO : salesmanInfoRespVOS) {
            salesmanInfoRespVO.setEnableStatusName(salesmanInfoRespVO.getEnableStatus() == 1 ? "启用" : "禁用");
            salesmanInfoRespVO.setScpsmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRespVO.getScpsmanType()));
            salesmanInfoRespVO.setJurisdiction(salesmanRegionMap.get(salesmanInfoRespVO.getId()));
            salesmanInfoRespVO.setEmployeeInfoRespVO(employeeInfoRespVOMap.get(salesmanInfoRespVO.getScpsmanNo()));
            if (CollUtil.isNotEmpty(salesmanInfoRespVO.getEmployeeInfoRespVO().getUnderlingList())){
                salesmanInfoRespVO.setHasUnder(true);
            }
        }

        return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(salesmanInfoRespVOS)
                .build());
    }

    @Transactional
    @Override
    public void autoManInfo() {
        //查询所有的门店数据 获取到联系人信息
        List<String> codes = rmiOrgStoreRpcService.queryAllStoreCodes();
        //获取门店的详细数据
        List<OrgStoreDetailRpcDTO> storeData = rmiOrgStoreRpcService.queryByStoreCodes(codes);
        Map<Long, OrgStoreDetailRpcDTO> storeMap = storeData.stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getId, t -> t));
        SysSettingVO sysSettingVO = settingService.oneByNo("BELONG_OU");
        if(sysSettingVO==null){
            throw new BusinessException("请检查默认所属公司配置");
        }
        String ouCodes = sysSettingVO.getSettingVal();
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuCodes(Collections.singletonList(ouCodes));
        List<OrgOuRpcDTO> ouDtoByParam = orgOuRpcService.findOuDtoByParam(orgOuRpcDtoParam);
        OrgOuRpcDTO orgOuRpcDTO = ouDtoByParam.get(0);
        //todo  只新建 店长和法人的账号
        List<OrgContactRpcDTO> contract=new ArrayList<>();
        storeData.forEach(vo->{
            contract.addAll(vo.getOrgContactRpcDTOS().stream().filter(vod-> !StringUtils.isEmpty(vod.getMobile())).collect(Collectors.toList()));
        });
        Map<String, List<OrgContactRpcDTO>> contacts = contract.stream().collect(Collectors.groupingBy(OrgContactRpcDTO::getMobile));
        //根据手机号生成业务员 value是多个门店的信息
        for(String key:contacts.keySet()){
            //根据手机号查询账号数据
            SysUserBasicDTO data = userRpcService.getByUsername(key).getData();
            if(data!=null){
                //获取关联员工数据
                SysEmployeeBasicDTO empData = employeeRpcService.getByUserId(data.getId()).getData();
                ScpsmanInfoDO bySalesmanNo = scpsmanInfoRepo.findByScpsmanNo(empData.getCode());
                SalesmanInfoSaveVO salesmanInfoSaveVO = new SalesmanInfoSaveVO();
                //如果已经存在就更新
                if(bySalesmanNo!=null){
                    //更新
                    salesmanInfoSaveVO.setId(bySalesmanNo.getId());
                }
                salesmanInfoSaveVO.setEmail(empData.getEmail());
                salesmanInfoSaveVO.setName(empData.getLastName());
                //加入时间 取不到
                //salesmanInfoSaveVO.setJoinTime(empData.get);
                salesmanInfoSaveVO.setLoginAccount(key);
                salesmanInfoSaveVO.setPhone(key);
                salesmanInfoSaveVO.setScpsmanNo(empData.getCode());
                salesmanInfoSaveVO.setSource("EMP");
                //salesmanInfoSaveVO.setSourceStoreCode(vo.getStoreCode());
                //所属组织
                salesmanInfoSaveVO.setBuId(empData.getOrgId());
                ScpsmanInfoDO scpsmanInfoDO = SalesmanInfoConvert.INSTANCE.salesmanInfoSaveToDO(salesmanInfoSaveVO);
                scpsmanInfoDO.setEnableStatus(1);
                scpsmanInfoDO.setOuId(orgOuRpcDTO.getId());
                scpsmanInfoDO.setOuCode(orgOuRpcDTO.getOuCode());
                scpsmanInfoDO.setOuName(orgOuRpcDTO.getOuName());

                //保存计划员信息
                ScpsmanInfoDO save = scpsmanInfoRepo.save(scpsmanInfoDO);


                //保存计划员区域
                List<ScpsmanRegionDO> scpsmanRegionDOS = new ArrayList<>();
                salesmanRegionRepo.deleteByMasId(save.getId());
                if (CollUtil.isNotEmpty(contacts.get(key))){
                    contacts.get(key).forEach(vo->{
                        ScpsmanRegionDO scpsmanRegionDO = new ScpsmanRegionDO();
                        scpsmanRegionDO.setRegionCode(storeMap.get(vo.getMasId()).getRegion());
                        scpsmanRegionDO.setMasId(save.getId());
                        scpsmanRegionDOS.add(scpsmanRegionDO);
                    });
                    salesmanRegionRepo.saveAll(scpsmanRegionDOS);
                }
                ScpsmanAuthorityDO byScpsmanId = scpDemandAuthorityRepo.findByScpsmanId(save.getId());
                //组装权限数据
                ScpsmanAuthorityDO scpManAuthoritySaveVO = new ScpsmanAuthorityDO();
                if(byScpsmanId!=null){
                    scpManAuthoritySaveVO.setId(byScpsmanId.getId());
                }
                scpManAuthoritySaveVO.setOuCode(orgOuRpcDTO.getOuCode());
                scpManAuthoritySaveVO.setOuName(orgOuRpcDTO.getOuName());
                scpManAuthoritySaveVO.setOuId(orgOuRpcDTO.getId());
                scpManAuthoritySaveVO.setScpsmanNo(save.getScpsmanNo());
                scpManAuthoritySaveVO.setEnableStatus(true);
                scpManAuthoritySaveVO.setScpsmanId(save.getId());
                ScpsmanAuthorityDO save1 = scpDemandAuthorityRepo.save(scpManAuthoritySaveVO);
                //删除
                scpDemandAuthorityDService.deleteByIds(Arrays.asList(save1.getId()));
                List<ScpsmanAuthorityDDO> ddos = contacts.get(key).stream().map(vo -> {
                    ScpsmanAuthorityDDO scpsmanAuthorityDDO = new ScpsmanAuthorityDDO();
                    scpsmanAuthorityDDO.setAuthSource(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                    scpsmanAuthorityDDO.setMasId(save1.getId());
                    scpsmanAuthorityDDO.setType(0);
                    scpsmanAuthorityDDO.setRegion(storeMap.get(vo.getMasId()).getRegion());
                    scpsmanAuthorityDDO.setStWhId(storeMap.get(vo.getMasId()).getId());
                    scpsmanAuthorityDDO.setStWhCode(storeMap.get(vo.getMasId()).getStoreCode());
                    scpsmanAuthorityDDO.setStWhName(storeMap.get(vo.getMasId()).getStoreName());
                    return scpsmanAuthorityDDO;
                }).collect(Collectors.toList());
                scpDemandAuthorityDRepo.saveAll(ddos);

            }
        }

    }

    private Map<String, String> buildReion(Map<String, String> regionUDCMap, List<SalesmanDetailInfoRespVO> salesmanInfoRespVOList) {
        Map<String, String> regionMap = new HashMap<>();
        Map<Long, List<SalesmanRegionVO>> idRegionMap = getSalesmanRegionMap(regionUDCMap, salesmanInfoRespVOList.stream().map(SalesmanDetailInfoRespVO::getId).collect(Collectors.toList()));
        for (SalesmanDetailInfoRespVO salesmanDetailInfoRespVO : salesmanInfoRespVOList) {
            StringBuffer stringBuffer = new StringBuffer();
            if (CollUtil.isNotEmpty(idRegionMap.get(salesmanDetailInfoRespVO.getId()))){
                for (SalesmanRegionVO regionVO : idRegionMap.get(salesmanDetailInfoRespVO.getId())) {
                    if (StringUtils.isNotBlank(regionVO.getRegionName())) {
                        stringBuffer = stringBuffer.append(regionVO.getRegionName() + " ");
                    }
                }
                regionMap.put(salesmanDetailInfoRespVO.getScpsmanNo(), stringBuffer.toString());
            }
        }
        return regionMap;
    }

    private String buildPath(String code, int level, List<SalesmanLevelInfoDTO.path> paths, StringBuffer code1, String leaderUserFullName) {
        ScpsmanInfoDO infoDO3 = scpsmanInfoRepo.findByScpsmanNo(code);
        if (Optional.ofNullable(infoDO3).isPresent()){
            SalesmanLevelInfoDTO.path path1 = new SalesmanLevelInfoDTO.path();
            code1.append(",");
            code1.append(infoDO3.getScpsmanNo());
            path1.setLevel(level);
            path1.setCode(infoDO3.getScpsmanNo());
            path1.setType(infoDO3.getScpsmanType());
            path1.setName(leaderUserFullName);
            paths.add(path1);
            return code1.toString();
        }
        return code1.toString();
    }

    private void putFailMsg(Map<String,String> errorInfoMap,String scpsmanNo,String failMsg){
            if(errorInfoMap.containsKey(scpsmanNo)){
               String failMsgNew =  errorInfoMap.get(scpsmanNo)+","+ failMsg;
                errorInfoMap.put(scpsmanNo,failMsgNew);
            }else{
                errorInfoMap.put(scpsmanNo,failMsg);
            }
    }

    private static Boolean checkData(Map<String, String> errorInfoMap,Boolean failFlag,
                                     List<SalesmanImportSaveVO> recommendRelateCustVOS,
                                     StringBuffer failMsg, Map<String, List<ScpsmanInfoDO>> salesmanMap, Map<String,
            List<ScpsmanInfoDO>> loginMap,
                                     Map<String, List<SysOrgBasicDTO>> buMap, Map<String, Long> userCodeIdMap, Map<String, List<OrgOuRpcDTO>> ouMap, Map<String, String> salesmanTypeUDCMap, Map<String, String> newRegionMap, List<String> areaNameList) {
        //从第三行开始判断
        int i = 1;
        for (SalesmanImportSaveVO recommendRelateCustVO : recommendRelateCustVOS) {

            if (StringUtils.isBlank(recommendRelateCustVO.getScpsmanNo())){
                failFlag = true;
                failMsg.append("业务员编号为空 ");
            }
//            if (UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getValueCode().equals(salesmanTypeUDCMap.get(recommendRelateCustVO.getScpsmanType()))
//                    && StringUtils.isBlank(recommendRelateCustVO.getJurisdiction())){
//                failFlag = true;
//                failMsg.append("第"+i+"行销售总监的管辖区域为空 ");
//            }
//            if (UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getValueCode().equals(salesmanTypeUDCMap.get(recommendRelateCustVO.getScpsmanType()))
//                    && StringUtils.isNotBlank(recommendRelateCustVO.getLeaderUserCode())){
//                failFlag = true;
//                failMsg.append("第"+i+"行销售总监不允许有上级 ");
//            }
//            if (StringUtils.isNotBlank(recommendRelateCustVO.getJurisdiction())){
//                String[] split = recommendRelateCustVO.getJurisdiction().split("[;；]");
//                for (String s : split) {
//                    if (StringUtils.isBlank(newRegionMap.get(s))){
//                        failFlag = true;
//                        failMsg.append("第"+i+"行区域信息错误,区域"+ s +"不存在 ");
//                    }
//                }
//            }
            if (StringUtils.isBlank(recommendRelateCustVO.getName())){
                failFlag = true;
                failMsg.append("姓名为空 ");
            }
//            if (StringUtils.isBlank(recommendRelateCustVO.getPhone())){
//                failFlag = true;
//                failMsg.append("第"+i+"行导入的手机号为空 ");
//            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getProvince()) && !areaNameList.contains(recommendRelateCustVO.getProvince())){
                failFlag = true;
                failMsg.append("省信息不存在 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getCity()) && !areaNameList.contains(recommendRelateCustVO.getCity())){
                failFlag = true;
                failMsg.append("市信息不存在 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getArea()) && !areaNameList.contains(recommendRelateCustVO.getArea())){
                failFlag = true;
                failMsg.append("区信息不存在 ");
            }
            if (StringUtils.isBlank(recommendRelateCustVO.getOuCode())){
                failFlag = true;
                failMsg.append("公司编号为空 ");
            }
            if (StringUtils.isBlank(recommendRelateCustVO.getBuCode())){
                failFlag = true;
                failMsg.append("组织编号为空 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getBuCode()) && CollUtil.isEmpty(buMap.get(recommendRelateCustVO.getBuCode()))){
                failFlag = true;
                failMsg.append("组织编号未查询到对应的组织信息 ");
            }
            if (StringUtils.isBlank(recommendRelateCustVO.getLoginAccount())){
                failFlag = true;
                failMsg.append("登录账号为空 ");
            }
//            if (StringUtils.isBlank(recommendRelateCustVO.getScpsmanType())){
//                failFlag = true;
//                failMsg.append("业务员类型为空 ");
//            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getScpsmanType()) && StringUtils.isBlank(salesmanTypeUDCMap.get(recommendRelateCustVO.getScpsmanType()))){
                failFlag = true;
                failMsg.append("业务员类型不存在 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getScpsmanNo()) && CollUtil.isNotEmpty(salesmanMap.get(recommendRelateCustVO.getScpsmanNo()))){
                failFlag = true;
                failMsg.append("业务员编号已经存在，请重新输入 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getLoginAccount()) && CollUtil.isNotEmpty(loginMap.get(recommendRelateCustVO.getLoginAccount()))){
                failFlag = true;
                failMsg.append("登录账号已经存在，请重新输入 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getBuCode()) && StringUtils.isNotBlank(recommendRelateCustVO.getOuCode())
                    && CollUtil.isNotEmpty(buMap.get(recommendRelateCustVO.getBuCode())) && CollUtil.isNotEmpty(ouMap.get(recommendRelateCustVO.getOuCode()))){
                if (ouMap.get(recommendRelateCustVO.getOuCode()).get(0).getBuId() != null &&
                        buMap.get(recommendRelateCustVO.getBuCode()).get(0).getId() != null &&
                        !ouMap.get(recommendRelateCustVO.getOuCode()).get(0).getBuId().equals(buMap.get(recommendRelateCustVO.getBuCode()).get(0).getId()) &&
                        !recommendRelateCustVO.getOuCode().equals(buMap.get(recommendRelateCustVO.getBuCode()).get(0).getParentCode())){
                    failFlag = true;
                    failMsg.append("信息错误，该公司与该组织没有绑定关系，请重新输入 ");
                }
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getOuCode()) && CollUtil.isEmpty(ouMap.get(recommendRelateCustVO.getOuCode()))){
                failFlag = true;
                failMsg.append("公司编号未查询到对应的公司信息，请重新输入 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getLeaderUserCode()) && userCodeIdMap.get(recommendRelateCustVO.getLeaderUserCode()) == null){
                failFlag = true;
                failMsg.append("上级编号未查询到对应的上级信息，请重新输入 ");
            }

            if(StrUtil.isNotBlank(failMsg.toString())){
                errorInfoMap.put(recommendRelateCustVO.getScpsmanNo(),failMsg.toString());
            }
            i++;
        }
        log.info("校验解析数据后:{}",JSONUtil.toJsonStr(errorInfoMap));
        return failFlag;
    }

    private boolean checkEmployee(Map<String, String> errorInfoMap,
                                  List<SalesmanImportSaveVO> recommendRelateCustVOS, StringBuffer failMsg, boolean failFlag, Map<String, List<SysOrgBasicDTO>> buMap) {
        List<EmployeeUpsertDTO> employeeUpsertDTOS = new ArrayList<>();
        for (SalesmanImportSaveVO recommendRelateCustVO : recommendRelateCustVOS) {
            EmployeeUpsertDTO upsertDTO = SalesmanInfoConvert.INSTANCE.salesmanImportSaveVOToUpsertDTO(recommendRelateCustVO);
            if (CollUtil.isNotEmpty(buMap.get(recommendRelateCustVO.getBuCode()))){
                EmployeeUpsertDTO.EmployeeOrg employeeOrg = new EmployeeUpsertDTO.EmployeeOrg();
                employeeOrg.setOrgId(buMap.get(recommendRelateCustVO.getBuCode()).get(0).getId());
                upsertDTO.setOrgList(List.of(employeeOrg));
            }
            employeeUpsertDTOS.add(upsertDTO);

        }
        ApiResult<List<String>> apiResult = employeeRpcService.checkBatch(employeeUpsertDTOS);
        List<String> data = apiResult.getData();
        if (apiResult.isSuccess() && CollUtil.isNotEmpty(data)){
            int n = 0;
            for (String datum : data) {
                if (datum.contains("IllegalArgumentException")){
                    failFlag = true;
                    failMsg.append("第"+n+1+"行数据"+datum+" ");
                }
                n++;
            }
        }
        return failFlag;
    }

    public String isValid(String dateStr,List<String> patterns) {
        for(int i=0;i<patterns.size();i++){
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(patterns.get(0));
                LocalDate.parse(dateStr, dateTimeFormatter);
                return patterns.get(i);
            } catch (DateTimeParseException e) {

            }
        }
        return "";
    }

    private Map<String, List<SysOrgBasicDTO>> getBuMap(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        Set<String> buCodesSet = recommendRelateCustVOS.stream().map(SalesmanImportSaveVO::getBuCode).collect(Collectors.toSet());
        SysOrgQueryDTO sysOrgQueryDTO = new SysOrgQueryDTO();
        //查询组织信息获取组织id
        sysOrgQueryDTO.setCodes(buCodesSet);
        ApiResult<List<SysOrgBasicDTO>> listApiResult = orgRpcService.queryList(sysOrgQueryDTO);
        if (!listApiResult.isSuccess()){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "查询组织信息失败！ "+listApiResult.getMsg());
        }
        List<SysOrgBasicDTO> buList = listApiResult.getData();
        Map<String, List<SysOrgBasicDTO>> buMap = new HashMap<>();
        if (CollUtil.isNotEmpty(buList)){
            buMap = buList.stream().collect(Collectors.groupingBy(SysOrgBasicDTO::getCode));
        }
        return buMap;
    }

    private Map<String, List<ScpsmanInfoDO>> getSalesMap(List<String> list) {
        List<ScpsmanInfoDO> byMasSalesmanNoIn = scpsmanInfoRepo.findByScpsmanNoIn(list);
        Map<String, List<ScpsmanInfoDO>> salesmanMap = new HashMap<>();
        if (CollUtil.isNotEmpty(byMasSalesmanNoIn)){
            salesmanMap = byMasSalesmanNoIn.stream().collect(Collectors.groupingBy(ScpsmanInfoDO::getScpsmanNo));
        }
        return salesmanMap;
    }

    private Map<String, List<ScpsmanInfoDO>> getLoginMap(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        List<String> loginAccounts = recommendRelateCustVOS.stream()
                .map(SalesmanImportSaveVO::getLoginAccount).collect(Collectors.toList());
        List<ScpsmanInfoDO> salesmanInfoRepoByLoginAccountIn = scpsmanInfoRepo.findByLoginAccountIn(loginAccounts);
        Map<String, List<ScpsmanInfoDO>> loginMap = new HashMap<>();
        if (CollUtil.isNotEmpty(salesmanInfoRepoByLoginAccountIn)){
            loginMap = salesmanInfoRepoByLoginAccountIn.stream().collect(Collectors.groupingBy(ScpsmanInfoDO::getLoginAccount));
        }
        return loginMap;
    }

    @NotNull
    private Map<String, Long> getLeaderMap(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        Set<String> leaderCodes = recommendRelateCustVOS.stream()
                .map(SalesmanImportSaveVO::getLeaderUserCode)
                .filter(leaderUserCode -> leaderUserCode != null).collect(Collectors.toSet());
        Map<String, Long> userCodeIdMap = new HashMap<>();
        if (CollUtil.isNotEmpty(leaderCodes)) {
            EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
            employeePageQueryDTO.setCodes(leaderCodes);
            ApiResult<PagingVO<EmployeePageRespDTO>> apiResult = employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!apiResult.isSuccess()) {
                throw new BusinessException("查询上级信息失败！" + apiResult.getMsg());
            }
            userCodeIdMap = apiResult.getData().getRecords()
                    .stream().collect(Collectors.toMap(EmployeePageRespDTO::getCode, EmployeePageRespDTO::getUserId));
        }
        return userCodeIdMap;
    }

    private Map<String, List<OrgOuRpcDTO>> getOuMap(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuCodes(recommendRelateCustVOS.stream().map(SalesmanImportSaveVO::getOuCode).distinct().collect(Collectors.toList()));
        List<OrgOuRpcDTO> ouDtoByParam = orgOuRpcService.findOuDtoByParam(orgOuRpcDtoParam);
        Map<String, List<OrgOuRpcDTO>> ouMap = new HashMap<>();
        if (CollUtil.isNotEmpty(ouDtoByParam)){
            ouMap = ouDtoByParam.stream().collect(Collectors.groupingBy(OrgOuRpcDTO::getOuCode));
        }
        return ouMap;
    }

    public Map<Long, List<SalesmanRegionVO>> getSalesmanRegionMap(Map<String, String> regionUDCMap, List<Long> ids) {
        List<ScpsmanRegionDO> regionDOS = salesmanRegionRepo.findByMasIdIn(ids);
        Map<Long, List<SalesmanRegionVO>> regionMap = new HashMap<>();
        if (CollUtil.isNotEmpty(regionDOS)){
            //翻译区域udc
            List<SalesmanRegionVO> salesmanRegionVOS = SalesmanInfoConvert.INSTANCE.salesmanRegionDOToVo(regionDOS);
            for (SalesmanRegionVO regionVO : salesmanRegionVOS) {
                regionVO.setRegionName(regionUDCMap.get(regionVO.getRegionCode()));
            }
            regionMap = salesmanRegionVOS.stream().collect(Collectors.groupingBy(SalesmanRegionVO::getMasId));
        }
        return regionMap;
    }


    private void buildEmployee(SalesmanInfoSaveVO salesmanInfoSaveVO, ScpsmanInfoDO scpsmanInfoDO,
                               EmployeeUpsertDTO employeeUpsertDTO,String id) {
        var empId = salesmanInfoSaveVO.getUserId();
        if (empId != null) {
            // 绑定已有员工，则只需增加账号类型即可
            var userId = userRpcService.getIdByUsername(scpsmanInfoDO.getLoginAccount()).computeData();
            if (userId != null) {
                userRpcService.addUserType(userId, SCPSMAN, id);
                return;
            }
        }

        AreaVO areaVO = new AreaVO();
        areaVO.setProvinceCode(salesmanInfoSaveVO.getProvince());
        areaVO.setCityCode(salesmanInfoSaveVO.getCity());
        areaVO.setCountyCode(salesmanInfoSaveVO.getArea());
        EmployeeUpsertDTO.EmployeeOrg employeeOrg = new EmployeeUpsertDTO.EmployeeOrg();
        employeeOrg.setOrgId(salesmanInfoSaveVO.getBuId());
        employeeOrg.setLeaderUserId(salesmanInfoSaveVO.getLeaderUserId());
        if (salesmanInfoSaveVO.getSex() != null) {
            employeeUpsertDTO.setGender(salesmanInfoSaveVO.getSex().equals(1) ? "MALE" : "FEMALE");
        }
        employeeUpsertDTO.setAreaVO(areaVO);
        if(StrUtil.isNotBlank(salesmanInfoSaveVO.getPhone())){
            employeeUpsertDTO.setPhone(salesmanInfoSaveVO.getPhone());
        }
        employeeUpsertDTO.setId(empId);
        employeeUpsertDTO.setOrgList(List.of(employeeOrg));
        employeeUpsertDTO.setCode(scpsmanInfoDO.getScpsmanNo());
        employeeUpsertDTO.setOuterKey(salesmanInfoSaveVO.getOuterKey());

        //传递计划员id和类型
        appendUserTypeToEmployeeUpsertDTO(employeeUpsertDTO, id);
        ApiResult<String> result = employeeRpcService.upsert(employeeUpsertDTO);
        if (!result.isSuccess()) {
            throw new BusinessException(result.getMsg()+" 保存员工失败");
        }
    }

    private void appendUserTypeToEmployeeUpsertDTO(EmployeeUpsertDTO employeeUpsertDTO, String id) {
        SysUserTypeDTO sysUserTypeDTO = new SysUserTypeDTO();
        sysUserTypeDTO.setIdentityId(id);
        sysUserTypeDTO.setUserType(SCPSMAN);
        employeeUpsertDTO.setUserTypeList(Collections.singletonList(sysUserTypeDTO));
    }
}
