/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.collect;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.app.ScpStoreItemParamVO;
import com.elitesland.scp.application.facade.vo.param.collect.ScpUserCollectCancelVO;
import com.elitesland.scp.application.facade.vo.param.collect.ScpUserCollectParamVO;
import com.elitesland.scp.application.facade.vo.resp.collect.ScpUserCollectRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.collect.ScpUserCollectSaveVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.app.ScpCacheService;
import com.elitesland.scp.application.service.collect.ScpUserCollectService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.domain.convert.collect.ScpUserCollectConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.entity.collect.ScpUserCollectDO;
import com.elitesland.scp.domain.entity.item.ScpStoreItemDO;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.CollectRedisUtil;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSpuBusinessRpcDTO;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.stereotype.Service;

@Service
public class ScpUserCollectServiceImpl
implements ScpUserCollectService {
    private static final Logger log = LoggerFactory.getLogger(ScpUserCollectServiceImpl.class);
    private final CartRedisUtil cartRedisUtil;
    private final ScpCacheService scpCacheService;
    private final CollectRedisUtil collectRedisUtil;
    private final CommonPriceService commonPriceService;
    private final RmiItemService rmiItemService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;

    @Override
    public List<ScpUserCollectRespVO> getUserList(ScpUserCollectParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        List<ScpUserCollectDO> userCollectItems = this.collectRedisUtil.getUserCollectItems(paramVO.getDemandWhStCode(), currentUserId);
        if (CollUtil.isEmpty(userCollectItems)) {
            return new ArrayList<ScpUserCollectRespVO>();
        }
        Map<String, List<PriPriceRpcDTO>> priceMap = this.getItemPrice(paramVO, userCollectItems);
        ArrayList<ScpUserCollectRespVO> resultList = new ArrayList<ScpUserCollectRespVO>();
        Map<String, List<ScpUserCollectDO>> spuMap = userCollectItems.stream().collect(Collectors.groupingBy(ScpUserCollectDO::getSpuCode));
        List<String> spuCodes = userCollectItems.stream().map(ScpUserCollectDO::getSpuCode).distinct().collect(Collectors.toList());
        Map<String, List<ItmItemSpuBusinessRpcDTO>> moqMap = this.rmiItemService.findMoqByParam(spuCodes, paramVO.getOuCode());
        for (Map.Entry<String, List<ScpUserCollectDO>> entry : spuMap.entrySet()) {
            Optional<ItmItemAttachmentRpcDTO> attachOpt;
            ScpUserCollectRespVO vo = new ScpUserCollectRespVO();
            List<ScpUserCollectDO> storeCartDOS = entry.getValue();
            ScpUserCollectDO scpUserCollectDO = storeCartDOS.get(0);
            vo.setSpuId(scpUserCollectDO.getSpuId());
            vo.setSpuCode(scpUserCollectDO.getSpuCode());
            vo.setSpuName(scpUserCollectDO.getSpuName());
            vo.setSpec(scpUserCollectDO.getSpec());
            vo.setAnotherName(scpUserCollectDO.getAnotherName());
            if (CollUtil.isNotEmpty(scpUserCollectDO.getSpuAttchmentList())) {
                attachOpt = scpUserCollectDO.getSpuAttchmentList().stream().filter(attach -> attach.getMajor()).findFirst();
                vo.setUrl(attachOpt.isPresent() ? attachOpt.get().getUrl() : scpUserCollectDO.getSpuAttchmentList().get(0).getUrl());
            }
            if (CollUtil.isNotEmpty(scpUserCollectDO.getSpuAttchmentList())) {
                attachOpt = scpUserCollectDO.getSpuAttchmentList().stream().filter(attach -> attach.getMajor()).findFirst();
                vo.setUrl(attachOpt.isPresent() ? attachOpt.get().getUrl() : scpUserCollectDO.getSpuAttchmentList().get(0).getUrl());
            }
            vo.setItemCateCode(scpUserCollectDO.getItemCateCode());
            vo.setItemCateName(scpUserCollectDO.getItemCateName());
            vo.setDocType(scpUserCollectDO.getDocType());
            List<ItmItemSpuBusinessRpcDTO> moqList = moqMap.get(scpUserCollectDO.getSpuCode());
            ArrayList<ScpUserCollectRespVO.ItemSpecObjectVO> itemSpecObjectVOS = new ArrayList<ScpUserCollectRespVO.ItemSpecObjectVO>();
            for (ScpUserCollectDO collectDO : storeCartDOS) {
                ScpStoreCartDO storeCartItem;
                ScpUserCollectRespVO.ItemSpecObjectVO detailVo = new ScpUserCollectRespVO.ItemSpecObjectVO();
                detailVo.setUom(collectDO.getUom());
                detailVo.setUomName(collectDO.getUomName());
                detailVo.setItemCode(collectDO.getItemCode());
                detailVo.setItemId(collectDO.getItemId());
                detailVo.setItemName(collectDO.getItemName());
                detailVo.setItemAttrName(collectDO.getItemAttrName());
                List<PriPriceRpcDTO> priceRpcDTOS = priceMap.get(collectDO.getItemCode());
                if (CollUtil.isNotEmpty(priceRpcDTOS)) {
                    detailVo.setItemPrice(SysUtils.processPriceScale(priceRpcDTOS.get(0).getPrice()));
                }
                if ((storeCartItem = this.cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(collectDO.getCombineItemCode(), collectDO.getItemCode()), paramVO.getDemandWhStCode(), collectDO.getDocType(), currentUserId)) != null) {
                    detailVo.setQty(storeCartItem.getQty());
                } else {
                    detailVo.setQty(BigDecimal.ZERO);
                }
                detailVo.setUom2(collectDO.getUom2());
                detailVo.setUom2Name(collectDO.getUom2Name());
                detailVo.setDecimalPlaces(collectDO.getDecimalPlaces());
                detailVo.setUomRatio(collectDO.getUomRatio());
                detailVo.setItemType(collectDO.getItemType());
                if (CollUtil.isNotEmpty(moqList)) {
                    detailVo.setMoq(moqList.get(0).getMoq());
                }
                itemSpecObjectVOS.add(detailVo);
            }
            vo.setItemSpecObjectVOS(itemSpecObjectVOS);
            resultList.add(vo);
        }
        return resultList;
    }

    private Map<String, List<PriPriceRpcDTO>> getItemPrice(ScpUserCollectParamVO paramVO, List<ScpUserCollectDO> userCollectItems) {
        HashMap<String, List<PriPriceRpcDTO>> resultMap = new HashMap<String, List<PriPriceRpcDTO>>();
        Map<String, List<ScpUserCollectDO>> docTypeMap = userCollectItems.stream().collect(Collectors.groupingBy(ScpUserCollectDO::getDocType));
        docTypeMap.forEach((docType, userCollectDOS) -> {
            ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByDocType((String)docType, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            List<AppItemActivityItemPriceParamVO> priceParamVOS = userCollectDOS.stream().map(row -> {
                AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
                priceParamVO.setItemCode(row.getItemCode());
                priceParamVO.setItemId(row.getItemId());
                priceParamVO.setItemCateCode(row.getItemCateCode());
                priceParamVO.setUom(row.getUom());
                return priceParamVO;
            }).collect(Collectors.toList());
            Map<String, List<PriPriceRpcDTO>> priceMap = this.commonPriceService.getPriceAndStockDetails(priceParamVOS, paramVO.getDemandWhStCode(), orderSetting, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            resultMap.putAll(priceMap);
        });
        return resultMap;
    }

    @Override
    public Long add(ScpUserCollectSaveVO saveVO) {
        Long currentUserId = UserService.currentUserId();
        BoundHashOperations<String, Object, Object> cartOps = this.collectRedisUtil.getUserCollectOps(saveVO.getDemandWhStCode(), currentUserId);
        String product = (String)cartOps.get((Object)SysUtils.generateRedisKey("SPU", saveVO.getCombineItemCode(), saveVO.getItemCode()));
        if (StrUtil.isBlank((CharSequence)product)) {
            ScpStoreItemParamVO scpStoreItemParamVO = new ScpStoreItemParamVO();
            scpStoreItemParamVO.setSpuId(saveVO.getSpuId());
            scpStoreItemParamVO.setOuCode(saveVO.getOuCode());
            List<ScpStoreItemDO> itemDOS = this.scpCacheService.getItem(scpStoreItemParamVO);
            if (CollUtil.isEmpty(itemDOS)) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5546\u54c1");
            }
            List userCollectDOS = itemDOS.stream().map(row -> {
                ScpUserCollectDO scpUserCollectDO = ScpUserCollectConvert.INSTANCE.itemDoToCollectDo((ScpStoreItemDO)row);
                scpUserCollectDO.setDocType(saveVO.getDocType());
                scpUserCollectDO.setUserId(currentUserId);
                scpUserCollectDO.setDemandWhStCode(saveVO.getDemandWhStCode());
                scpUserCollectDO.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                scpUserCollectDO.setSkuAttchmentList(row.getSkuAttachmentList());
                scpUserCollectDO.setSpuAttchmentList(row.getSpuAttachmentList());
                return scpUserCollectDO;
            }).collect(Collectors.toList());
            cartOps.put((Object)SysUtils.generateRedisKey("SPU", saveVO.getCombineItemCode(), saveVO.getItemCode()), (Object)JSON.toJSONString(userCollectDOS));
        }
        return 1L;
    }

    @Override
    public Boolean deleteBySpuIdAndUid(ScpUserCollectCancelVO cancelVO) {
        Long currentUserId = UserService.currentUserId();
        BoundHashOperations<String, Object, Object> cartOps = this.collectRedisUtil.getUserCollectOps(cancelVO.getDemandWhStCode(), currentUserId);
        Long delete = cartOps.delete(new Object[]{SysUtils.generateRedisKey("SPU", cancelVO.getCombineItemCode(), cancelVO.getItemCode())});
        return delete > 0L;
    }

    public ScpUserCollectServiceImpl(CartRedisUtil cartRedisUtil, ScpCacheService scpCacheService, CollectRedisUtil collectRedisUtil, CommonPriceService commonPriceService, RmiItemService rmiItemService, ScpOrderSettingDomainService scpOrderSettingDomainService) {
        this.cartRedisUtil = cartRedisUtil;
        this.scpCacheService = scpCacheService;
        this.collectRedisUtil = collectRedisUtil;
        this.commonPriceService = commonPriceService;
        this.rmiItemService = rmiItemService;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
    }
}

