/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.pay.service;

import cn.hutool.json.JSONUtil;
import com.elitesland.scp.pay.service.NotifyVerifyService;
import com.elitesland.scp.pay.service.RefundsService;
import com.elitesland.scp.pay.vo.RefundParamVO;
import com.elitesland.scp.utils.RandomUtil;
import com.tenpay.business.entpay.mse.sdk.api.Refund;
import com.tenpay.business.entpay.mse.sdk.common.NotifyHandler;
import com.tenpay.business.entpay.mse.sdk.config.EntpayConfig;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import com.tenpay.business.entpay.mse.sdk.model.RefundNotifyModel;
import com.tenpay.business.entpay.mse.sdk.model.RefundParam;
import java.math.BigDecimal;
import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class RefundsServiceImpl
implements RefundsService {
    private static final Logger log = LoggerFactory.getLogger(RefundsServiceImpl.class);
    private final NotifyVerifyService notifyVerifyService;

    @Override
    public Refund refundOrder(String paymentId) throws EntpayException {
        RefundParam refundParam = this.constructRefundParam(paymentId);
        log.info("\u9000\u6b3e\u7533\u8bf7\u63a5\u53e3\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)refundParam));
        Refund refund = Refund.create((RefundParam)refundParam);
        log.info("\u9000\u6b3e\u7533\u8bf7\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)refund));
        return refund;
    }

    @Override
    public String refundNotify(String body, String authorization) throws EntpayException, JSONException {
        RefundNotifyModel model = (RefundNotifyModel)NotifyHandler.handlerWebhook((String)body, (String)authorization, RefundNotifyModel.class, (PublicKey)EntpayConfig.getRealTbepPublicKey(null));
        log.info("\u9000\u6b3e\u56de\u8c03\u901a\u77e5\u6570\u636e\uff1a{}", (Object)JSONUtil.toJsonStr((Object)model));
        this.notifyVerifyService.processRefundNotify(model);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("retcode", 0);
        jsonObject.put("retmsg", (Object)"SUCCESS");
        return jsonObject.toString();
    }

    @Override
    public Refund refundOrderManu(RefundParamVO refundParamVO) throws EntpayException {
        RefundParam refundParam = RefundParam.builder().entId(refundParamVO.getEntId()).outRefundId(refundParamVO.getOutRefundId()).paymentId(refundParamVO.getPaymentId()).totalAmount(Long.valueOf(refundParamVO.getTotalAmount().multiply(new BigDecimal("100")).longValue())).refundAmount(Long.valueOf(refundParamVO.getRefundAmount().multiply(new BigDecimal("100")).longValue())).refundReason(refundParamVO.getRefundReason()).serverNotifyUrl("https://datacenter.zhengxinshipin.com/yst/scp/notify/refund").build();
        log.info("\u9000\u6b3e\u7533\u8bf7\u63a5\u53e3\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)refundParam));
        Refund refund = Refund.create((RefundParam)refundParam);
        log.info("\u9000\u6b3e\u7533\u8bf7\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)refund));
        return refund;
    }

    private RefundParam constructRefundParam(String paymentId) {
        return RefundParam.builder().entId("100403095693").outRefundId(RandomUtil.getRandom(20)).paymentId(paymentId).totalAmount(Long.valueOf(100L)).refundAmount(Long.valueOf(10L)).refundReason("\u9000\u6b3e\u539f\u56e0").serverNotifyUrl("https://test-api-business.tenpay.com/donghao/notify/notify/profit_allocation").build();
    }

    public RefundsServiceImpl(NotifyVerifyService notifyVerifyService) {
        this.notifyVerifyService = notifyVerifyService;
    }
}

