package com.elitesland.scp.lakalapay.controller;


import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.lakalapay.service.LklPaymentService;
import com.elitesland.scp.lakalapay.vo.*;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;


@Slf4j
@RestController
@RequestMapping("/payments")
@RequiredArgsConstructor
@Validated
public class LakalaPaymentController {

    private final LklPaymentService paymentService;

    @ApiOperation(value = "小程序拉卡拉支付下单")
    @PostMapping("/online/lkl-pay")
    @BusinessObjectOperation(operationType = OperationTypeEnum.ELSE, operationDescription = "小程序拉卡拉支付下单", allowRepeatRequest = false)
    public ApiResult<OnlineLklPayOrderResponseVO> createOnlineMPPay(HttpServletRequest request, @RequestBody @Validated OnlineLklPayOrderParamVO param) {
        log.info("小程序拉卡拉支付下单请求参数：{}", JSONUtil.toJsonStr(param));
        String clientIP = ServletUtil.getClientIP(request);
        param.setClientIp(clientIP);
        return ApiResult.ok(paymentService.createMpPayOnline(param));
    }

    @ApiOperation(value = "小程序拉卡拉支付结果")
    @GetMapping("/online/queryResult/{docNo}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.ELSE, operationDescription = "小程序拉卡拉支付结果", allowRepeatRequest = false)
    public ApiResult<OnlineLklPayOrderResultResponseVO> queryResult( @PathVariable String docNo) {
        log.info("小程序拉卡拉支付结果请求参数：{}", docNo);
        return ApiResult.ok(paymentService.queryResult(docNo));
    }

    @ApiOperation(value = "小程序拉卡拉余额查询")
    @PostMapping("/balance")
    @BusinessObjectOperation(operationType = OperationTypeEnum.ELSE, operationDescription = "小程序拉卡拉余额查询", allowRepeatRequest = false)
    public ApiResult<BalanceResponseVO> queryBalance(@RequestBody @Validated QueryBalanceParamVO param) {
        log.info("小程序拉卡拉余额查询：{}", JSONUtil.toJsonStr(param));
        return ApiResult.ok(paymentService.queryBalance(param));
    }

    @ApiOperation(value = "小程序拉卡拉财务明细查询")
    @PostMapping("/queryAccountDtl")
    @BusinessObjectOperation(operationType = OperationTypeEnum.ELSE, operationDescription = "小程序拉卡拉财务明细查询", allowRepeatRequest = false)
    public ApiResult<JSONObject> queryAccountDtl(@RequestBody @Validated QueryAccountDtlParamVO param) {
        log.info("小程序拉卡拉财务明细查询：{}", JSONUtil.toJsonStr(param));
        return ApiResult.ok(paymentService.queryAccountDtl(param));
    }


}
