/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.el.coordinator.core.common.utils.UUIDUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderDListParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderDPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderPayInfoRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderDConvert;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderRelateDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepo;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiSalRpcService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpDemandOrderDDomainServiceImpl
implements ScpDemandOrderDDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderDDomainServiceImpl.class);
    private final EntityManager entityManager;
    private final RmiItemService rmiItemService;
    private final RmiSalRpcService rmiSalRpcService;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;
    private final ScpDemandOrderDRepo scpDemandOrderDRepo;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;

    @Override
    public Long saveDemandOrderD(ScpDemandOrderDSaveVO saveVO) {
        if (saveVO.getId() == null) {
            ScpDemandOrderDDO intentDO = ScpDemandOrderDConvert.INSTANCE.saveVoToDO(saveVO);
            return ((ScpDemandOrderDDO)this.scpDemandOrderDRepo.save(intentDO)).getId();
        }
        Optional option = this.scpDemandOrderDRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("\u8ba2\u8d27\u8ba2\u5355\u660e\u7ec6ID\uff1a" + saveVO.getId() + "\u4e0d\u5b58\u5728");
        }
        ScpDemandOrderDConvert.INSTANCE.copySaveParamToDo(saveVO, (ScpDemandOrderDDO)option.get());
        return ((ScpDemandOrderDDO)this.scpDemandOrderDRepo.save((ScpDemandOrderDDO)option.get())).getId();
    }

    @Override
    @SysCodeProc
    public List<ScpDemandOrderDDTO> findDemandOrderDByMasId(Long masId) {
        return this.scpDemandOrderDRepo.findByMasId(masId).stream().map(ScpDemandOrderDConvert.INSTANCE::doToDto).collect(Collectors.toList());
    }

    @Override
    public List<ScpDemandOrderDDO> findDemandOrderDBySpuCodes(Long masId, List<String> spuCode) {
        return this.scpDemandOrderDRepo.findByMasIdAndSpuItemCodeIn(masId, spuCode);
    }

    @Override
    public Page<ScpDemandOrderDDO> pageDemandOrderDByMasId(ScpDemandOrderDPageParamVO paramVO) {
        Page<ScpDemandOrderDDO> scpDemandOrderDDTOS = this.scpDemandOrderDRepo.findByMasIdAndCombineItemCodeIsNull(paramVO.getMasId(), (Pageable)paramVO.getPageRequest());
        return scpDemandOrderDDTOS;
    }

    @Override
    public List<ScpDemandOrderDDO> findByMasIdAndCombineItemCodeIsNotNull(ScpDemandOrderDPageParamVO paramVO) {
        List<ScpDemandOrderDDO> scpDemandOrderDDTOS = this.scpDemandOrderDRepo.findByMasIdAndCombineItemCodeIsNotNull(paramVO.getMasId());
        return scpDemandOrderDDTOS;
    }

    @Override
    public List<ScpDemandOrderDDTO> findDemandOrderDByIds(List<Long> ids) {
        return this.scpDemandOrderDRepo.findByIdIn(ids).stream().map(ScpDemandOrderDConvert.INSTANCE::doToDto).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpDemandOrderDRepoProc.deleteByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePlanQtyAndAmtById(Long id, BigDecimal planQty) {
        this.scpDemandOrderDRepoProc.updatePlanQtyAndAmtById(id, planQty);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSave(List<ScpDemandOrderDSaveVO> saveVOS, AtomicInteger lineNo, String source) {
        List<ScpDemandOrderDSaveVO> saveList;
        List<ScpDemandOrderDSaveVO> updateList;
        Map<String, List<ScpDemandOrderDSaveVO>> whCodeMap = saveVOS.stream().collect(Collectors.groupingBy(row -> row.getSuppWhCode()));
        List<String> custCodes = saveVOS.stream().map(ScpDemandOrderDSaveVO::getSaleCustCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, CustBaseDTO> custMap = this.rmiSalRpcService.getCustBaseMapByCode(custCodes);
        saveVOS.forEach(row -> {
            if (StrUtil.isBlank((CharSequence)row.getSaleOuCode())) {
                row.setPayStatus(ScpUdcEnum.PAY_STATUS_NO_PAY.getValueCode());
            } else {
                CustBaseDTO custBaseInfoDTO = (CustBaseDTO)custMap.get(row.getSaleCustCode());
                String payStatus = !"OUT".equals(custBaseInfoDTO.getInOutCust()) ? ScpUdcEnum.PAY_STATUS_NO_PAY.getValueCode() : ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode();
                row.setPayStatus(payStatus);
            }
        });
        String type = this.scpDemandOrderRepoProc.getOrderTypeById(saveVOS.get(0).getMasId());
        if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type) && source == null) {
            String itemCode = SysUtils.getOrderItemSetting();
            String orderItemImgUrlSetting = SysUtils.getOrderItemImgUrlSetting();
            ItmItemBaseRpcParam itmItemBaseRpcParam = new ItmItemBaseRpcParam();
            itmItemBaseRpcParam.setItemCodes(Arrays.asList(itemCode));
            List<ItmItemBaseRpcDTO> itemBaseRpcDTOList = this.rmiItemService.findItemBaseRpcDtoByParam(itmItemBaseRpcParam);
            if (CollUtil.isEmpty(itemBaseRpcDTOList)) {
                throw new BusinessException("\u8fd0\u8d39\u5546\u54c1\u7f16\u7801\uff1a" + itemCode + "\u4e0d\u5b58\u5728");
            }
            whCodeMap.forEach((whCode, list) -> {
                ScpDemandOrderDSaveVO scpDemandOrderDSaveVO = new ScpDemandOrderDSaveVO();
                ScpDemandOrderDSaveVO oldSaveVO = (ScpDemandOrderDSaveVO)list.get(0);
                if (!oldSaveVO.getFreightFlag().booleanValue() || oldSaveVO.getFreightRatio() == null) {
                    return;
                }
                if (StrUtil.isBlank((CharSequence)oldSaveVO.getSaleOuCode())) {
                    return;
                }
                BigDecimal freightRatio = oldSaveVO.getFreightRatio();
                ItmItemBaseRpcDTO itmItemBaseRpcDTO = (ItmItemBaseRpcDTO)itemBaseRpcDTOList.get(0);
                BigDecimal amt = list.stream().filter(row -> row.getPlanAmt() != null).map(row -> SysUtils.processAmtScale(row.getPlanAmt().multiply(freightRatio))).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
                scpDemandOrderDSaveVO.setMasId(((ScpDemandOrderDSaveVO)saveVOS.get(0)).getMasId());
                scpDemandOrderDSaveVO.setDemandQuantity(BigDecimal.ONE);
                scpDemandOrderDSaveVO.setAllocationQuantity(BigDecimal.ONE);
                scpDemandOrderDSaveVO.setAllocationDeQuantity(BigDecimal.ONE);
                scpDemandOrderDSaveVO.setPlanQuantity(BigDecimal.ONE);
                scpDemandOrderDSaveVO.setPrice(SysUtils.processPriceScale(amt));
                scpDemandOrderDSaveVO.setPlanAmt(SysUtils.processAmtScale(amt));
                scpDemandOrderDSaveVO.setPrice(SysUtils.processAmtScale(amt));
                scpDemandOrderDSaveVO.setCurrency("CNY");
                scpDemandOrderDSaveVO.setPreRootUuid(UUIDUtil.getUUID());
                scpDemandOrderDSaveVO.setItemId(itmItemBaseRpcDTO.getId());
                scpDemandOrderDSaveVO.setItemCode(itmItemBaseRpcDTO.getItemCode());
                scpDemandOrderDSaveVO.setItemName(itmItemBaseRpcDTO.getItemName());
                scpDemandOrderDSaveVO.setSpuItemCode(itmItemBaseRpcDTO.getSpuCode());
                scpDemandOrderDSaveVO.setSpuItemName(itmItemBaseRpcDTO.getSpuName());
                scpDemandOrderDSaveVO.setUom2(itmItemBaseRpcDTO.getUom());
                scpDemandOrderDSaveVO.setSaleCustCode(oldSaveVO.getSaleCustCode());
                scpDemandOrderDSaveVO.setUom2Name(itmItemBaseRpcDTO.getUomName());
                scpDemandOrderDSaveVO.setUnit(itmItemBaseRpcDTO.getUom2());
                scpDemandOrderDSaveVO.setUnitName(itmItemBaseRpcDTO.getUom2Name());
                if (amt.compareTo(BigDecimal.ZERO) == 0) {
                    scpDemandOrderDSaveVO.setPayStatus(ScpUdcEnum.PAY_STATUS_NO_PAY.getValueCode());
                } else {
                    scpDemandOrderDSaveVO.setPayStatus(oldSaveVO.getPayStatus());
                }
                scpDemandOrderDSaveVO.setItemType(itmItemBaseRpcDTO.getItemType2());
                scpDemandOrderDSaveVO.setSupplyType(oldSaveVO.getSupplyType());
                scpDemandOrderDSaveVO.setSuppWhId(oldSaveVO.getSuppWhId());
                scpDemandOrderDSaveVO.setSuppWhName(oldSaveVO.getSuppWhName());
                scpDemandOrderDSaveVO.setSuppWhCode(oldSaveVO.getSuppWhCode());
                scpDemandOrderDSaveVO.setRatio(BigDecimal.valueOf(100L));
                scpDemandOrderDSaveVO.setUomRatio(itmItemBaseRpcDTO.getUomRatio2());
                scpDemandOrderDSaveVO.setQty2(itmItemBaseRpcDTO.getUomRatio2());
                scpDemandOrderDSaveVO.setLineNo(new BigDecimal(lineNo.getAndIncrement()));
                scpDemandOrderDSaveVO.setFreightLineFlag(Boolean.TRUE);
                scpDemandOrderDSaveVO.setIsCalculated(Boolean.TRUE);
                scpDemandOrderDSaveVO.setOuId(oldSaveVO.getOuId());
                scpDemandOrderDSaveVO.setOuCode(oldSaveVO.getOuCode());
                scpDemandOrderDSaveVO.setOuName(oldSaveVO.getOuName());
                scpDemandOrderDSaveVO.setSaleOuName(oldSaveVO.getSaleOuName());
                scpDemandOrderDSaveVO.setSaleOuCode(oldSaveVO.getSaleOuCode());
                scpDemandOrderDSaveVO.setSaleCustCode(oldSaveVO.getSaleCustCode());
                scpDemandOrderDSaveVO.setImgUrl(orderItemImgUrlSetting);
                saveVOS.add(scpDemandOrderDSaveVO);
            });
        }
        if (CollUtil.isNotEmpty(updateList = saveVOS.stream().filter(saveVO -> ObjectUtil.isNotEmpty((Object)saveVO.getId())).collect(Collectors.toList()))) {
            this.scpDemandOrderDRepo.saveAll(ScpDemandOrderDConvert.INSTANCE.saveVoListToDOList(updateList));
        }
        if (CollUtil.isNotEmpty(saveList = saveVOS.stream().filter(saveVO -> ObjectUtil.isEmpty((Object)saveVO.getId())).collect(Collectors.toList()))) {
            this.batchInsert(ScpDemandOrderDConvert.INSTANCE.saveVoListToDOList(saveList));
        }
        List<ScpDemandOrderDDO> saveRootList = this.scpDemandOrderDRepoProc.findByMasIdAndIsPushed(saveVOS.get(0).getMasId(), Boolean.FALSE);
        Map rootItemMap = saveRootList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDO::groupByUuid)).values().stream().map(list -> (ScpDemandOrderDDO)list.get(0)).collect(Collectors.toMap(ScpDemandOrderDDO::groupByUuid, Function.identity(), (t1, t2) -> t1));
        saveRootList.forEach(row -> {
            ScpDemandOrderDDO item = (ScpDemandOrderDDO)rootItemMap.get(row.groupByUuid());
            row.setSourceId(item != null ? item.getId() : row.getId());
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSuppAllocPlanQty(Long demandId) {
        this.scpDemandOrderDRepo.updateSuppAllocPlanQty(demandId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateIsPushed(List<Long> dIds, String msg) {
        String syncMsg = StrUtil.isBlank((CharSequence)msg) ? "\u6210\u529f" : msg;
        this.scpDemandOrderDRepo.updateIsPushed(dIds, syncMsg);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSyncMsg(List<Long> dIds, String msg) {
        this.scpDemandOrderDRepo.updateSyncMsg(dIds, msg);
    }

    @Override
    public void updateSrcInfo(Long srcDocId, String srcDocNo, Long dId, Integer srcDocLineNo) {
        this.scpDemandOrderDRepo.updateSrcDocInfoByIds(srcDocId, srcDocNo, dId, srcDocLineNo);
    }

    @Override
    public void updatePOSrcInfo(Long id, Long srcDocId, String srcDocNo, String srcLineNO) {
        this.scpDemandOrderDRepoProc.updateSrcDocInfoById(id, srcDocId, srcDocNo, srcLineNO, "PO");
    }

    @Override
    public void clearSrcDocInfo(Long docId) {
        this.scpDemandOrderDRepoProc.clearSrcDocInfo(docId);
    }

    @Override
    public void resetSrcDocQuantity(Long dId, BigDecimal qty) {
        this.scpDemandOrderDRepo.resetSrcDocQuantity(dId, qty);
    }

    @Override
    public void updateAllocQuantity(Long dId, BigDecimal qty) {
        this.scpDemandOrderDRepoProc.updateAllocQtyById(dId, qty);
    }

    @Override
    public void updateQuantity(Long dId, BigDecimal qty) {
        this.scpDemandOrderDRepo.updateQtyById(dId, qty);
    }

    @Override
    public void updateErrorMsg(Long dId, String errorMsg) {
        this.scpDemandOrderDRepoProc.updateErrorMsgById(dId, errorMsg);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteUnPushedItem(Long masId) {
        this.scpDemandOrderDRepo.deleteByMasIdAndIsPushed(masId, Boolean.FALSE);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBySourceIds(List<Long> sourceIds) {
        this.scpDemandOrderDRepoProc.deleteBySourceIds(sourceIds);
    }

    @Override
    public BigDecimal findMaxLineNoPushedByMasId(Long masId) {
        return this.scpDemandOrderDRepoProc.findPushedItemMasId(masId);
    }

    @Override
    public List<ScpDemandOrderDDTO> findDemandOrderDByMasIds(List<Long> masIds) {
        return this.scpDemandOrderDRepo.findByMasIdIn(masIds).stream().map(ScpDemandOrderDConvert.INSTANCE::doToDto).collect(Collectors.toList());
    }

    @Override
    public List<Long> getMasIdByDId(List<Long> dIds) {
        return this.scpDemandOrderDRepoProc.getMasIdByDId(dIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelOrderByDIds(List<Long> dIds) {
        Optional byId = this.scpDemandOrderDRepo.findById(dIds.get(0));
        String payStatus = ScpUdcEnum.PAY_STATUS_NO_PAY.getValueCode().equals(((ScpDemandOrderDDO)byId.get()).getPayStatus()) ? ScpUdcEnum.PAY_STATUS_NO_PAY.getValueCode() : ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode();
        this.scpDemandOrderDRepo.cancelOrderByDIds(dIds, payStatus);
    }

    @Override
    public List<ScpDemandOrderPayInfoRespVO> payInfo(Long masId) {
        return this.scpDemandOrderDRepoProc.findPayInfo(masId);
    }

    @Override
    public void updateRecvQty(Long dId, BigDecimal qty) {
        this.scpDemandOrderDRepo.updateRecvQtyById(dId, qty);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initAllocQuantity(Long masId) {
        this.scpDemandOrderDRepoProc.initAllocQuantity(masId);
    }

    @Override
    public void updatePayStatus(List<Long> ids, String payStatus) {
        this.scpDemandOrderDRepo.updatePayStatus(ids, payStatus);
    }

    @Override
    public List<ScpDemandOrderDDTO> findDemandOrderDBySrcDocId(Long srcDocId) {
        return this.scpDemandOrderDRepo.findBySrcDocId(srcDocId).stream().map(ScpDemandOrderDConvert.INSTANCE::doToDto).collect(Collectors.toList());
    }

    @Override
    public List<ScpDemandOrderDDTO> findDemandOrderDBySrcDocNo(String srcDocNo) {
        return this.scpDemandOrderDRepo.findBySrcDocNo(srcDocNo).stream().map(ScpDemandOrderDConvert.INSTANCE::doToDto).collect(Collectors.toList());
    }

    @Override
    public LocalDateTime findDocCreateTimeBySrcDocId(Long srcDocId) {
        return this.scpDemandOrderDRepoProc.findDocCreateTimeBySrcDocId(srcDocId);
    }

    @Override
    public List<ScpDemandOrderRelateDTO> findRelateOrderByMasId(Long masId) {
        return this.scpDemandOrderDRepoProc.findRelateOrderByMasId(masId);
    }

    @Override
    public List<ScpDemandOrderDDTO> queryList(ScpDemandOrderDListParamVO scpDemandOrderDParamVO) {
        return this.scpDemandOrderDRepoProc.queryList(scpDemandOrderDParamVO);
    }

    public void batchInsert(List<ScpDemandOrderDDO> dataList) {
        int index = 0;
        int batchSize = 500;
        for (ScpDemandOrderDDO data : dataList) {
            this.entityManager.persist((Object)data);
            if (batchSize <= 1 || ++index % batchSize != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
        if (!dataList.isEmpty()) {
            this.entityManager.flush();
        }
    }

    public ScpDemandOrderDDomainServiceImpl(EntityManager entityManager, RmiItemService rmiItemService, RmiSalRpcService rmiSalRpcService, ScpDemandOrderRepoProc scpDemandOrderRepoProc, ScpDemandOrderDRepo scpDemandOrderDRepo, ScpDemandOrderDRepoProc scpDemandOrderDRepoProc) {
        this.entityManager = entityManager;
        this.rmiItemService = rmiItemService;
        this.rmiSalRpcService = rmiSalRpcService;
        this.scpDemandOrderRepoProc = scpDemandOrderRepoProc;
        this.scpDemandOrderDRepo = scpDemandOrderDRepo;
        this.scpDemandOrderDRepoProc = scpDemandOrderDRepoProc;
    }
}

