/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.storereceive;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.scp.application.facade.vo.boh.StoreReceivePageParam;
import com.elitesland.scp.application.facade.vo.boh.StoreReceivePageVO;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveTotalVO;
import com.elitesland.scp.application.facade.vo.boh.StoreRtnTotalVO;
import com.elitesland.scp.application.facade.vo.boh.StoreTodoVO;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDDO;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDO;
import com.elitesland.scp.domain.entity.calendar.QScpStoreDemandCalendarDO;
import com.elitesland.scp.domain.entity.item.QScpCateItemDO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderDO;
import com.elitesland.scp.domain.entity.scpsman.QScpsmanInfoDO;
import com.elitesland.scp.domain.entity.storereceive.QStoreReceiveDDO;
import com.elitesland.scp.domain.entity.storereceive.QStoreReceiveDO;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.boh.DemandOrderDtl;
import com.elitesland.scp.mq.DemandOrderSimpleDTO;
import com.elitesland.scp.utils.PartitionJpaUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class StoreReceiveRepoProc
extends BaseRepoProc<StoreReceiveDO> {
    private static final QStoreReceiveDO qdo = QStoreReceiveDO.storeReceiveDO;

    public StoreReceiveRepoProc() {
        super((EntityPathBase)qdo);
    }

    public PagingVO<StoreReceivePageVO> page(StoreReceivePageParam param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(StoreReceivePageVO.class, (Expression[])new Expression[]{StoreReceiveRepoProc.qdo.id, StoreReceiveRepoProc.qdo.docId, StoreReceiveRepoProc.qdo.docNo, StoreReceiveRepoProc.qdo.orderId, StoreReceiveRepoProc.qdo.orderNo, StoreReceiveRepoProc.qdo.orderSetId, StoreReceiveRepoProc.qdo.totalRealQty, StoreReceiveRepoProc.qdo.realAmt, StoreReceiveRepoProc.qdo.totalQty, StoreReceiveRepoProc.qdo.docCreateDate, StoreReceiveRepoProc.qdo.deliveryDate, StoreReceiveRepoProc.qdo.receiveDate, StoreReceiveRepoProc.qdo.orderDate, StoreReceiveRepoProc.qdo.totalAmt, StoreReceiveRepoProc.qdo.docType, StoreReceiveRepoProc.qdo.status, StoreReceiveRepoProc.qdo.rtType})).from((EntityPath)qdo);
        if (param != null) {
            if (StrUtil.isNotBlank((CharSequence)param.getDocType())) {
                jpaQuery.where((Predicate)StoreReceiveRepoProc.qdo.docType.eq((Object)param.getDocType()));
            }
            if (StrUtil.isNotBlank((CharSequence)param.getDocNo())) {
                jpaQuery.where((Predicate)StoreReceiveRepoProc.qdo.docNo.like("%" + param.getDocNo() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)param.getRtType())) {
                jpaQuery.where((Predicate)StoreReceiveRepoProc.qdo.rtType.eq((Object)param.getRtType()));
            }
            if (StrUtil.isNotBlank((CharSequence)param.getOrderNo())) {
                jpaQuery.where((Predicate)StoreReceiveRepoProc.qdo.orderNo.eq((Object)param.getOrderNo()));
            }
            if (param.getOrderId() != null) {
                jpaQuery.where((Predicate)StoreReceiveRepoProc.qdo.orderId.eq((Object)param.getOrderId()));
            }
            if (param.getOrderSetId() != null) {
                jpaQuery.where((Predicate)StoreReceiveRepoProc.qdo.orderSetId.eq((Object)param.getOrderSetId()));
            }
            if (param.getCreateDateFrom() != null) {
                jpaQuery.where((Predicate)StoreReceiveRepoProc.qdo.docCreateDate.goe((Comparable)param.getCreateDateFrom()));
            }
            if (param.getCreateDateTo() != null) {
                jpaQuery.where((Predicate)StoreReceiveRepoProc.qdo.docCreateDate.loe((Comparable)param.getCreateDateTo()));
            }
            if (CollectionUtil.isNotEmpty(param.getStatusList())) {
                jpaQuery.where((Predicate)StoreReceiveRepoProc.qdo.status.in(param.getStatusList()));
            }
            if (CollectionUtil.isNotEmpty(param.getOrderIds())) {
                jpaQuery.where((Predicate)StoreReceiveRepoProc.qdo.orderId.in(param.getOrderIds()));
            }
            if (CollectionUtil.isNotEmpty(param.getStoreIds())) {
                jpaQuery.where((Predicate)StoreReceiveRepoProc.qdo.storeId.in(param.getStoreIds()));
            }
            if (CollectionUtil.isNotEmpty(param.getIds())) {
                jpaQuery.where((Predicate)StoreReceiveRepoProc.qdo.id.in(param.getIds()));
            }
        }
        PartitionJpaUtil.appendYmConditionToPredicate(jpaQuery, StoreReceiveDO.class, param);
        jpaQuery.orderBy(StoreReceiveRepoProc.qdo.deliveryDate.desc());
        param.setPaging(jpaQuery);
        return PagingVO.builder().records(jpaQuery.fetch()).total(jpaQuery.fetchCount()).build();
    }

    public List<Long> findOrderId(String itemKeyword) {
        QScpDemandOrderDDO demandOrderDDO = QScpDemandOrderDDO.scpDemandOrderDDO;
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(demandOrderDDO.masId).from((EntityPath)demandOrderDDO)).where((Predicate)demandOrderDDO.itemCode.like("%" + itemKeyword + "%").or((Predicate)demandOrderDDO.itemName.like("%" + itemKeyword + "%")))).where((Predicate)demandOrderDDO.planQuantity.isNotNull().and((Predicate)demandOrderDDO.planQuantity.goe((Number)BigDecimal.ZERO)));
        return query.fetch();
    }

    public List<DemandOrderSimpleDTO> findOrderSimple(List<Long> orderIds) {
        QScpDemandOrderDO demandOrderDO = QScpDemandOrderDO.scpDemandOrderDO;
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(DemandOrderSimpleDTO.class, (Expression[])new Expression[]{demandOrderDO.docCls, demandOrderDO.type, demandOrderDO.createTime, demandOrderDO.id, demandOrderDO.demandId.as("orderSetId"), demandOrderDO.demandWhStId.as("storeId")})).from((EntityPath)demandOrderDO)).where((Predicate)demandOrderDO.id.in(orderIds));
        return query.fetch();
    }

    public int findStoreCount(Long scpsmanId) {
        QScpsmanAuthorityDDO scpsmanAuthorityDDO = QScpsmanAuthorityDDO.scpsmanAuthorityDDO;
        QScpsmanAuthorityDO scpsmanAuthorityDO = QScpsmanAuthorityDO.scpsmanAuthorityDO;
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)scpsmanAuthorityDDO.stWhId.count()).from((EntityPath)scpsmanAuthorityDDO)).leftJoin((EntityPath)scpsmanAuthorityDO)).on((Predicate)scpsmanAuthorityDDO.masId.eq(scpsmanAuthorityDO.id))).where((Predicate)scpsmanAuthorityDO.scpsmanId.eq((Object)scpsmanId))).where((Predicate)scpsmanAuthorityDDO.type.eq((Object)0))).where((Predicate)scpsmanAuthorityDDO.deleteFlag.eq((Object)0));
        List fetch = query.fetch();
        if (CollectionUtil.isEmpty((Collection)fetch)) {
            return 0;
        }
        return ((Long)fetch.get(0)).intValue();
    }

    public int findNeedDo(Long storeId, LocalDateTime startDate) {
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)StoreReceiveRepoProc.qdo.id.count()).from((EntityPath)qdo)).where((Predicate)StoreReceiveRepoProc.qdo.storeId.eq((Object)storeId))).where((Predicate)StoreReceiveRepoProc.qdo.status.eq((Object)"CE"))).where((Predicate)StoreReceiveRepoProc.qdo.docCreateDate.goe((Comparable)startDate));
        List fetch = query.fetch();
        if (CollectionUtil.isEmpty((Collection)fetch)) {
            return 0;
        }
        return ((Long)fetch.get(0)).intValue();
    }

    public int findReceive(Long storeId, LocalDateTime startDate) {
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)StoreReceiveRepoProc.qdo.id.count()).from((EntityPath)qdo)).where((Predicate)StoreReceiveRepoProc.qdo.storeId.eq((Object)storeId))).where((Predicate)StoreReceiveRepoProc.qdo.status.in((Object[])new String[]{"CE"}))).where((Predicate)StoreReceiveRepoProc.qdo.rtType.eq((Object)"R"))).where((Predicate)StoreReceiveRepoProc.qdo.docCreateDate.goe((Comparable)startDate));
        List fetch = query.fetch();
        if (CollectionUtil.isEmpty((Collection)fetch)) {
            return 0;
        }
        return ((Long)fetch.get(0)).intValue();
    }

    public int findRtn(Long storeId, LocalDateTime startDate) {
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)StoreReceiveRepoProc.qdo.id.count()).from((EntityPath)qdo)).where((Predicate)StoreReceiveRepoProc.qdo.storeId.eq((Object)storeId))).where((Predicate)StoreReceiveRepoProc.qdo.status.in((Object[])new String[]{"CE"}))).where((Predicate)StoreReceiveRepoProc.qdo.rtType.eq((Object)"T"))).where((Predicate)StoreReceiveRepoProc.qdo.docCreateDate.goe((Comparable)startDate));
        List fetch = query.fetch();
        if (CollectionUtil.isEmpty((Collection)fetch)) {
            return 0;
        }
        return ((Long)fetch.get(0)).intValue();
    }

    public int findRtnApply(Long storeId, LocalDateTime startDate) {
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)StoreReceiveRepoProc.qdo.id.count()).from((EntityPath)qdo)).where((Predicate)StoreReceiveRepoProc.qdo.storeId.eq((Object)storeId))).where((Predicate)StoreReceiveRepoProc.qdo.status.eq((Object)"DR"))).where((Predicate)StoreReceiveRepoProc.qdo.rtType.eq((Object)"T"))).where((Predicate)StoreReceiveRepoProc.qdo.docCreateDate.goe((Comparable)startDate));
        List fetch = query.fetch();
        if (CollectionUtil.isEmpty((Collection)fetch)) {
            return 0;
        }
        return ((Long)fetch.get(0)).intValue();
    }

    public Long findOrderCount(Long storeId, LocalDateTime startDate) {
        QScpDemandOrderDO scpDemandOrderDO = QScpDemandOrderDO.scpDemandOrderDO;
        QScpDemandOrderDDO scpDemandOrderDDO = QScpDemandOrderDDO.scpDemandOrderDDO;
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)scpDemandOrderDDO.count()).from((EntityPath)scpDemandOrderDDO)).leftJoin((EntityPath)scpDemandOrderDO)).on((Predicate)scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
        List<String> payStatus = List.of(ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode(), ScpUdcEnum.PAY_STATUS_PAYING.getValueCode());
        jpaQuery.where((Predicate)scpDemandOrderDDO.payStatus.in(payStatus));
        jpaQuery.where((Predicate)scpDemandOrderDO.demandWhStId.eq((Object)storeId));
        jpaQuery.where((Predicate)scpDemandOrderDO.createTime.goe((Comparable)startDate));
        jpaQuery.where((Predicate)scpDemandOrderDO.docStatus.eq((Object)ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode()));
        jpaQuery.where((Predicate)scpDemandOrderDDO.srcDocId.isNotNull());
        jpaQuery.groupBy((Expression)scpDemandOrderDDO.srcDocNo);
        return jpaQuery.fetchCount();
    }

    public Long findScpsmanId() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Assert.notNull((Object)userDetails, (String)"\u767b\u5f55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)userDetails.getUser(), (String)"\u767b\u5f55\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        QScpsmanInfoDO scpsmanInfoDO = QScpsmanInfoDO.scpsmanInfoDO;
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(scpsmanInfoDO.id).from((EntityPath)scpsmanInfoDO)).where((Predicate)scpsmanInfoDO.loginAccount.eq((Object)userDetails.getUsername()));
        List ids = query.fetch();
        Assert.notEmpty((Iterable)ids, (String)"\u672a\u627e\u5230\u5173\u8054\u7684\u8ba1\u5212\u5458", (Object[])new Object[0]);
        return (Long)ids.get(0);
    }

    public String findStoreName(Long orderId) {
        QScpDemandOrderDO scpDemandOrderDO = QScpDemandOrderDO.scpDemandOrderDO;
        List storeNames = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)scpDemandOrderDO.demandWhStName).from((EntityPath)scpDemandOrderDO)).where((Predicate)scpDemandOrderDO.id.eq((Object)orderId))).fetch();
        return CollectionUtil.isEmpty((Collection)storeNames) ? null : (String)storeNames.get(0);
    }

    public List<DemandOrderDtl> findOrderDtl(List<Long> orderDidList) {
        QScpDemandOrderDDO ddo = QScpDemandOrderDDO.scpDemandOrderDDO;
        JPAQuery where = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(DemandOrderDtl.class, (Expression[])new Expression[]{ddo.id, ddo.itemId, ddo.price})).from((EntityPath)ddo)).where((Predicate)ddo.id.in(orderDidList));
        return where.fetch();
    }

    public List<DemandOrderDtl> findOrderDtl(Long orderId) {
        QScpDemandOrderDDO ddo = QScpDemandOrderDDO.scpDemandOrderDDO;
        JPAQuery where = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(DemandOrderDtl.class, (Expression[])new Expression[]{ddo.id, ddo.itemId, ddo.price, ddo.imgUrl})).from((EntityPath)ddo)).where((Predicate)ddo.masId.eq((Object)orderId));
        return where.fetch();
    }

    public String storeCalendar(Long storeId) {
        LocalDateTime now = LocalDateTime.now();
        Object nonth = String.valueOf(now.getMonthValue());
        if (((String)nonth).length() == 1) {
            nonth = "0" + (String)nonth;
        }
        QScpStoreDemandCalendarDO scpStoreDemandCalendarDO = QScpStoreDemandCalendarDO.scpStoreDemandCalendarDO;
        List fetch = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)scpStoreDemandCalendarDO.workStatus).from((EntityPath)scpStoreDemandCalendarDO)).where((Predicate)scpStoreDemandCalendarDO.year.eq((Object)String.valueOf(now.getYear())))).where((Predicate)scpStoreDemandCalendarDO.month.eq(nonth))).where((Predicate)scpStoreDemandCalendarDO.day.eq((Object)String.valueOf(now.getDayOfMonth())))).where((Predicate)scpStoreDemandCalendarDO.storeId.eq((Object)storeId))).fetch();
        return CollectionUtil.isNotEmpty((Collection)fetch) ? (String)fetch.get(0) : null;
    }

    public List<StoreReceiveDO> findAllByStoreIdInAndByCreateTime(List<Long> storeIds, LocalDateTime fromTime, LocalDateTime toTime) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)qdo).from((EntityPath)qdo);
        if (CollectionUtil.isNotEmpty(storeIds)) {
            jpaQuery.where((Predicate)StoreReceiveRepoProc.qdo.storeId.in(storeIds));
        }
        if (fromTime != null) {
            jpaQuery.where((Predicate)StoreReceiveRepoProc.qdo.createTime.goe((Comparable)fromTime));
        }
        if (toTime != null) {
            jpaQuery.where((Predicate)StoreReceiveRepoProc.qdo.createTime.loe((Comparable)toTime));
        }
        List fetch = jpaQuery.fetch();
        return fetch;
    }

    public StoreTodoVO findTodo(StoreReceivePageParam param) {
        List fetch;
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(StoreTodoVO.class, (Expression[])new Expression[]{StoreReceiveRepoProc.qdo.id.count().nullif((Number)0L).as("all"), ((NumberExpression)StoreReceiveRepoProc.qdo.rtType.when((Object)"T").then((Number)1L).otherwise((Object)0L)).sum().nullif((Number)0L).as("rtn"), ((NumberExpression)StoreReceiveRepoProc.qdo.rtType.when((Object)"R").then((Number)1L).otherwise((Object)0L)).sum().nullif((Number)0L).as("receive")})).from((EntityPath)qdo)).where((Predicate)StoreReceiveRepoProc.qdo.storeId.in(param.getStoreIds()).and((Predicate)StoreReceiveRepoProc.qdo.status.eq((Object)"CE")));
        if (param.getCreateDateFrom() != null) {
            query.where((Predicate)StoreReceiveRepoProc.qdo.docCreateDate.goe((Comparable)param.getCreateDateFrom()));
        }
        if (CollectionUtil.isNotEmpty(param.getIds())) {
            query.where((Predicate)StoreReceiveRepoProc.qdo.id.in(param.getIds()));
        }
        return CollectionUtil.isNotEmpty((Collection)(fetch = query.fetch())) ? (StoreTodoVO)fetch.get(0) : null;
    }

    public StoreRtnTotalVO findRtnTotal(StoreReceivePageParam param) {
        List fetch;
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(StoreRtnTotalVO.class, (Expression[])new Expression[]{StoreReceiveRepoProc.qdo.id.count().nullif((Number)0L).as("all"), ((NumberExpression)StoreReceiveRepoProc.qdo.status.when((Object)"CE").then((Number)1L).otherwise((Object)0L)).sum().nullif((Number)0L).as("ce"), ((NumberExpression)StoreReceiveRepoProc.qdo.status.when((Object)"CF").then((Number)1L).otherwise((Object)0L)).sum().nullif((Number)0L).as("cf"), ((NumberExpression)StoreReceiveRepoProc.qdo.status.when((Object)"DR").then((Number)1L).otherwise((Object)0L)).sum().nullif((Number)0L).as("dr")})).from((EntityPath)qdo)).where((Predicate)StoreReceiveRepoProc.qdo.storeId.in(param.getStoreIds()).and((Predicate)StoreReceiveRepoProc.qdo.rtType.eq((Object)"T")));
        if (param.getCreateDateFrom() != null) {
            query.where((Predicate)StoreReceiveRepoProc.qdo.docCreateDate.goe((Comparable)param.getCreateDateFrom()));
        }
        if (CollectionUtil.isNotEmpty(param.getIds())) {
            query.where((Predicate)StoreReceiveRepoProc.qdo.id.in(param.getIds()));
        }
        return CollectionUtil.isNotEmpty((Collection)(fetch = query.fetch())) ? (StoreRtnTotalVO)fetch.get(0) : null;
    }

    public StoreReceiveTotalVO findReceiveTotal(StoreReceivePageParam param) {
        List fetch;
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(StoreReceiveTotalVO.class, (Expression[])new Expression[]{StoreReceiveRepoProc.qdo.id.count().nullif((Number)0L).as("all"), ((NumberExpression)StoreReceiveRepoProc.qdo.status.when((Object)"CE").then((Number)1L).otherwise((Object)0L)).sum().nullif((Number)0L).as("ce"), ((NumberExpression)StoreReceiveRepoProc.qdo.status.when((Object)"CF").then((Number)1L).otherwise((Object)0L)).sum().nullif((Number)0L).as("cf")})).from((EntityPath)qdo)).where((Predicate)StoreReceiveRepoProc.qdo.storeId.in(param.getStoreIds()).and((Predicate)StoreReceiveRepoProc.qdo.rtType.eq((Object)"R")));
        if (param.getCreateDateFrom() != null) {
            query.where((Predicate)StoreReceiveRepoProc.qdo.docCreateDate.goe((Comparable)param.getCreateDateFrom()));
        }
        if (CollectionUtil.isNotEmpty(param.getIds())) {
            query.where((Predicate)StoreReceiveRepoProc.qdo.id.in(param.getIds()));
        }
        return CollectionUtil.isNotEmpty((Collection)(fetch = query.fetch())) ? (StoreReceiveTotalVO)fetch.get(0) : null;
    }

    public List<Long> findItemIdsByCate(List<Long> cateIds) {
        QScpCateItemDO cateItemDO = QScpCateItemDO.scpCateItemDO;
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(cateItemDO.itemId).from((EntityPath)cateItemDO)).where((Predicate)cateItemDO.cateId.in(cateIds));
        return query.fetch();
    }

    public List<Long> findDocId(List<Long> itemIds) {
        QStoreReceiveDDO ddo = QStoreReceiveDDO.storeReceiveDDO;
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(ddo.masId).from((EntityPath)ddo)).where((Predicate)ddo.itemId.in(itemIds));
        return query.fetch();
    }
}

