/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.lakalapay.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    static Logger log = LoggerFactory.getLogger(SignUtil.class);

    private SignUtil() {
    }

    public static String getSig(String appSecret, String baseUrl) {
        try {
            return SignUtil.signHS256(appSecret, baseUrl);
        }
        catch (Exception e) {
            log.warn("getSign Exception ", (Throwable)e);
            return "";
        }
    }

    public static String getSigBaseURL(String host, String methedName, Map<String, String> params) {
        try {
            String sortedParamStr = SignUtil.getSortedParamStr(params);
            return host + methedName + "?" + sortedParamStr;
        }
        catch (UnsupportedEncodingException e) {
            log.warn("getSign UnsupportedEncodingException ", (Throwable)e);
            return "";
        }
    }

    public static String getSortedParamStr(Map<String, String> params) throws UnsupportedEncodingException {
        TreeSet<String> sortedParams = new TreeSet<String>(params.keySet());
        StringBuilder sortedParamStr = new StringBuilder();
        for (String key : sortedParams) {
            String value = params.get(key);
            if (null == value || "".equals(value) || "sign".equalsIgnoreCase(key)) continue;
            sortedParamStr.append(key + "=" + URLEncoder.encode(value, "UTF-8") + "&");
        }
        return sortedParamStr.substring(0, sortedParamStr.length() - 1);
    }

    public static String signHS256(String appSecret, String baseUrl) {
        try {
            Mac hs256 = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(appSecret.getBytes("UTF-8"), "HmacSHA256");
            hs256.init(secretKey);
            byte[] bytes = hs256.doFinal(baseUrl.getBytes("UTF-8"));
            return SignUtil.toHex(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301HmacSHA256\u7b97\u6cd5", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301utf8\u7f16\u7801", e);
        }
        catch (Exception e) {
            throw new RuntimeException("hs256\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    public static String toHex(byte[] bytes) {
        StringBuffer hexstr = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String b = Integer.toHexString(bytes[i] & 0xFF);
            if (b.length() < 2) {
                hexstr.append(0);
            }
            hexstr.append(b);
        }
        return hexstr.toString();
    }

    public static String getSortedParam(Map<String, Object> params) throws UnsupportedEncodingException {
        TreeSet<String> sortedParams = new TreeSet<String>(params.keySet());
        StringBuilder sortedParamStr = new StringBuilder();
        for (String key : sortedParams) {
            String value = String.valueOf(params.get(key));
            if (null == value || "".equals(value) || "sign".equalsIgnoreCase(key)) continue;
            sortedParamStr.append(key + "=" + URLEncoder.encode(value, "UTF-8") + "&");
        }
        return sortedParamStr.substring(0, sortedParamStr.length() - 1);
    }

    public static String getSignHmacSHA256(Map<String, Object> params, String secret) {
        String sortStr = null;
        try {
            sortStr = SignUtil.getSortedParam(params);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u53c2\u6570\u6392\u5e8f\u5931\u8d25", e);
        }
        return SignUtil.signHS256(secret, sortStr);
    }

    public static void main(String[] args) {
        String appSecret = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQClM6wR8yM56vQBPdumTO0Tac4oBaKYvnsOFOiAG/rOiMhPXZ790KEoURY3afPg3ALYrxTQQBlISKaC+7Nrd59QLKrjYYedu2mC88ljGl2KgrIHaIuSaFHeS2zrur9GfxgzDUrOhQ7wLnLTY3mzCT0nX4jTATEgfD6Juo+TzHBPcwIDAQAB";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("productCode", "1649290269055750179");
        param.put("terminalId", "4444");
        String sign = SignUtil.getSignHmacSHA256(param, appSecret);
        System.out.println(sign);
        String sign1 = SignUtil.getSignHmacSHA256(param, appSecret);
        System.out.println(sign1);
    }
}

