/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.mq;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.task.delay.common.DelayTaskHandler;
import com.elitescloud.cloudt.core.task.delay.TaskInfo;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPayTimeoutMqParam;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepo;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ScpOrderPayTimeoutListener
implements DelayTaskHandler<ScpDemandOrderPayTimeoutMqParam> {
    private static final Logger log = LoggerFactory.getLogger(ScpOrderPayTimeoutListener.class);
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;
    private final ScpDemandOrderRepo scpDemandOrderRepo;
    private final ScpDemandOrderService scpDemandOrderService;

    public String[] supportType() {
        return new String[]{"scp_order_pay_timeout"};
    }

    public boolean execute(TaskInfo<ScpDemandOrderPayTimeoutMqParam> taskInfo) {
        log.info("\u8ba2\u5355\u652f\u4ed8\u66f4\u65b0\u5173\u8054\u5355\u636e\u72b6\u6001\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr(taskInfo));
        ScpDemandOrderPayTimeoutMqParam param = (ScpDemandOrderPayTimeoutMqParam)taskInfo.getPayload();
        Long orderId = param.getDocId();
        String targetStatus = param.getTargetStatus();
        try {
            Optional demandOrderDO = this.scpDemandOrderRepo.findById(orderId);
            if (demandOrderDO.isEmpty()) {
                log.info("\u8ba2\u5355 {} \u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u5904\u7406\u5012\u8ba1\u65f6", (Object)orderId);
                return true;
            }
            ScpDemandOrderDO scpDemandOrderDO = (ScpDemandOrderDO)demandOrderDO.get();
            String docType = scpDemandOrderDO.getDocType();
            if (docType.equals("BF")) {
                log.info("\u8ba2\u5355 {} \u662f\u8865\u8fd0\u8d39\u5355\u636e\uff0c\u65e0\u9700\u5904\u7406\u5012\u8ba1\u65f6", (Object)orderId);
                return true;
            }
            String payStatus = scpDemandOrderDO.getPayStatus();
            String docStatus = scpDemandOrderDO.getDocStatus();
            if (payStatus != null && Objects.equals(payStatus, ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode()) && docStatus != null && !Objects.equals(docStatus, ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode())) {
                this.scpDemandOrderRepoProc.updateOrderStatusById(orderId, targetStatus, null);
                log.info("\u8ba2\u5355 {} \u5012\u8ba1\u65f6\u7ed3\u675f\uff0c\u72b6\u6001\u5df2\u66f4\u65b0\u4e3a {}", (Object)orderId, (Object)targetStatus);
                this.scpDemandOrderService.close(orderId, "SYSTEM");
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u8ba2\u5355 {} \u5931\u8d25", (Object)orderId, (Object)e);
        }
        return true;
    }

    public ScpOrderPayTimeoutListener(ScpDemandOrderRepoProc scpDemandOrderRepoProc, ScpDemandOrderRepo scpDemandOrderRepo, ScpDemandOrderService scpDemandOrderService) {
        this.scpDemandOrderRepoProc = scpDemandOrderRepoProc;
        this.scpDemandOrderRepo = scpDemandOrderRepo;
        this.scpDemandOrderService = scpDemandOrderService;
    }
}

