/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.workflow.service.impl;

import com.elitesland.scp.application.out.service.SystemDubboService;
import com.elitesland.scp.domain.service.feedback.ScpStoreFeedbackDomainService;
import com.elitesland.scp.workflow.service.FeedbackProcessService;
import com.elitesland.workflow.enums.ProcInstStatus;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class FeedbackProcessServiceImpl
implements FeedbackProcessService {
    private final SystemDubboService systemDubboService;
    private final ScpStoreFeedbackDomainService scpStoreFeedbackDomainService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus, String customParams) {
        this.scpStoreFeedbackDomainService.statusChangeByProcess(id, procInstStatus, customParams);
    }

    @Override
    public ArrayList<String> taskAssignee(Long id, String customParams) {
        List<Long> userIds = this.systemDubboService.findUserIdsByFlowRoles(id, customParams);
        ArrayList<String> userStrIds = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(userIds)) {
            userIds.stream().forEach(i -> {
                String newString = String.valueOf(i);
                userStrIds.add(newString);
            });
            return userStrIds;
        }
        return new ArrayList<String>();
    }

    public FeedbackProcessServiceImpl(SystemDubboService systemDubboService, ScpStoreFeedbackDomainService scpStoreFeedbackDomainService) {
        this.systemDubboService = systemDubboService;
        this.scpStoreFeedbackDomainService = scpStoreFeedbackDomainService;
    }
}

