package com.elitesland.scp.application.facade.vo.cart;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Auther: Mark
 * @Date: 2024/3/26 17:12
 * @Description:
 */
@Data
@ApiModel(description = "采购车修改选中状态")
public class CartChangeSelectedStatusAllParamVO implements Serializable {

    @ApiModelProperty("门店编码")
    @NotBlank(message = "门店编码不能为空")
    private String demandWhStCode;

    @ApiModelProperty("采购车类型")
    @NotBlank(message = "采购车类型不能为空")
    private String cartType;

    @ApiModelProperty("选中状态 0-未选中 1-选中")
    @NotNull(message = "选中状态不能为空")
    private Integer status;

}
