package com.elitesland.scp.application.facade.vo.feedback;



import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.tools.FileObject;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel(value = "ScpStoreFeedbackSaveVO", description = "门店反馈")
public class ScpStoreFeedbackSaveVO implements Serializable {
    private static final long serialVersionUID = -59938862496627065L;
    /**
    * 主键
    */    
    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("是否提交")
    private Boolean isSubmit;
    /**
    * 反馈类型
    */    
    @ApiModelProperty("反馈类型")
    private String feedbackType;

    @ApiModelProperty("反馈单号")
    private String dcoNo;
    /**
    * 反馈原因
    */    
    @ApiModelProperty("反馈原因")
    private String feedbackReason;

    @ApiModelProperty("反馈状态")
    private String feedbackStatus;
    /**
    * 反馈门店编码
    */    
    @ApiModelProperty("反馈门店编码")
    private String feedbackStoreCode;
    /**
    * 反馈门店名称
    */    
    @ApiModelProperty("反馈门店名称")
    private String feedbackStoreName;
    /**
    * 商品编码
    */    
    @ApiModelProperty("商品编码")
    private String itemCode;
    /**
    * 商品名称
    */    
    @ApiModelProperty("商品名称")
    private String itemName;
    /**
    * 反馈评分
    */    
    @ApiModelProperty("反馈评分")
    private BigDecimal feedbackScore;
    /**
    * 评价意见
    */    
    @ApiModelProperty("评价意见")
    private String evaluationComment;
    /**
    * 优化意见
    */    
    @ApiModelProperty("优化意见")
    private String optimizationSuggestion;
    /**
    * 图片编码
    */    
    @ApiModelProperty("图片编码")
    private String fileCode;
    /**
    * 图片url
    */    
    @ApiModelProperty("图片url")
    private String fileUrl;

    @ApiModelProperty("图片url集合")
    private List<FileObject> fileUrlList;

    @Data
    public static class FileObject {

        @ApiModelProperty("文件编码")
        private String fileCode;

        @ApiModelProperty("文件url")
        private String fileUrl;

        @ApiModelProperty("文件类型")
        private String fileType;
    }
    /**
    * 审批状态
    */    
    @ApiModelProperty("审批状态")
    private String approvalStatus;
    /**
    * 反馈时间
    */    
    @ApiModelProperty("反馈时间")
    private LocalDateTime feedbackTime;
    /**
    * 反馈人
    */    
    @ApiModelProperty("反馈人")
    private String feedbackBy;
    /**
    * 审批人
    */    
    @ApiModelProperty("审批人")
    private String approvedBy;
    /**
    * 审批时间
    */    
    @ApiModelProperty("审批时间")
    private LocalDateTime approvalTime;

    @ApiModelProperty("物料分类")
    private String itemType2;

    /**
    * 备注
    */    
    @ApiModelProperty("备注")
    private String remark;


    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;


}
