package com.elitesland.scp.application.facade.vo.param.setting;


import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

@Data
@ApiModel(value = "单据类型查询参数")
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ScpOrderSettingParamVO extends AbstractOrderQueryParam {

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("商品分类")
    private String itemCate;

    @ApiModelProperty("商品分类")
    private List<String> itemCates;

    @ApiModelProperty("是否启用")
    private Boolean status;

    @ApiModelProperty("调拨订单单据类型")
    private String trnType;

    @ApiModelProperty("要货类型")
    private String type;

    @ApiModelProperty("首选商品分类标识")
    private String firstItemCateFlag;

    @ApiModelProperty("采购场景")
    private String purScene;
    private List<String> purSceneList;
}
