package com.elitesland.scp.application.service.order;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetStatusParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetSelectRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandSetSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandUrgentSetSaveVO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

public interface ScpDemandOrderSetService {

    /**
     * 订货集查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpDemandSetPageRespVO> queryDemandSetList(ScpDemandSetPageParamVO paramVO);

    /**
     * 订货集详情查询
     *
     * @param id
     * @return
     */
    Optional<ScpDemandSetRespVO> findDemandSetById(Long id);

    /**
     * 订货集保存
     *
     * @param saveVO
     * @return
     */
    Long saveDemandSet(ScpDemandSetSaveVO saveVO);

    /**
     * 订货集紧急订货
     * @param saveVO
     * @return
     */
    Long saveUrgentDemandSet(ScpDemandUrgentSetSaveVO saveVO);

    /**
     * 订货集变更状态
     *
     * @param paramVO
     * @return
     */
    void changeDemandSetStatus(ScpDemandSetStatusParamVO paramVO);

    /**
     * 删除订货集
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 计算分配
     *
     * @param ids 订货集ID
     */
    void compute(List<Long> ids);

    /**
     * 订货集下拉
     *
     * @param paramVO
     * @return
     */
    List<ScpDemandSetSelectRespVO> demandSetSelectList(ScpDemandSetParamVO paramVO);

    List<ScpDemandSetPageRespVO> commonNewPage(ScpDemandSetPageParamVO paramVO);

    /**
     * 推送采购/库存/销售模块
     *
     * @param ids
     */
    void push(List<Long> ids);

    PagingVO<ScpDemandSetPageRespVO> commonPage(ScpDemandSetPageParamVO paramVO);
}
