package com.elitesland.scp.application.web.authority;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityComponentVO;
import com.elitesland.scp.application.service.authority.ScpsmanAuthorityComponentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Auther: wz
 * @Date: 2024/3/25 10:10
 * @Description:
 */
@RestController
@RequestMapping("/scp/authority/component")
@RequiredArgsConstructor
@Api(value = "供应链计划中心-公共组件接口-计划员权限", tags = {"供应链计划中心-公共组件接口-计划员权限"})
public class ScpsmanAuthorityComponentController {

    private final ScpsmanAuthorityComponentService scpsmanAuthorityComponentService;


    @ApiOperation("计划员权限分页查询-放大镜组件")
    @PostMapping("/authority/paging")
    public ApiResult<PagingVO<ScpsmanAuthorityComponentVO>> salemansAuthorityComponentPage(@RequestBody ScpManAuthorityParam paramVO) {
        return ApiResult.ok(scpsmanAuthorityComponentService.salemansAuthorityComponentPage(paramVO));
    }

    @ApiOperation("计划员权限查询-小程序登录查询")
    @PostMapping("/authority/appQuery")
    public ApiResult<ScpsmanAuthorityComponentVO> appQuery(@RequestBody ScpManAuthorityParam paramVO) {
        return ApiResult.ok(scpsmanAuthorityComponentService.appQuery(paramVO));
    }



}
