package com.elitesland.scp.application.web.setting;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingBaseParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingStatusParamVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.setting.ScpOrderSettingSaveVO;
import com.elitesland.scp.application.service.setting.ScpOrderSettingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@Api(tags = "单据类型配置接口")
@RestController
@RequestMapping(value = "/setting", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpOrderSettingController {

    private final ScpOrderSettingService scpOrderSettingService;

    @ApiOperation(value = "单据类型配置-  分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpOrderSettingPageRespVO>> queryOrderSetting(@RequestBody ScpOrderSettingPageParamVO paramVO) {
        log.info("[SCP-ORDER-SETTING] queryOrderSetting  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpOrderSettingService.page(paramVO));
    }

    @ApiOperation("单据类型配置 - 查询单据类型配置信息")
    @GetMapping("/findIdOne/{id}")
    public ApiResult<ScpOrderSettingRespVO> findIdOne(@PathVariable Long id) {
        log.info("[SCP-ORDER-SETTING] findIdOne, id ={}", id);
        return scpOrderSettingService.findOrderSettingById(id).map(ApiResult::ok)
                .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }

    @ApiOperation(value = "单据类型配置- 下拉")
    @PostMapping(value = "/list")
    public ApiResult<List<ScpOrderSettingRespVO>> queryOrderSettingList(@RequestBody ScpOrderSettingParamVO paramVO) {
        log.info("[SCP-ORDER-SETTING] queryOrderSettingList  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpOrderSettingService.queryOrderSettingList(paramVO));
    }

    @PostMapping("/save")
    @ApiOperation("单据类型配置 - 保存")
    public ApiResult<Long> saveOrderSetting(@RequestBody @Validated ScpOrderSettingSaveVO saveVO) {
        log.info("[SCP-ORDER-SETTING] saveOrderSetting  saveVO ={}", JSONUtil.toJsonStr(saveVO));
        return ApiResult.ok(scpOrderSettingService.saveOrderSetting(saveVO));
    }

    @ApiOperation("单据类型配置 - 启用/禁用")
    @PostMapping("/change")
    public ApiResult<Object> changeStatus(@RequestBody @Validated ScpOrderSettingStatusParamVO paramVO) {
        log.info("[SCP-ORDER-SETTING] changeStatus paramVO = {}", JSONUtil.toJsonStr(paramVO));
        scpOrderSettingService.changeOrderSettingStatus(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation("单据类型配置 - 删除")
    @PostMapping("/delete")
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        log.info("[SCP-ORDER-SETTING] delete ids = {}", JSONUtil.toJsonStr(ids));
        scpOrderSettingService.deleteByIds(ids);
        return ApiResult.ok();
    }

    @ApiOperation("根据单据类型获取首选商品分类")
    @PostMapping("/cateCode")
    public ApiResult<Object> getFirstCateCode(@RequestBody ScpOrderSettingBaseParamVO paramVO) {
        log.info("[SCP-ORDER-SETTING] getFirstCateCode param = {}", paramVO);
        return ApiResult.ok(scpOrderSettingService.getFirstItemCate(paramVO));
    }

}
