package com.elitesland.scp.application.web.stock;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.stock.*;
import com.elitesland.scp.application.service.stock.ScpSafetyTargetStockService;
import com.elitesland.scp.utils.excel.ExcelWriteUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;
import java.io.IOException;

/**
 * <p>
 * 供应链计划-安全库存目标库存 前端控制器
 * </p>
 *
 * @author jeesie.jiang
 * @since 2025-01-15
 */
@Slf4j
@Api(tags = "安全库存&&目标库存")
@RestController
@RequestMapping(value = "/safetyTarget/stock", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
@Validated
public class ScpSafetyTargetStockController {

    private final ScpSafetyTargetStockService scpSafetyTargetStockService;


    @ApiOperation(value = "安全库存&&目标库存-分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpSafetyTargetStockPageVO>> page(@RequestBody ScpSafetyTargetStockPageParam param) {
        return ApiResult.ok(scpSafetyTargetStockService.searchPage(param));
    }


    @ApiOperation(value = "安全库存&&目标库存-新增/编辑")
    @PostMapping(value = "/save")
    public ApiResult<String>save(@Valid @RequestBody ScpSafetyTargetStockSaveVO param) {
        return ApiResult.ok(scpSafetyTargetStockService.saveSafetyTargetStock(param));
    }

    @ApiOperation(value = "安全库存&&目标库存-批量新增/编辑")
    @PostMapping(value = "/batchSave")
    public ApiResult<?> saveBatch(@Valid @RequestBody List<ScpSafetyTargetStockSaveVO> param) {
        scpSafetyTargetStockService.batchSaveSafetyTargetStock(param);
        return ApiResult.ok();
    }


    @ApiOperation(value = "安全库存&&目标库存-删除")
    @PostMapping(value = "/delete")
    public ApiResult<?> delete(@RequestBody List<Long> ids) {
        scpSafetyTargetStockService.delete(ids);
        return ApiResult.ok();
    }


    @PostMapping("/download")
    @ApiOperation("导入模版下载导出")
    public void download(HttpServletResponse response, @RequestBody ScpSafetyTargetStockDownLoadParam param) throws IOException {
        List<ScpSafetyTargetStockDownloadVO>  ret = scpSafetyTargetStockService.downloadTmplFile(param);
        log.info("mrp标准库存下载模版成功，数据：{}", JSON.toJSONString(ret));
        ExcelWriteUtil.autoAliasExcelWrite(response, ret, ScpSafetyTargetStockDownloadVO.class, "安全库存&目的库存导入模版", "安全库存&目的库存导入模版");

    }














}
