package com.elitesland.scp.domain.entity.calendar;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * @Author: ryan.xu
 * @since 2024/12/23
 */
@Data
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "scp_store_calendar_set")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@org.hibernate.annotations.Table(appliesTo = "scp_store_calendar_set", comment = "门店订货日历配置主表")
public class ScpStoreCalendarSetDO extends BaseModel implements Serializable {

    @Column()
    @Comment("配置编码")
    private String setCode;

    @Column()
    @Comment("配置名称")
    private String setName;

    @Column()
    @Comment("配置描述")
    private String setDescription;

    @Column()
    @Comment("起始年份")
    private Integer startYear;

    @Column()
    @Comment("结束年份")
    private Integer endYear;

    @ApiModelProperty("流程实例状态")
    @Column
    @Comment("流程实例状态")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    @Comment("提交时间")
    @Column
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    @Comment("审批通过时间")
    @Column
    private LocalDateTime approvedTime;

    @ApiModelProperty(value = "单据状态")
    @Comment("单据状态")
    @Column()
    private String docStatus;

    @ApiModelProperty("审批时间")
    @Comment("审批时间")
    @Column()
    private LocalDateTime apprTime;

    @ApiModelProperty(value = "审批意见")
    @Comment("审批意见")
    @Column()
    private String approveComment;

    @ApiModelProperty(value = "单据类型")
    @Comment("单据类型")
    @Column()
    private String itemType2;

}