package com.elitesland.scp.domain.entity.mrp;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 物料需求计划明细采购计划
 *
 * @author chaofeng.xia
 * @since 2025/1/14
 */
@Data
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "scp_mrp_d_plan")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@org.hibernate.annotations.Table(appliesTo = "scp_mrp_d_plan", comment = "物料需求计划明细采购计划")
public class ScpMrpDPlanDO extends BaseModel implements Serializable {

    @Comment("MRP计划Id")
    @Column(name = "mrp_id", columnDefinition = "bigint comment 'MRP计划Id'")
    private Long mrpId;

    @Comment("主表ID")
    @Column(name = "mas_id", columnDefinition = "bigint comment '主表ID'")
    private Long masId;

    @Comment("采购公司id")
    @Column(name = "ou_id", columnDefinition = "bigint comment '采购公司id'")
    private Long ouId;

    @Comment("采购公司编码")
    @Column(name = "ou_code", columnDefinition = "varchar(64) comment '采购公司编码'")
    private String ouCode;

    @Comment("采购公司名称")
    @Column(name = "ou_name", columnDefinition = "varchar(64) comment '采购公司名称'")
    private String ouName;

    @Comment("供应商id")
    @Column(name = "supp_id", columnDefinition = "bigint comment '供应商id'")
    private Long suppId;

    @Comment("供应商编码")
    @Column(name = "supp_code", columnDefinition = "varchar(64) comment '供应商编码'")
    private String suppCode;

    @Comment("供应商名称")
    @Column(name = "supp_name", columnDefinition = "varchar(64) comment '供应商名称'")
    private String suppName;

    @Comment("采购计划数量")
    @Column(name = "qty", columnDefinition = "decimal(20, 8) comment '采购计划数量'")
    private BigDecimal qty;

    @Comment("采购订单号")
    @Column(name = "po_no", columnDefinition = "varchar(64) comment '采购订单号'")
    private String poNo;

    @Comment("采购订单明细ID")
    @Column(name = "po_d_id", columnDefinition = "bigint comment '采购订单明细ID'")
    private Long poDId;

    @Comment("采购订单行号")
    @Column(name = "po_line_no", columnDefinition = "int comment '采购订单行号'")
    private Integer poLineNo;

    @Column(name = "push_status", columnDefinition = "varchar(20)")
    @Comment("推送状态")
    private String pushStatus;

    @Column(name = "push_fail_reason", columnDefinition = "varchar(511)")
    @Comment("推送失败原因")
    private String pushFailReason;
}