package com.elitesland.scp.infr.repo.alloc;

import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingRegionPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingRegionRespVO;
import com.elitesland.scp.domain.entity.alloc.QScpAllocSettingRegionDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpAllocSettingRegionRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpAllocSettingRegionDO scpAllocSettingRegionDO = QScpAllocSettingRegionDO.scpAllocSettingRegionDO;

    public long countAllocSettingRegion(ScpAllocSettingRegionPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpAllocSettingRegionDO.count())
                .from(scpAllocSettingRegionDO);
        jpaQuery.where(this.whereAllocSettingPage(paramVO));
        return jpaQuery.fetchCount();
    }

    private final QBean<ScpAllocSettingRegionRespVO> pageList = Projections.bean(
            ScpAllocSettingRegionRespVO.class,
            scpAllocSettingRegionDO.id,
            scpAllocSettingRegionDO.masId,
            scpAllocSettingRegionDO.region,
            scpAllocSettingRegionDO.regionName

    );

    public List<ScpAllocSettingRegionRespVO> queryAllocSettingRegion(ScpAllocSettingRegionPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(scpAllocSettingRegionDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpAllocSettingRegionDO);
        jpaQuery.where(this.whereAllocSettingPage(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereAllocSettingPage(ScpAllocSettingRegionPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (paramVO.getMasId() != null) {
            predicates.add(scpAllocSettingRegionDO.masId.eq(paramVO.getMasId()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<Long> findMasIdByRegionCode(String regionCode) {
        var jpaQuery = jpaQueryFactory.select(scpAllocSettingRegionDO.masId).distinct()
                .from(scpAllocSettingRegionDO);
        jpaQuery.where(scpAllocSettingRegionDO.region.eq(regionCode));
        return jpaQuery.fetch();
    }

}
