package com.elitesland.scp.infr.repo.stock;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockCalcPageParam;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockCalcPageVO;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockPageParam;
import com.elitesland.scp.application.facade.vo.stock.ScpStStockCalcUpdateParam;
import com.elitesland.scp.domain.entity.stock.QScpPredictStStockCalcDO;
import com.elitesland.scp.domain.entity.stock.ScpPredictStStockCalcDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2025-01-21
* @Version 1.0
**/
@Component
public class ScpPredictStStockCalcRepoProc extends BaseRepoProc<ScpPredictStStockCalcDO>{

    private static final  QScpPredictStStockCalcDO qScpPredictStStockCalcDO = QScpPredictStStockCalcDO.scpPredictStStockCalcDO;
    public ScpPredictStStockCalcRepoProc(){
        super(qScpPredictStStockCalcDO);
    }


    public PagingVO<ScpPredictStStockCalcPageVO> page(ScpPredictStStockCalcPageParam param){
        JPAQuery<ScpPredictStStockCalcPageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpPredictStStockCalcPageVO.class,
                qScpPredictStStockCalcDO.id,
                qScpPredictStStockCalcDO.tenantId,
                qScpPredictStStockCalcDO.remark,
                qScpPredictStStockCalcDO.createUserId,
                qScpPredictStStockCalcDO.creator,
                qScpPredictStStockCalcDO.createTime,
                qScpPredictStStockCalcDO.modifyUserId,
                qScpPredictStStockCalcDO.updater,
                qScpPredictStStockCalcDO.modifyTime,
                qScpPredictStStockCalcDO.deleteFlag,
                qScpPredictStStockCalcDO.auditDataVersion,
                qScpPredictStStockCalcDO.ouId,
                qScpPredictStStockCalcDO.ouCode,
                qScpPredictStStockCalcDO.ouName,
                qScpPredictStStockCalcDO.predLotNo,
                qScpPredictStStockCalcDO.calcuStatus
        )).from(qScpPredictStStockCalcDO);
        jpaQuery.where(where(param));
        return queryByPage(jpaQuery,param.getPageRequest());
    }


    private Predicate where(ScpPredictStStockCalcPageParam param){
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if(CollectionUtils.isNotEmpty(param.getOuIds())){
            predicate = ExpressionUtils.and(predicate, qScpPredictStStockCalcDO.ouId.in(param.getOuIds()));
        }
        if(StringUtils.isNotEmpty(param.getPredLotNo())){
            predicate = ExpressionUtils.and(predicate, qScpPredictStStockCalcDO.predLotNo.eq(param.getPredLotNo()));
        }
        if(StringUtils.isNotEmpty(param.getPredLotNo())){
            predicate = ExpressionUtils.and(predicate, qScpPredictStStockCalcDO.predLotNo.eq(param.getPredLotNo()));
        }
        if(CollectionUtils.isNotEmpty(param.getStIds())){
            predicate = ExpressionUtils.and(predicate, qScpPredictStStockCalcDO.id.in(param.getStIds()));
        }
        return predicate;
    }

    public void updateStStockCalcStatus(List<Long> stIds,String calcuStatus){
        jpaQueryFactory.update(qScpPredictStStockCalcDO).set(qScpPredictStStockCalcDO.calcuStatus,calcuStatus)
                .where(qScpPredictStStockCalcDO.id.in(stIds)).execute();
    }


    @Transactional
    public void updateStStockCalcStatus(ScpStStockCalcUpdateParam updateParam){
        jpaQueryFactory.update(qScpPredictStStockCalcDO)
                .set(qScpPredictStStockCalcDO.calcuStatus,updateParam.getCalcuStatus())
                .set(qScpPredictStStockCalcDO.calcuMsg,updateParam.getCalcuMsg())
                .where(qScpPredictStStockCalcDO.id.in(updateParam.getStIds()))
                .execute();
    }


    @Transactional
    public void updateBatchCalcStatus(List<ScpStStockCalcUpdateParam> updateParams){
        updateParams.forEach(updateParam ->{
            JPAUpdateClause updateClause = jpaQueryFactory.update(qScpPredictStStockCalcDO)
                    .set(qScpPredictStStockCalcDO.calcuStatus, updateParam.getCalcuStatus());
            if(StringUtils.isNotEmpty(updateParam.getCalcuMsg())){
                updateClause.set(qScpPredictStStockCalcDO.calcuMsg,updateParam.getCalcuMsg());
            }
            updateClause.where(qScpPredictStStockCalcDO.id.in(updateParam.getStIds()))
            .execute();
        });
    }

}