/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.calendar;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetComputeParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLineParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetPageParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLineRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetApproveVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetSaveVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetSubmitVO;
import com.elitesland.scp.application.service.calendar.ScpStoreCalendarSetService;
import com.elitesland.scp.application.service.setting.ScpOrderSettingService;
import com.elitesland.scp.domain.convert.calendar.ScpStoreCalendarSetConvert;
import com.elitesland.scp.domain.convert.calendar.ScpStoreDemandCalendarConvert;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import com.elitesland.scp.domain.service.calendar.ScpStoreCalendarSetDomainService;
import com.elitesland.scp.domain.service.calendar.ScpStoreCalendarSetLineDomainService;
import com.elitesland.scp.domain.service.calendar.ScpStoreDemandCalendarDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.calendar.ScpStoreCalendarSetDTO;
import com.elitesland.scp.utils.CalendarBuilder;
import com.elitesland.workflow.enums.ProcInstStatus;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ScpStoreCalendarSetServiceImpl
implements ScpStoreCalendarSetService {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreCalendarSetServiceImpl.class);
    private final ScpStoreCalendarSetDomainService scpStoreCalendarSetDomainService;
    private final ScpStoreCalendarSetLineDomainService scpStoreCalendarSetLineDomainService;
    private final TransactionTemplate transactionTemplate;
    private final ScpStoreDemandCalendarDomainService scpStoreDemandCalendarDomainService;
    private final TaskExecutor taskExecutor;
    private final ScpOrderSettingService scpOrderSettingService;

    @Override
    @SysCodeProc
    public PagingVO<ScpStoreCalendarSetPageRespVO> page(ScpStoreCalendarSetPageParamVO paramVO) {
        return this.scpStoreCalendarSetDomainService.queryCalendarSetList(paramVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveCalendarSet(ScpStoreCalendarSetSaveVO saveVO) {
        this.checkSetting(saveVO);
        if (CollUtil.isNotEmpty(saveVO.getItemType2s())) {
            saveVO.setItemType2(String.join((CharSequence)",", saveVO.getItemType2s()));
        }
        return this.scpStoreCalendarSetDomainService.saveCalendarSet(saveVO);
    }

    @Override
    @SysCodeProc
    public Optional<ScpStoreCalendarSetRespVO> findCalendarSetById(Long id) {
        return this.scpStoreCalendarSetDomainService.findCalendarSetById(id).map(ScpStoreCalendarSetConvert.INSTANCE::dtoToRespVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpStoreCalendarSetDomainService.deleteByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submit(ScpStoreCalendarSetSubmitVO submitVO) {
        ScpStoreCalendarSetLineParamVO scpStoreCalendarSetLineParamVO = new ScpStoreCalendarSetLineParamVO();
        scpStoreCalendarSetLineParamVO.setMasId(submitVO.getId());
        Long count = this.scpStoreCalendarSetLineDomainService.countCalendarSetLine(scpStoreCalendarSetLineParamVO);
        if (count == 0L) {
            throw new BusinessException("\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u914d\u7f6e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.scpStoreCalendarSetDomainService.applyChangeUpdate(submitVO.getId(), ScpUdcEnum.CALENDAR_SET_STATUS_APPRING.getValueCode(), ProcInstStatus.APPROVING);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchApprove(ScpStoreCalendarSetApproveVO approveSaveParam) {
        this.scpStoreCalendarSetDomainService.approveUpdateApplyAlter(approveSaveParam.getIds(), ScpUdcEnum.CALENDAR_SET_STATUS_COMPLETE.getValueCode(), ProcInstStatus.APPROVED, approveSaveParam.getApproveComment(), LocalDateTime.now());
        CompletableFuture.runAsync(() -> {
            for (Long id : approveSaveParam.getIds()) {
                this.batchSaveCalendar(id);
            }
        }, (Executor)this.taskExecutor);
    }

    private void batchSaveCalendar(Long id) {
        Optional<ScpStoreCalendarSetDTO> calendarSetDTO = this.scpStoreCalendarSetDomainService.findCalendarSetById(id);
        if (calendarSetDTO.isEmpty()) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u914d\u7f6e\u4fe1\u606f");
        }
        ScpStoreCalendarSetDTO scpStoreCalendarSetDTO = calendarSetDTO.get();
        List<String> itemType2s = scpStoreCalendarSetDTO.getItemType2s();
        if (CollUtil.isNotEmpty(itemType2s) && itemType2s.contains("all")) {
            ScpOrderSettingParamVO scpOrderSettingParamVO = new ScpOrderSettingParamVO();
            List<ScpOrderSettingRespVO> scpOrderSettingRespVOS = this.scpOrderSettingService.queryOrderSettingList(scpOrderSettingParamVO);
            List collect = scpOrderSettingRespVOS.stream().map(ScpOrderSettingRespVO::getDocType).collect(Collectors.toList());
            collect.remove("BF");
            itemType2s = collect;
        }
        Integer startYear = scpStoreCalendarSetDTO.getStartYear();
        LocalDate startOfYear = LocalDate.of((int)startYear, 1, 1);
        List<ScpStoreCalendarSetLineRespVO> storeInfos = this.scpStoreCalendarSetLineDomainService.findStoreCodeByMasId(id, startYear);
        List<String> storeCodes = storeInfos.stream().map(ScpStoreCalendarSetLineRespVO::getStoreCode).collect(Collectors.toList());
        this.scpStoreDemandCalendarDomainService.deleteByStoreAndYear(storeCodes, startYear.toString());
        ScpStoreCalendarSetComputeParamVO computeParamVO = this.getScpStoreCalendarSetComputeParamVO(id, storeInfos);
        for (int i = 0; i < 12; ++i) {
            log.info("\u5f00\u59cb\u5199\u5165:{}\u6708\u4efd\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386", (Object)(i + 1));
            this.transactionTemplate.setPropagationBehavior(3);
            int finalI = i;
            List<String> finalItemType2s = itemType2s;
            this.transactionTemplate.execute(trans -> {
                try {
                    LocalDate startDate = startOfYear.plusMonths(finalI);
                    LocalDate endDate = startDate.with(TemporalAdjusters.lastDayOfMonth());
                    List<ScpStoreDemandCalendarDO> scpStoreDemandCalendarDOS = CalendarBuilder.buildCalendarSetList(startDate, endDate, computeParamVO);
                    ArrayList<ScpStoreDemandCalendarDO> typeList = new ArrayList<ScpStoreDemandCalendarDO>();
                    finalItemType2s.forEach(itemType2 -> {
                        List copiedList = scpStoreDemandCalendarDOS.stream().map(original -> {
                            ScpStoreDemandCalendarDO scpStoreDemandCalendarDO = ScpStoreDemandCalendarConvert.INSTANCE.doToDo((ScpStoreDemandCalendarDO)original);
                            scpStoreDemandCalendarDO.setItemType2((String)itemType2);
                            return scpStoreDemandCalendarDO;
                        }).collect(Collectors.toList());
                        typeList.addAll(copiedList);
                    });
                    this.scpStoreDemandCalendarDomainService.batchInsert(typeList, 10000);
                    return "OK";
                }
                catch (Exception e) {
                    trans.setRollbackOnly();
                    throw new BusinessException(ApiCode.FAIL, e.getMessage());
                }
            });
            log.info("\u7ed3\u675f\u5199\u5165:{}\u6708\u4efd\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386", (Object)(i + 1));
        }
    }

    private ScpStoreCalendarSetComputeParamVO getScpStoreCalendarSetComputeParamVO(Long masId, List<ScpStoreCalendarSetLineRespVO> storeInfos) {
        List<ScpStoreCalendarSetLineRespVO> monList = this.scpStoreCalendarSetLineDomainService.findCalendarSetByParam(masId, 1);
        List<ScpStoreCalendarSetLineRespVO> tuesList = this.scpStoreCalendarSetLineDomainService.findCalendarSetByParam(masId, 2);
        List<ScpStoreCalendarSetLineRespVO> wendsList = this.scpStoreCalendarSetLineDomainService.findCalendarSetByParam(masId, 3);
        List<ScpStoreCalendarSetLineRespVO> thursList = this.scpStoreCalendarSetLineDomainService.findCalendarSetByParam(masId, 4);
        List<ScpStoreCalendarSetLineRespVO> friList = this.scpStoreCalendarSetLineDomainService.findCalendarSetByParam(masId, 5);
        List<ScpStoreCalendarSetLineRespVO> saturList = this.scpStoreCalendarSetLineDomainService.findCalendarSetByParam(masId, 6);
        List<ScpStoreCalendarSetLineRespVO> sunList = this.scpStoreCalendarSetLineDomainService.findCalendarSetByParam(masId, 7);
        ScpStoreCalendarSetComputeParamVO computeParamVO = new ScpStoreCalendarSetComputeParamVO();
        computeParamVO.setMonList(monList);
        computeParamVO.setTuesList(tuesList);
        computeParamVO.setWendsList(wendsList);
        computeParamVO.setThursList(thursList);
        computeParamVO.setFriList(friList);
        computeParamVO.setSaturList(saturList);
        computeParamVO.setSunList(sunList);
        computeParamVO.setStoreInfos(storeInfos);
        computeParamVO.setNonMonList(this.findMissingList(monList, storeInfos));
        computeParamVO.setNonTuesList(this.findMissingList(tuesList, storeInfos));
        computeParamVO.setNonWendsList(this.findMissingList(wendsList, storeInfos));
        computeParamVO.setNonThursList(this.findMissingList(thursList, storeInfos));
        computeParamVO.setNonFriList(this.findMissingList(friList, storeInfos));
        computeParamVO.setNonSaturList(this.findMissingList(saturList, storeInfos));
        computeParamVO.setNonSunList(this.findMissingList(sunList, storeInfos));
        return computeParamVO;
    }

    public List<ScpStoreCalendarSetLineRespVO> findMissingList(List<ScpStoreCalendarSetLineRespVO> filterList, List<ScpStoreCalendarSetLineRespVO> storeInfos) {
        Set storeCodesInList = filterList.stream().map(ScpStoreCalendarSetLineRespVO::getStoreCode).collect(Collectors.toCollection(HashSet::new));
        return storeInfos.stream().filter(storeInfo -> !storeCodesInList.contains(storeInfo.getStoreCode())).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchReject(ScpStoreCalendarSetApproveVO approveSaveParam) {
        this.scpStoreCalendarSetDomainService.approveUpdateApplyAlter(approveSaveParam.getIds(), ScpUdcEnum.CALENDAR_SET_STATUS_REJECTED.getValueCode(), ProcInstStatus.REJECTED, approveSaveParam.getApproveComment(), LocalDateTime.now());
    }

    private void checkSetting(ScpStoreCalendarSetSaveVO saveVO) {
        if (saveVO.getEndYear() == null) {
            saveVO.setEndYear(saveVO.getStartYear());
        }
        ScpStoreCalendarSetParamVO scpStoreCalendarSetParamVO = new ScpStoreCalendarSetParamVO();
        scpStoreCalendarSetParamVO.setSetName(saveVO.getSetName());
        scpStoreCalendarSetParamVO.setSetCode(saveVO.getSetCode());
        scpStoreCalendarSetParamVO.setEndYear(saveVO.getEndYear());
        scpStoreCalendarSetParamVO.setStartYear(saveVO.getStartYear());
        List<ScpStoreCalendarSetRespVO> calendarSets = this.scpStoreCalendarSetDomainService.findCalendarSet(scpStoreCalendarSetParamVO);
        if (CollUtil.isNotEmpty(calendarSets)) {
            ScpStoreCalendarSetRespVO scpStoreCalendarSetRespVO = calendarSets.get(0);
            if (saveVO.getId() != null && !saveVO.getId().equals(scpStoreCalendarSetRespVO.getId())) {
                throw new BusinessException("\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u914d\u7f6e\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        if (saveVO.getId() == null) {
            saveVO.setDocStatus(ScpUdcEnum.CALENDAR_SET_STATUS_DR.getValueCode());
        }
    }

    public ScpStoreCalendarSetServiceImpl(ScpStoreCalendarSetDomainService scpStoreCalendarSetDomainService, ScpStoreCalendarSetLineDomainService scpStoreCalendarSetLineDomainService, TransactionTemplate transactionTemplate, ScpStoreDemandCalendarDomainService scpStoreDemandCalendarDomainService, TaskExecutor taskExecutor, ScpOrderSettingService scpOrderSettingService) {
        this.scpStoreCalendarSetDomainService = scpStoreCalendarSetDomainService;
        this.scpStoreCalendarSetLineDomainService = scpStoreCalendarSetLineDomainService;
        this.transactionTemplate = transactionTemplate;
        this.scpStoreDemandCalendarDomainService = scpStoreDemandCalendarDomainService;
        this.taskExecutor = taskExecutor;
        this.scpOrderSettingService = scpOrderSettingService;
    }
}

