/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.scpsman;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserTypeDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeUpsertDTO;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.scp.application.facade.vo.scpsman.EmployeeDetailInfoRespVO;
import com.elitesland.scp.application.facade.vo.scpsman.EmployeeInfoRespVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanDetailInfoRespVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanImportSaveVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoChangeVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoDetailRespVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoQueryVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoRespVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoSaveVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanRegionVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanSimpleInfoRespVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanSubordinateQueryVO;
import com.elitesland.scp.application.facade.vo.scpsman.ScpsmanImportRespVO;
import com.elitesland.scp.application.service.scpsman.ScpsmanInfoService;
import com.elitesland.scp.common.Constant;
import com.elitesland.scp.domain.convert.scpsman.SalesmanInfoConvert;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDDO;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanRegionDO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityDService;
import com.elitesland.scp.dto.scpsman.SalesmanLevelInfoDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityDRepo;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepo;
import com.elitesland.scp.infr.repo.scpsman.SalesmanRegionRepo;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepoProc;
import com.elitesland.scp.rmi.RmiOrgOuService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.support.provider.org.dto.OrgContactRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.google.common.collect.Lists;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ScpsmanInfoServiceImpl
implements ScpsmanInfoService {
    private static final Logger log = LogManager.getLogger(ScpsmanInfoServiceImpl.class);
    private final TransactionTemplate transactionTemplate;
    public static final String SCPSMAN = "scpsman";
    @Autowired
    private ScpsmanInfoRepo scpsmanInfoRepo;
    @Autowired
    private ScpsmanInfoRepoProc scpsmanInfoRepoProc;
    @Autowired
    private RmiSysUDCService rmiSysUDCService;
    @Autowired
    private EmployeeRpcService employeeRpcService;
    @Autowired
    private OrgRpcService orgRpcService;
    @Autowired
    private Constant constant;
    @Autowired
    private SalesmanRegionRepo salesmanRegionRepo;
    @Autowired
    private OrgOuRpcService orgOuRpcService;
    @Autowired
    private SysAreaRpcService sysAreaRpcService;
    private final ScpDemandAuthorityDService scpDemandAuthorityDService;
    @Autowired
    private final ScpDemandAuthorityRepo scpDemandAuthorityRepo;
    @Autowired
    private final ScpDemandAuthorityDRepo scpDemandAuthorityDRepo;
    @Autowired
    private RmiOrgStoreRpcService rmiOrgStoreRpcService;
    @Autowired
    private RmiOrgOuService rmiOrgOuService;
    @Autowired
    private UserRpcService userRpcService;
    @Autowired
    private SysSettingService settingService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> save(SalesmanInfoSaveVO salesmanInfoSaveVO) {
        log.info("\u8ba1\u5212\u5458\u4fe1\u606f\u4fdd\u5b58\u5165\u53c2 {}", (Object)salesmanInfoSaveVO.toString());
        ScpsmanInfoDO bySalesmanNo = this.scpsmanInfoRepo.findByScpsmanNo(salesmanInfoSaveVO.getScpsmanNo());
        if (Optional.ofNullable(bySalesmanNo).isPresent() && (salesmanInfoSaveVO.getId() == null || salesmanInfoSaveVO.getId() == 0L)) {
            return ApiResult.fail((String)"\u8be5\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        ScpsmanInfoDO byLoginAccount = this.scpsmanInfoRepo.findByLoginAccount(salesmanInfoSaveVO.getLoginAccount());
        if (Optional.ofNullable(byLoginAccount).isPresent() && (salesmanInfoSaveVO.getId() == null || salesmanInfoSaveVO.getId() == 0L)) {
            throw new BusinessException("\u8be5\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        if (salesmanInfoSaveVO.getId() != null) {
            this.salesmanRegionRepo.deleteByMasId(salesmanInfoSaveVO.getId());
        }
        ScpsmanInfoDO scpsmanInfoDO = SalesmanInfoConvert.INSTANCE.salesmanInfoSaveToDO(salesmanInfoSaveVO);
        scpsmanInfoDO.setEnableStatus(1);
        EmployeeUpsertDTO upsertDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoSaveVOToUpsertDTO(salesmanInfoSaveVO);
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoSaveVO.getBirthdayTime())) {
            upsertDTO.setBirthDate(this.constant.stringToLocalDate(salesmanInfoSaveVO.getBirthdayTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoSaveVO.getJoinTime())) {
            upsertDTO.setJoinTime(this.constant.swapTimeMin(salesmanInfoSaveVO.getJoinTime()));
        }
        if ("EMP".equals(scpsmanInfoDO.getSource())) {
            upsertDTO.setType("SCPSMAN");
        }
        ScpsmanInfoDO save = (ScpsmanInfoDO)((Object)this.scpsmanInfoRepo.save((Object)scpsmanInfoDO));
        this.buildEmployee(salesmanInfoSaveVO, scpsmanInfoDO, upsertDTO, String.valueOf(save.getId()));
        ArrayList<ScpsmanRegionDO> scpsmanRegionDOS = new ArrayList<ScpsmanRegionDO>();
        if (CollUtil.isNotEmpty(salesmanInfoSaveVO.getJurisdictions())) {
            for (String jurisdiction : salesmanInfoSaveVO.getJurisdictions()) {
                ScpsmanRegionDO scpsmanRegionDO = new ScpsmanRegionDO();
                scpsmanRegionDO.setRegionCode(jurisdiction);
                scpsmanRegionDO.setMasId(save.getId());
                scpsmanRegionDOS.add(scpsmanRegionDO);
            }
        }
        this.salesmanRegionRepo.saveAll(scpsmanRegionDOS);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<PagingVO<SalesmanInfoRespVO>> query(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        ApiResult result;
        List salesmanCodeList;
        log.info("\u8ba1\u5212\u5458\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u5165\u53c2 {}", (Object)salesmanInfoQueryVO);
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-suplan", "SCPSMAN_TYPE");
        Map<String, String> regionUDCMap = this.rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        if (salesmanInfoQueryVO.getNoQueryParam() == 1) {
            JPAQuery<SalesmanSimpleInfoRespVO> jpaQuery = this.scpsmanInfoRepoProc.findAllSalesmanCode();
            List salesmanCodeList2 = jpaQuery.fetch();
            if (CollUtil.isEmpty((Collection)salesmanCodeList2)) {
                return ApiResult.ok((Object)PagingVO.builder().total(0L).build());
            }
            Set codes = salesmanCodeList2.stream().map(SalesmanSimpleInfoRespVO::getScpsmanNo).filter(Objects::nonNull).collect(Collectors.toSet());
            log.info("\u8ba1\u5212\u5458\u7f16\u7801\u6570\u91cf\u5927\u5c0f:{}", (Object)codes.size());
            EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
            employeePageQueryDTO.setCodes(codes);
            employeePageQueryDTO.setSize(salesmanInfoQueryVO.getSize());
            employeePageQueryDTO.setCurrent(Integer.valueOf(salesmanInfoQueryVO.getCurrent() + 2));
            ApiResult result2 = this.employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!result2.isSuccess()) {
                throw new BusinessException("\u5458\u5de5\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01" + result2.getMsg());
            }
            long total = ((PagingVO)result2.getData()).getTotal();
            List employeePageRespDTOList = ((PagingVO)result2.getData()).getRecords();
            log.info("\u67e5\u8be2\u5458\u5de5\u6570\u636e\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)employeePageRespDTOList));
            if (CollUtil.isEmpty((Collection)employeePageRespDTOList)) {
                return ApiResult.ok((Object)PagingVO.builder().total(0L).build());
            }
            List<EmployeeInfoRespVO> employeeInfoRespVOS = SalesmanInfoConvert.INSTANCE.employeePageRespDTOToEmployeeInfoRespVO(employeePageRespDTOList);
            Map employeeInfoRespVOMap = employeeInfoRespVOS.stream().collect(Collectors.toMap(EmployeeInfoRespVO::getCode, Function.identity(), (k1, k2) -> k1));
            List<String> scpManNoList = employeePageRespDTOList.stream().map(EmployeePageRespDTO::getCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            log.info("scpManNoList\u7684\u503c:{}", (Object)JSONUtil.toJsonStr(scpManNoList));
            SalesmanInfoQueryVO queryVO = new SalesmanInfoQueryVO();
            queryVO.setCodes(scpManNoList);
            List salesmanInfoRespVOList = this.scpsmanInfoRepoProc.findSalesmanInfo(queryVO).fetch();
            Map<Long, List<SalesmanRegionVO>> regionMap = this.getSalesmanRegionMap(regionUDCMap, salesmanInfoRespVOList.stream().map(SalesmanInfoRespVO::getId).collect(Collectors.toList()));
            for (SalesmanInfoRespVO salesmanInfoRespVO : salesmanInfoRespVOList) {
                salesmanInfoRespVO.setEmployeeInfoRespVO((EmployeeInfoRespVO)employeeInfoRespVOMap.get(salesmanInfoRespVO.getScpsmanNo()));
                salesmanInfoRespVO.setEnableStatusName(salesmanInfoRespVO.getEnableStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
                salesmanInfoRespVO.setScpsmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRespVO.getScpsmanType()));
                salesmanInfoRespVO.setJurisdiction(regionMap.get(salesmanInfoRespVO.getId()));
            }
            return ApiResult.ok((Object)PagingVO.builder().total(total).records(salesmanInfoRespVOList).build());
        }
        SalesmanInfoQueryVO queryParam = new SalesmanInfoQueryVO();
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getScpsman())) {
            queryParam.setScpsman(salesmanInfoQueryVO.getScpsman());
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getLoginAccount())) {
            queryParam.setLoginAccount(salesmanInfoQueryVO.getLoginAccount());
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getOuCode())) {
            queryParam.setOuCode(salesmanInfoQueryVO.getOuCode());
        }
        if (salesmanInfoQueryVO.getEnableStatus() != null) {
            queryParam.setEnableStatus(salesmanInfoQueryVO.getEnableStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getScpsmanType())) {
            queryParam.setScpsmanType(salesmanInfoQueryVO.getScpsmanType());
        }
        if (CollUtil.isEmpty((Collection)(salesmanCodeList = this.scpsmanInfoRepoProc.findAllSalesmanCode(queryParam).fetch()))) {
            return ApiResult.ok((Object)PagingVO.builder().total(0L).build());
        }
        Set codes = salesmanCodeList.stream().map(SalesmanSimpleInfoRespVO::getScpsmanNo).filter(Objects::nonNull).collect(Collectors.toSet());
        log.info("\u8ba1\u5212\u5458\u7f16\u7801\u6570\u91cf\u5927\u5c0f:{}", (Object)codes.size());
        EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
        employeePageQueryDTO.setCodes(codes);
        employeePageQueryDTO.setCurrent(salesmanInfoQueryVO.getCurrent());
        employeePageQueryDTO.setSize(salesmanInfoQueryVO.getSize());
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getOrgId())) {
            employeePageQueryDTO.setOrgId(Long.valueOf(Long.parseLong(salesmanInfoQueryVO.getOrgId())));
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getPhone())) {
            employeePageQueryDTO.setPhone(salesmanInfoQueryVO.getPhone());
        }
        if (!(result = this.employeeRpcService.queryByPage(employeePageQueryDTO)).isSuccess()) {
            throw new BusinessException("\u5458\u5de5\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01" + result.getMsg());
        }
        List employeePageRespDTOList = ((PagingVO)result.getData()).getRecords();
        log.info("\u67e5\u8be2\u5458\u5de5\u6570\u636e\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)employeePageRespDTOList));
        if (CollUtil.isEmpty((Collection)employeePageRespDTOList)) {
            return ApiResult.ok((Object)PagingVO.builder().total(0L).build());
        }
        long total = ((PagingVO)result.getData()).getTotal();
        List<String> scpManNoList = employeePageRespDTOList.stream().map(EmployeePageRespDTO::getCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        log.info("scpManNoList\u7684\u503c:{}", (Object)JSONUtil.toJsonStr(scpManNoList));
        List<EmployeeInfoRespVO> employeeInfoRespVOS = SalesmanInfoConvert.INSTANCE.employeePageRespDTOToEmployeeInfoRespVO(employeePageRespDTOList);
        Map employeeInfoRespVOMap = employeeInfoRespVOS.stream().collect(Collectors.toMap(EmployeeInfoRespVO::getCode, Function.identity(), (k1, k2) -> k1));
        salesmanInfoQueryVO.setCodes(scpManNoList);
        JPAQuery<SalesmanInfoRespVO> jpaQuery = this.scpsmanInfoRepoProc.findSalesmanInfo(salesmanInfoQueryVO);
        List salesmanInfoRespVOList = jpaQuery.fetch();
        if (CollUtil.isEmpty((Collection)salesmanInfoRespVOList)) {
            return ApiResult.ok((Object)PagingVO.builder().total(0L).build());
        }
        Map<Long, List<SalesmanRegionVO>> regionMap = this.getSalesmanRegionMap(regionUDCMap, salesmanInfoRespVOList.stream().map(SalesmanInfoRespVO::getId).collect(Collectors.toList()));
        for (SalesmanInfoRespVO salesmanInfoRespVO : salesmanInfoRespVOList) {
            salesmanInfoRespVO.setEmployeeInfoRespVO((EmployeeInfoRespVO)employeeInfoRespVOMap.get(salesmanInfoRespVO.getScpsmanNo()));
            salesmanInfoRespVO.setEnableStatusName(salesmanInfoRespVO.getEnableStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
            salesmanInfoRespVO.setScpsmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRespVO.getScpsmanType()));
            salesmanInfoRespVO.setJurisdiction(regionMap.get(salesmanInfoRespVO.getId()));
        }
        return ApiResult.ok((Object)PagingVO.builder().total(total).records(salesmanInfoRespVOList).build());
    }

    @Override
    public ApiResult<SalesmanInfoDetailRespVO> queryDetail(Long id) {
        log.info("\u8ba1\u5212\u5458\u8be6\u7ec6\u4fe1\u606f\u67e5\u8be2\u5165\u53c2 {}", (Object)id);
        Optional ScpsmanInfoDOOptional = this.scpsmanInfoRepo.findById(id);
        if (ScpsmanInfoDOOptional.isEmpty()) {
            return ApiResult.ok();
        }
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-suplan", "SCPSMAN_TYPE");
        Map<String, String> regionUDCMap = this.rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        ScpsmanInfoDO scpsmanInfoDO = (ScpsmanInfoDO)((Object)ScpsmanInfoDOOptional.get());
        ApiResult detailByCode = this.employeeRpcService.getDetailByCode(scpsmanInfoDO.getScpsmanNo());
        if (!detailByCode.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5458\u5de5\u8be6\u60c5\u4fe1\u606f\u5931\u8d25\uff01" + detailByCode.getMsg());
        }
        EmployeeDetailInfoRespVO employeeDetailInfoRespVO = SalesmanInfoConvert.INSTANCE.SysEmployeeDetailDTOToRespVO((SysEmployeeDetailDTO)detailByCode.getData());
        SalesmanInfoDetailRespVO salesmanInfoDetailRespVO = SalesmanInfoConvert.INSTANCE.salesmanInfoDOToDetailRespVO(scpsmanInfoDO);
        Map<Long, List<SalesmanRegionVO>> salesmanRegionMap = this.getSalesmanRegionMap(regionUDCMap, List.of(scpsmanInfoDO.getId()));
        salesmanInfoDetailRespVO.setEnableStatusName(salesmanInfoDetailRespVO.getEnableStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
        salesmanInfoDetailRespVO.setScpsmanTypeName(salesmanTypeUDCMap.get(salesmanInfoDetailRespVO.getScpsmanType()));
        salesmanInfoDetailRespVO.setJurisdiction(salesmanRegionMap.get(scpsmanInfoDO.getId()));
        salesmanInfoDetailRespVO.setEmployeeDetailInfoRespVO(employeeDetailInfoRespVO);
        return ApiResult.ok((Object)salesmanInfoDetailRespVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> changeStatus(SalesmanInfoChangeVO salesmanInfoChangeVO) {
        ApiResult result;
        log.info("\u8ba1\u5212\u5458\u72b6\u6001\u4fe1\u606f\u66f4\u6539\u5165\u53c2 {}", (Object)salesmanInfoChangeVO);
        Optional ScpsmanInfoDO2 = this.scpsmanInfoRepo.findById(salesmanInfoChangeVO.getId());
        if (ScpsmanInfoDO2.isEmpty()) {
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u4fe1\u606f");
        }
        if (salesmanInfoChangeVO.isSync() && !(result = this.employeeRpcService.updateEnabledByCode(salesmanInfoChangeVO.getCode(), Boolean.valueOf(salesmanInfoChangeVO.getEnableStatus() == 1))).isSuccess()) {
            throw new BusinessException("\u66f4\u65b0\u5458\u5de5\u72b6\u6001\u5931\u8d25\uff01" + result.getMsg());
        }
        this.scpsmanInfoRepoProc.changeEnableStatus(salesmanInfoChangeVO.getId(), salesmanInfoChangeVO.getEnableStatus());
        return ApiResult.ok();
    }

    @Override
    public ScpsmanImportRespVO salesmanImport(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        log.info("\u8ba1\u5212\u5458\u5bfc\u5165\u6570\u636e\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr(recommendRelateCustVOS));
        ScpsmanImportRespVO respVO = new ScpsmanImportRespVO();
        HashMap<String, String> errorInfoMap = new HashMap<String, String>();
        List<String> list = recommendRelateCustVOS.stream().map(SalesmanImportSaveVO::getScpsmanNo).collect(Collectors.toList());
        if (CollUtil.isEmpty(recommendRelateCustVOS)) {
            throw new BusinessException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        StringBuffer failMsg = new StringBuffer();
        boolean failFlag = false;
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-suplan", "SCPSMAN_TYPE");
        Map<String, String> newTypeMap = salesmanTypeUDCMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map<String, String> regionUDCMap = this.rmiSysUDCService.getCodeMap("yst-supp", "REGION");
        Map<String, String> newRegionMap = regionUDCMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map<String, List<ScpsmanInfoDO>> salesmanMap = this.getSalesMap(list);
        Map<String, List<ScpsmanInfoDO>> loginMap = this.getLoginMap(recommendRelateCustVOS);
        Map<String, List<SysOrgBasicDTO>> buMap = this.getBuMap(recommendRelateCustVOS);
        Map<String, List<OrgOuRpcDTO>> ouMap = this.getOuMap(recommendRelateCustVOS);
        Map<String, Long> userCodeIdMap = this.getLeaderMap(recommendRelateCustVOS);
        ArrayList<String> areaNameList = new ArrayList();
        Map<Object, Object> areaMap = new HashMap();
        ApiResult areaList = this.sysAreaRpcService.queryList(new SysAreaQueryDTO());
        if (!areaList.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7701\u5e02\u533a\u4fe1\u606f\u5931\u8d25\uff01" + areaList.getMsg());
        }
        List areaListData = (List)areaList.getData();
        if (!CollUtil.isNotEmpty((Collection)areaListData)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u7701\u5e02\u533a\u4fe1\u606f\uff01");
        }
        areaNameList = areaListData.stream().map(SysAreaRespDTO::getAreaName).collect(Collectors.toList());
        areaMap = areaListData.stream().collect(Collectors.groupingBy(SysAreaRespDTO::getAreaName));
        failFlag = ScpsmanInfoServiceImpl.checkData(errorInfoMap, failFlag, recommendRelateCustVOS, failMsg, salesmanMap, loginMap, buMap, userCodeIdMap, ouMap, newTypeMap, newRegionMap, areaNameList);
        failFlag = this.checkEmployee(errorInfoMap, recommendRelateCustVOS, failMsg, failFlag, buMap);
        List filterdRecommendRelateCustVOS = recommendRelateCustVOS.stream().filter(e -> !errorInfoMap.containsKey(e.getScpsmanNo())).collect(Collectors.toList());
        log.info("\u8fc7\u6ee4\u540e\u7684\u6570\u636e\u884c:{},\u6570\u636e\u5927\u5c0f:{}", (Object)JSONUtil.toJsonStr(filterdRecommendRelateCustVOS), (Object)filterdRecommendRelateCustVOS.size());
        if (CollUtil.isEmpty(filterdRecommendRelateCustVOS)) {
            log.info("\u8fc7\u6ee4\u540e\u65e0\u6570\u636e\u9700\u8981\u5904\u7406,\u8fd4\u56de");
            respVO.setErrorInfoMap(errorInfoMap);
            return respVO;
        }
        this.transactionTemplate.setPropagationBehavior(3);
        Map<Object, Object> finalAreaMap = areaMap;
        for (SalesmanImportSaveVO recommendRelateCustVO : filterdRecommendRelateCustVOS) {
            this.transactionTemplate.execute(transactionStatus -> {
                try {
                    String pattern;
                    ScpsmanInfoDO ScpsmanInfoDO2 = SalesmanInfoConvert.INSTANCE.salesmanImportSaveToDO(recommendRelateCustVO);
                    ScpsmanInfoDO2.setEnableStatus(1);
                    ScpsmanInfoDO2.setScpsmanType((String)newTypeMap.get(ScpsmanInfoDO2.getScpsmanType()));
                    ScpsmanInfoDO2.setOuName(((OrgOuRpcDTO)((List)ouMap.get(ScpsmanInfoDO2.getOuCode())).get(0)).getOuName());
                    List<Object> regions = new ArrayList();
                    if (StringUtils.isNotBlank((CharSequence)ScpsmanInfoDO2.getJurisdiction())) {
                        String[] jurisdictions = ScpsmanInfoDO2.getJurisdiction().split("[;\uff1b]");
                        regions = List.of(jurisdictions);
                    }
                    EmployeeUpsertDTO upsertDTO = SalesmanInfoConvert.INSTANCE.salesmanImportSaveVOToUpsertDTO(recommendRelateCustVO);
                    if (recommendRelateCustVO.getSex() != null) {
                        upsertDTO.setGender(recommendRelateCustVO.getSex().equals("1") ? "MALE" : "FEMALE");
                    }
                    AreaVO areaVO = new AreaVO();
                    ArrayList patterns = Lists.newArrayList((Object[])new String[]{"yyyy-MM-dd", "yyyy-M-d", "yyyy/MM/dd", "yyyy/M/d"});
                    if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getBirthdayTimeStr())) {
                        pattern = this.isValid(recommendRelateCustVO.getBirthdayTimeStr(), patterns);
                        if (StringUtils.isBlank((CharSequence)pattern)) {
                            throw new BusinessException("\u51fa\u751f\u65e5\u671f\u8bf7\u6309\u7167\u6307\u5b9a\u7684\u65e5\u671f\u683c\u5f0f");
                        }
                        upsertDTO.setBirthDate(this.constant.stringToLocalDatePattern(recommendRelateCustVO.getBirthdayTimeStr(), pattern));
                    }
                    if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getJoinTimeStr())) {
                        pattern = this.isValid(recommendRelateCustVO.getJoinTimeStr(), patterns);
                        if (StringUtils.isBlank((CharSequence)pattern)) {
                            throw new BusinessException("\u5165\u804c\u65e5\u671f\u8bf7\u6309\u7167\u6307\u5b9a\u7684\u65e5\u671f\u683c\u5f0f");
                        }
                        upsertDTO.setJoinTime(this.constant.parseLocalDate(recommendRelateCustVO.getJoinTimeStr(), pattern));
                    }
                    areaVO.setProvinceName(recommendRelateCustVO.getProvince());
                    areaVO.setCityName(recommendRelateCustVO.getCity());
                    areaVO.setCountyName(recommendRelateCustVO.getArea());
                    if (CollUtil.isNotEmpty((Collection)((Collection)finalAreaMap.get(recommendRelateCustVO.getProvince())))) {
                        areaVO.setProvinceCode(((SysAreaRespDTO)((List)finalAreaMap.get(recommendRelateCustVO.getProvince())).get(0)).getAreaCode());
                    }
                    if (CollUtil.isNotEmpty((Collection)((Collection)finalAreaMap.get(recommendRelateCustVO.getCity())))) {
                        areaVO.setCityCode(((SysAreaRespDTO)((List)finalAreaMap.get(recommendRelateCustVO.getCity())).get(0)).getAreaCode());
                    }
                    if (CollUtil.isNotEmpty((Collection)((Collection)finalAreaMap.get(recommendRelateCustVO.getArea())))) {
                        areaVO.setCountyCode(((SysAreaRespDTO)((List)finalAreaMap.get(recommendRelateCustVO.getArea())).get(0)).getAreaCode());
                    }
                    upsertDTO.setAreaVO(areaVO);
                    EmployeeUpsertDTO.EmployeeOrg employeeOrg = new EmployeeUpsertDTO.EmployeeOrg();
                    if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getLeaderUserCode())) {
                        employeeOrg.setLeaderUserId((Long)userCodeIdMap.get(recommendRelateCustVO.getLeaderUserCode()));
                    }
                    if (CollUtil.isNotEmpty((Collection)((Collection)buMap.get(recommendRelateCustVO.getBuCode())))) {
                        employeeOrg.setOrgId(((SysOrgBasicDTO)((List)buMap.get(recommendRelateCustVO.getBuCode())).get(0)).getId());
                    }
                    upsertDTO.setOrgList(List.of(employeeOrg));
                    upsertDTO.setCode(recommendRelateCustVO.getScpsmanNo());
                    ScpsmanInfoDO save = (ScpsmanInfoDO)((Object)((Object)this.scpsmanInfoRepo.save((Object)ScpsmanInfoDO2)));
                    if (Optional.ofNullable(save).isEmpty()) {
                        throw new BusinessException("\u8c03\u7528\u8ba1\u5212\u5458\u4fdd\u5b58\u63a5\u53e3\u5931\u8d25\uff01");
                    }
                    this.appendUserTypeToEmployeeUpsertDTO(upsertDTO, String.valueOf(save.getId()));
                    ApiResult result = this.employeeRpcService.upsert(upsertDTO);
                    if (!result.isSuccess()) {
                        throw new BusinessException("\u8c03\u7528\u521b\u5efa\u65b0\u5458\u5de5\u63a5\u53e3\u5931\u8d25\uff01 " + result.getMsg());
                    }
                    ArrayList<ScpsmanRegionDO> regionDOS = new ArrayList<ScpsmanRegionDO>();
                    if (CollUtil.isNotEmpty(regions)) {
                        for (String string : regions) {
                            ScpsmanRegionDO ScpsmanRegionDO2 = new ScpsmanRegionDO();
                            ScpsmanRegionDO2.setRegionCode((String)newRegionMap.get(string));
                            ScpsmanRegionDO2.setMasId(save.getId());
                            regionDOS.add(ScpsmanRegionDO2);
                        }
                        this.salesmanRegionRepo.saveAll(regionDOS);
                    }
                }
                catch (BusinessException e) {
                    log.error("\u8ba1\u5212\u5458\u5bfc\u5165\u62a5\u9519\uff1a" + e);
                    this.putFailMsg(errorInfoMap, recommendRelateCustVO.getScpsmanNo(), e.getMessage());
                    transactionStatus.setRollbackOnly();
                }
                return null;
            });
        }
        respVO.setErrorInfoMap(errorInfoMap);
        return respVO;
    }

    @Override
    public SalesmanLevelInfoDTO queryLevelInfo(Long id) {
        if (id == null) {
            throw new BusinessException("id \u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
        }
        SalesmanLevelInfoDTO salesmanLevelInfoDTO = new SalesmanLevelInfoDTO();
        ArrayList<SalesmanLevelInfoDTO.path> paths = new ArrayList<SalesmanLevelInfoDTO.path>();
        StringBuffer codeBuffer = new StringBuffer();
        ScpsmanInfoDO infoDO = (ScpsmanInfoDO)((Object)this.scpsmanInfoRepoProc.get(id));
        if (Optional.ofNullable(infoDO).isEmpty()) {
            throw new BusinessException(" \u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u5458\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        SalesmanLevelInfoDTO.path path2 = new SalesmanLevelInfoDTO.path();
        salesmanLevelInfoDTO.setId(infoDO.getId());
        salesmanLevelInfoDTO.setScpsmanNo(infoDO.getScpsmanNo());
        ApiResult salesmanDetailInfo = this.employeeRpcService.getDetailByCode(infoDO.getScpsmanNo());
        SysEmployeeDetailDTO salesmanDetailInfoData = (SysEmployeeDetailDTO)salesmanDetailInfo.getData();
        if (!salesmanDetailInfo.isSuccess() || Optional.ofNullable(salesmanDetailInfoData).isEmpty()) {
            return salesmanLevelInfoDTO;
        }
        path2.setLevel(Integer.valueOf(0));
        path2.setCode(infoDO.getScpsmanNo());
        path2.setType(infoDO.getScpsmanType());
        path2.setName(salesmanDetailInfoData.getFullName());
        codeBuffer.append(infoDO.getScpsmanNo());
        paths.add(path2);
        salesmanLevelInfoDTO.setSalesmanPathCode(codeBuffer.toString());
        salesmanLevelInfoDTO.setSalesman_path(paths);
        salesmanLevelInfoDTO.setId(infoDO.getId());
        salesmanLevelInfoDTO.setScpsmanNo(salesmanDetailInfoData.getCode());
        salesmanLevelInfoDTO.setSalesmanName(salesmanDetailInfoData.getFullName());
        salesmanLevelInfoDTO.setSalesmanId(salesmanDetailInfoData.getId());
        String reCode = "";
        if (CollUtil.isNotEmpty((Collection)salesmanDetailInfoData.getOrgList()) && StringUtils.isNotBlank((CharSequence)((SysEmployeeDetailDTO.EmployeeOrg)salesmanDetailInfoData.getOrgList().get(0)).getLeaderEmployeeCode())) {
            reCode = ((SysEmployeeDetailDTO.EmployeeOrg)salesmanDetailInfoData.getOrgList().get(0)).getLeaderEmployeeCode();
            Long reCId = ((SysEmployeeDetailDTO.EmployeeOrg)salesmanDetailInfoData.getOrgList().get(0)).getLeaderEmployeeId();
            String leaderUserFullName = ((SysEmployeeDetailDTO.EmployeeOrg)salesmanDetailInfoData.getOrgList().get(0)).getLeaderUserFullName();
            salesmanLevelInfoDTO.setSalesmanPathCode(this.buildPath(reCode, 1, paths, codeBuffer, leaderUserFullName));
            salesmanLevelInfoDTO.setSalesman_path(paths);
            salesmanLevelInfoDTO.setRemanageId(reCId);
            salesmanLevelInfoDTO.setRemanageNo(reCode);
            salesmanLevelInfoDTO.setRemanagerName(leaderUserFullName);
        }
        if (StringUtils.isBlank((CharSequence)reCode)) {
            return salesmanLevelInfoDTO;
        }
        ApiResult remanagerDetailInfo = this.employeeRpcService.getDetailByCode(reCode);
        SysEmployeeDetailDTO remanagerDetailInfoData = (SysEmployeeDetailDTO)remanagerDetailInfo.getData();
        if (!remanagerDetailInfo.isSuccess() || Optional.ofNullable(remanagerDetailInfoData).isEmpty() || StringUtils.isBlank((CharSequence)((SysEmployeeDetailDTO.EmployeeOrg)remanagerDetailInfoData.getOrgList().get(0)).getLeaderEmployeeCode())) {
            return salesmanLevelInfoDTO;
        }
        String prCode = ((SysEmployeeDetailDTO.EmployeeOrg)remanagerDetailInfoData.getOrgList().get(0)).getLeaderEmployeeCode();
        Long prId = ((SysEmployeeDetailDTO.EmployeeOrg)remanagerDetailInfoData.getOrgList().get(0)).getLeaderEmployeeId();
        String leaderUserFullName = ((SysEmployeeDetailDTO.EmployeeOrg)remanagerDetailInfoData.getOrgList().get(0)).getLeaderUserFullName();
        salesmanLevelInfoDTO.setSalesmanPathCode(this.buildPath(prCode, 2, paths, codeBuffer, leaderUserFullName));
        salesmanLevelInfoDTO.setSalesman_path(paths);
        salesmanLevelInfoDTO.setPrmanagerNo(prCode);
        salesmanLevelInfoDTO.setPrmanagerId(prId);
        salesmanLevelInfoDTO.setPrmanagerName(leaderUserFullName);
        if (StringUtils.isBlank((CharSequence)prCode)) {
            return salesmanLevelInfoDTO;
        }
        ApiResult prmanagerDetailInfo = this.employeeRpcService.getDetailByCode(prCode);
        SysEmployeeDetailDTO prmanagerDetailInfoData = (SysEmployeeDetailDTO)prmanagerDetailInfo.getData();
        if (!prmanagerDetailInfo.isSuccess() || Optional.ofNullable(prmanagerDetailInfoData).isEmpty() || StringUtils.isBlank((CharSequence)((SysEmployeeDetailDTO.EmployeeOrg)prmanagerDetailInfoData.getOrgList().get(0)).getLeaderEmployeeCode())) {
            return salesmanLevelInfoDTO;
        }
        String chCode = ((SysEmployeeDetailDTO.EmployeeOrg)prmanagerDetailInfoData.getOrgList().get(0)).getLeaderEmployeeCode();
        Long chId = ((SysEmployeeDetailDTO.EmployeeOrg)prmanagerDetailInfoData.getOrgList().get(0)).getLeaderEmployeeId();
        String leaderUserFullNameEnd = ((SysEmployeeDetailDTO.EmployeeOrg)prmanagerDetailInfoData.getOrgList().get(0)).getLeaderUserFullName();
        salesmanLevelInfoDTO.setSalesmanPathCode(this.buildPath(chCode, 3, paths, codeBuffer, leaderUserFullNameEnd));
        salesmanLevelInfoDTO.setSalesman_path(paths);
        salesmanLevelInfoDTO.setChiefNo(chCode);
        salesmanLevelInfoDTO.setChiefId(chId);
        salesmanLevelInfoDTO.setChiefName(leaderUserFullNameEnd);
        salesmanLevelInfoDTO.setSalesman_path(paths);
        return salesmanLevelInfoDTO;
    }

    @Override
    public ApiResult<PagingVO<SalesmanDetailInfoRespVO>> querySalesmanAllInfo(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        log.info("\u4e1a\u52a1\u5458\u5168\u90e8\u4fe1\u606f\u67e5\u8be2\u5165\u53c2 {}", (Object)salesmanInfoQueryVO);
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-suplan", "SCPSMAN_TYPE");
        Map<String, String> regionUDCMap = this.rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        ArrayList<Object> salesmanDetailInfoRespVOS = new ArrayList<Object>();
        if (salesmanInfoQueryVO.getEnableStatus() != null || StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getOuCode()) || StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getScpsmanType()) || salesmanInfoQueryVO.getNoQueryParam() == 1) {
            Set detailCodeSet;
            ApiResult apiResult;
            JPAQuery<SalesmanDetailInfoRespVO> jpaQuery = this.scpsmanInfoRepoProc.findSalesmanInfoDetail(salesmanInfoQueryVO);
            List salesmanInfoRespVOList = jpaQuery.fetch();
            if (CollUtil.isEmpty((Collection)salesmanInfoRespVOList)) {
                return ApiResult.ok();
            }
            Map<String, String> regionMap = this.buildReion(regionUDCMap, salesmanInfoRespVOList);
            Map salesmanMap = salesmanInfoRespVOList.stream().collect(Collectors.toMap(SalesmanDetailInfoRespVO::getScpsmanNo, Function.identity(), (k1, k2) -> k1));
            Set codeList = salesmanInfoRespVOList.stream().map(SalesmanDetailInfoRespVO::getScpsmanNo).collect(Collectors.toSet());
            EmployeePageQueryDTO employeePageQueryDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoQueryVOToQueryDTO(salesmanInfoQueryVO);
            employeePageQueryDTO.setKeyword(salesmanInfoQueryVO.getScpsman());
            employeePageQueryDTO.setCodes(codeList);
            ApiResult result = this.employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!result.isSuccess()) {
                throw new BusinessException("\u5458\u5de5\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01" + result.getMsg());
            }
            List employeePageRespDTOList = new ArrayList();
            if (Optional.ofNullable((PagingVO)result.getData()).isPresent()) {
                employeePageRespDTOList = ((PagingVO)result.getData()).getRecords();
            }
            if (CollUtil.isEmpty(employeePageRespDTOList)) {
                ApiResult.ok((Object)PagingVO.builder().records(salesmanDetailInfoRespVOS));
            }
            if (!(apiResult = this.employeeRpcService.getDetailListByCode(detailCodeSet = employeePageRespDTOList.stream().map(EmployeePageRespDTO::getCode).collect(Collectors.toSet()))).isSuccess()) {
                throw new BusinessException("\u5458\u5de5\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01" + apiResult.getMsg());
            }
            List detailDTOS = (List)apiResult.getData();
            if (CollUtil.isEmpty((Collection)detailDTOS)) {
                return ApiResult.ok();
            }
            for (SysEmployeeDetailDTO detailDTO : detailDTOS) {
                SalesmanDetailInfoRespVO salesmanDetailInfoRespVO = new SalesmanDetailInfoRespVO();
                if (Optional.ofNullable((SalesmanDetailInfoRespVO)salesmanMap.get(detailDTO.getCode())).isPresent()) {
                    salesmanDetailInfoRespVO.setOuName(((SalesmanDetailInfoRespVO)salesmanMap.get(detailDTO.getCode())).getOuName());
                    salesmanDetailInfoRespVO.setId(((SalesmanDetailInfoRespVO)salesmanMap.get(detailDTO.getCode())).getId());
                    salesmanDetailInfoRespVO.setScpsmanNo(((SalesmanDetailInfoRespVO)salesmanMap.get(detailDTO.getCode())).getScpsmanNo());
                    salesmanDetailInfoRespVO.setScpsmanType(salesmanTypeUDCMap.get(((SalesmanDetailInfoRespVO)salesmanMap.get(detailDTO.getCode())).getScpsmanType()));
                    salesmanDetailInfoRespVO.setEnableStatusName(((SalesmanDetailInfoRespVO)salesmanMap.get(detailDTO.getCode())).getEnableStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
                }
                salesmanDetailInfoRespVO.setJurisdiction(regionMap.get(detailDTO.getCode()));
                salesmanDetailInfoRespVO.setJoinTime(detailDTO.getJoinTime());
                if (ObjectUtils.isNotEmpty((Object)detailDTO.getJoinTime())) {
                    salesmanDetailInfoRespVO.setJoinTimeLocalDate(detailDTO.getJoinTime().toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                }
                salesmanDetailInfoRespVO.setUsername(detailDTO.getUsername());
                salesmanDetailInfoRespVO.setFullName(detailDTO.getFullName());
                salesmanDetailInfoRespVO.setGenderName(detailDTO.getGenderName());
                salesmanDetailInfoRespVO.setEmail(detailDTO.getEmail());
                salesmanDetailInfoRespVO.setPhone(detailDTO.getPhone());
                salesmanDetailInfoRespVO.setBirthDate(detailDTO.getBirthDate() == null ? null : detailDTO.getBirthDate().format(DateTimeFormatter.ISO_LOCAL_DATE));
                salesmanDetailInfoRespVO.setIdCard(detailDTO.getIdCard());
                salesmanDetailInfoRespVO.setProvinceName(detailDTO.getAreaVO().getProvinceName());
                salesmanDetailInfoRespVO.setCityName(detailDTO.getAreaVO().getCityName());
                salesmanDetailInfoRespVO.setCountyName(detailDTO.getAreaVO().getCountyName());
                salesmanDetailInfoRespVO.setAddress(detailDTO.getAddress());
                if (CollUtil.isNotEmpty((Collection)detailDTO.getOrgList())) {
                    salesmanDetailInfoRespVO.setOrgName(((SysEmployeeDetailDTO.EmployeeOrg)detailDTO.getOrgList().get(0)).getOrgName());
                    salesmanDetailInfoRespVO.setLeaderUserFullName(((SysEmployeeDetailDTO.EmployeeOrg)detailDTO.getOrgList().get(0)).getLeaderUserFullName());
                }
                salesmanDetailInfoRespVOS.add(salesmanDetailInfoRespVO);
            }
            log.info("\u8ba1\u5212\u5458\u5bfc\u51fa\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr(salesmanDetailInfoRespVOS));
            return ApiResult.ok((Object)PagingVO.builder().records(salesmanDetailInfoRespVOS).total((long)salesmanDetailInfoRespVOS.size()).build());
        }
        if (salesmanInfoQueryVO.getNoQueryParam() != 1) {
            EmployeePageQueryDTO employeePageQueryDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoQueryVOToQueryDTO(salesmanInfoQueryVO);
            employeePageQueryDTO.setKeyword(salesmanInfoQueryVO.getScpsman());
            ApiResult result = this.employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!result.isSuccess()) {
                throw new BusinessException("\u5458\u5de5\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01" + result.getMsg());
            }
            if (((PagingVO)result.getData()).getTotal() == 0L) {
                return ApiResult.ok();
            }
            List employeePageRespDTOS = ((PagingVO)result.getData()).getRecords();
            Set codeSet = employeePageRespDTOS.stream().map(EmployeePageRespDTO::getCode).collect(Collectors.toSet());
            ApiResult apiResult = this.employeeRpcService.getDetailListByCode(codeSet);
            if (!apiResult.isSuccess()) {
                throw new BusinessException("\u5458\u5de5\u8be6\u60c5\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01" + apiResult.getMsg());
            }
            List employeeDetailDTOS = (List)apiResult.getData();
            if (CollUtil.isEmpty((Collection)employeeDetailDTOS)) {
                return ApiResult.ok();
            }
            List<String> codes = employeeDetailDTOS.stream().map(SysEmployeeDetailDTO::getCode).collect(Collectors.toList());
            List<ScpsmanInfoDO> salesmanInfoDOS = this.scpsmanInfoRepo.findByScpsmanNoIn(codes);
            if (CollUtil.isEmpty(salesmanInfoDOS)) {
                return ApiResult.ok();
            }
            HashMap<String, String> regionMap = new HashMap<String, String>();
            Map<Long, List<SalesmanRegionVO>> idRegionMap = this.getSalesmanRegionMap(regionUDCMap, salesmanInfoDOS.stream().map(BaseModel::getId).collect(Collectors.toList()));
            for (ScpsmanInfoDO salesmanInfoDO : salesmanInfoDOS) {
                StringBuffer stringBuffer = new StringBuffer();
                if (!CollUtil.isNotEmpty((Collection)idRegionMap.get(salesmanInfoDO.getId()))) continue;
                for (SalesmanRegionVO regionVO : idRegionMap.get(salesmanInfoDO.getId())) {
                    if (!StringUtils.isNotBlank((CharSequence)regionVO.getRegionName())) continue;
                    stringBuffer = stringBuffer.append(regionVO.getRegionName() + " ");
                }
                regionMap.put(salesmanInfoDO.getScpsmanNo(), stringBuffer.toString());
            }
            Map salesmanInfoDOMap = salesmanInfoDOS.stream().collect(Collectors.toMap(ScpsmanInfoDO::getScpsmanNo, Function.identity(), (k1, k2) -> k1));
            for (SysEmployeeDetailDTO detailDTO : employeeDetailDTOS) {
                SalesmanDetailInfoRespVO salesmanDetailInfoRespVO = new SalesmanDetailInfoRespVO();
                if (Optional.ofNullable((ScpsmanInfoDO)((Object)salesmanInfoDOMap.get(detailDTO.getCode()))).isPresent()) {
                    salesmanDetailInfoRespVO.setId(((ScpsmanInfoDO)((Object)salesmanInfoDOMap.get(detailDTO.getCode()))).getId());
                    salesmanDetailInfoRespVO.setOuName(((ScpsmanInfoDO)((Object)salesmanInfoDOMap.get(detailDTO.getCode()))).getOuName());
                    salesmanDetailInfoRespVO.setScpsmanNo(((ScpsmanInfoDO)((Object)salesmanInfoDOMap.get(detailDTO.getCode()))).getScpsmanNo());
                    salesmanDetailInfoRespVO.setScpsmanType(salesmanTypeUDCMap.get(((ScpsmanInfoDO)((Object)salesmanInfoDOMap.get(detailDTO.getCode()))).getScpsmanType()));
                    salesmanDetailInfoRespVO.setEnableStatusName(((ScpsmanInfoDO)((Object)salesmanInfoDOMap.get(detailDTO.getCode()))).getEnableStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
                }
                salesmanDetailInfoRespVO.setJurisdiction((String)regionMap.get(detailDTO.getCode()));
                salesmanDetailInfoRespVO.setJoinTime(detailDTO.getJoinTime());
                if (ObjectUtils.isNotEmpty((Object)detailDTO.getJoinTime())) {
                    salesmanDetailInfoRespVO.setJoinTimeLocalDate(detailDTO.getJoinTime().toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                }
                salesmanDetailInfoRespVO.setUsername(detailDTO.getUsername());
                salesmanDetailInfoRespVO.setFullName(detailDTO.getFullName());
                salesmanDetailInfoRespVO.setGenderName(detailDTO.getGenderName());
                salesmanDetailInfoRespVO.setEmail(detailDTO.getEmail());
                salesmanDetailInfoRespVO.setPhone(detailDTO.getPhone());
                salesmanDetailInfoRespVO.setBirthDate(detailDTO.getBirthDate() == null ? null : detailDTO.getBirthDate().format(DateTimeFormatter.ISO_LOCAL_DATE));
                salesmanDetailInfoRespVO.setIdCard(detailDTO.getIdCard());
                salesmanDetailInfoRespVO.setProvinceName(detailDTO.getAreaVO().getProvinceName());
                salesmanDetailInfoRespVO.setCityName(detailDTO.getAreaVO().getCityName());
                salesmanDetailInfoRespVO.setCountyName(detailDTO.getAreaVO().getCountyName());
                salesmanDetailInfoRespVO.setAddress(detailDTO.getAddress());
                if (CollUtil.isNotEmpty((Collection)detailDTO.getOrgList())) {
                    salesmanDetailInfoRespVO.setOrgName(((SysEmployeeDetailDTO.EmployeeOrg)detailDTO.getOrgList().get(0)).getOrgName());
                    salesmanDetailInfoRespVO.setLeaderUserFullName(((SysEmployeeDetailDTO.EmployeeOrg)detailDTO.getOrgList().get(0)).getLeaderUserFullName());
                }
                salesmanDetailInfoRespVOS.add(salesmanDetailInfoRespVO);
            }
            log.info("\u8ba1\u5212\u5458\u5bfc\u51fa\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr(salesmanDetailInfoRespVOS));
            return ApiResult.ok((Object)PagingVO.builder().records(salesmanDetailInfoRespVOS).total((long)salesmanDetailInfoRespVOS.size()).build());
        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<PagingVO<SalesmanInfoRespVO>> querySubordinate(SalesmanSubordinateQueryVO salesmanSubordinateQueryVO) {
        log.info("\u4e1a\u52a1\u5458\u4e0b\u7ea7\u4fe1\u606f\u67e5\u8be2\u5165\u53c2 {}", (Object)salesmanSubordinateQueryVO);
        ApiResult apiResult = this.employeeRpcService.getUnderlingByCode(salesmanSubordinateQueryVO.getCode(), Boolean.valueOf(true), null);
        if (!apiResult.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5458\u5de5\u4e0b\u7ea7\u4fe1\u606f\u5931\u8d25\uff01" + apiResult.getMsg());
        }
        List resultData = (List)apiResult.getData();
        ArrayList<String> codeList = new ArrayList<String>();
        if (CollUtil.isEmpty((Collection)resultData)) {
            return ApiResult.ok();
        }
        codeList.addAll(resultData.stream().map(EmployeeUnderlingDTO::getCode).collect(Collectors.toList()));
        List<EmployeeInfoRespVO> employeeInfoRespVOS = SalesmanInfoConvert.INSTANCE.employeeUnderlingDTOToRespVO(resultData);
        Map employeeInfoRespVOMap = employeeInfoRespVOS.stream().collect(Collectors.toMap(EmployeeInfoRespVO::getCode, Function.identity(), (k1, k2) -> k1));
        JPAQuery<SalesmanInfoRespVO> jpaQuery = this.scpsmanInfoRepoProc.findByRelateCode(codeList, salesmanSubordinateQueryVO);
        List salesmanInfoRespVOS = jpaQuery.fetch();
        if (CollUtil.isEmpty((Collection)salesmanInfoRespVOS)) {
            return ApiResult.ok();
        }
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-suplan", "SCPSMAN_TYPE");
        Map<String, String> regionUDCMap = this.rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        Map<Long, List<SalesmanRegionVO>> salesmanRegionMap = this.getSalesmanRegionMap(regionUDCMap, salesmanInfoRespVOS.stream().map(SalesmanInfoRespVO::getId).collect(Collectors.toList()));
        Iterator iterator = salesmanInfoRespVOS.iterator();
        while (iterator.hasNext()) {
            SalesmanInfoRespVO salesmanInfoRespVO;
            salesmanInfoRespVO.setEnableStatusName((salesmanInfoRespVO = (SalesmanInfoRespVO)iterator.next()).getEnableStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
            salesmanInfoRespVO.setScpsmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRespVO.getScpsmanType()));
            salesmanInfoRespVO.setJurisdiction(salesmanRegionMap.get(salesmanInfoRespVO.getId()));
            salesmanInfoRespVO.setEmployeeInfoRespVO((EmployeeInfoRespVO)employeeInfoRespVOMap.get(salesmanInfoRespVO.getScpsmanNo()));
            if (!CollUtil.isNotEmpty(salesmanInfoRespVO.getEmployeeInfoRespVO().getUnderlingList())) continue;
            salesmanInfoRespVO.setHasUnder(true);
        }
        return ApiResult.ok((Object)PagingVO.builder().total(jpaQuery.fetchCount()).records(salesmanInfoRespVOS).build());
    }

    @Override
    @Transactional
    public void autoManInfo() {
        List<String> codes = this.rmiOrgStoreRpcService.queryAllStoreCodes();
        List<OrgStoreDetailRpcDTO> storeData = this.rmiOrgStoreRpcService.queryByStoreCodes(codes);
        Map<Long, OrgStoreDetailRpcDTO> storeMap = storeData.stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getId, t -> t));
        SysSettingVO sysSettingVO = this.settingService.oneByNo("BELONG_OU");
        if (sysSettingVO == null) {
            throw new BusinessException("\u8bf7\u68c0\u67e5\u9ed8\u8ba4\u6240\u5c5e\u516c\u53f8\u914d\u7f6e");
        }
        String ouCodes = sysSettingVO.getSettingVal();
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuCodes(Collections.singletonList(ouCodes));
        List ouDtoByParam = this.orgOuRpcService.findOuDtoByParam(orgOuRpcDtoParam);
        OrgOuRpcDTO orgOuRpcDTO = (OrgOuRpcDTO)ouDtoByParam.get(0);
        ArrayList contract = new ArrayList();
        storeData.forEach(vo -> contract.addAll(vo.getOrgContactRpcDTOS().stream().filter(vod -> !StringUtils.isEmpty((CharSequence)vod.getMobile())).collect(Collectors.toList())));
        Map<String, List<OrgContactRpcDTO>> contacts = contract.stream().collect(Collectors.groupingBy(OrgContactRpcDTO::getMobile));
        for (String key : contacts.keySet()) {
            SysUserBasicDTO data = (SysUserBasicDTO)this.userRpcService.getByUsername(key).getData();
            if (data == null) continue;
            SysEmployeeBasicDTO empData = (SysEmployeeBasicDTO)this.employeeRpcService.getByUserId(data.getId()).getData();
            ScpsmanInfoDO bySalesmanNo = this.scpsmanInfoRepo.findByScpsmanNo(empData.getCode());
            SalesmanInfoSaveVO salesmanInfoSaveVO = new SalesmanInfoSaveVO();
            if (bySalesmanNo != null) {
                salesmanInfoSaveVO.setId(bySalesmanNo.getId());
            }
            salesmanInfoSaveVO.setEmail(empData.getEmail());
            salesmanInfoSaveVO.setName(empData.getLastName());
            salesmanInfoSaveVO.setLoginAccount(key);
            salesmanInfoSaveVO.setPhone(key);
            salesmanInfoSaveVO.setScpsmanNo(empData.getCode());
            salesmanInfoSaveVO.setSource("EMP");
            salesmanInfoSaveVO.setBuId(empData.getOrgId());
            ScpsmanInfoDO scpsmanInfoDO = SalesmanInfoConvert.INSTANCE.salesmanInfoSaveToDO(salesmanInfoSaveVO);
            scpsmanInfoDO.setEnableStatus(1);
            scpsmanInfoDO.setOuId(orgOuRpcDTO.getId());
            scpsmanInfoDO.setOuCode(orgOuRpcDTO.getOuCode());
            scpsmanInfoDO.setOuName(orgOuRpcDTO.getOuName());
            ScpsmanInfoDO save = (ScpsmanInfoDO)((Object)this.scpsmanInfoRepo.save((Object)scpsmanInfoDO));
            ArrayList scpsmanRegionDOS = new ArrayList();
            this.salesmanRegionRepo.deleteByMasId(save.getId());
            if (CollUtil.isNotEmpty((Collection)contacts.get(key))) {
                contacts.get(key).forEach(vo -> {
                    ScpsmanRegionDO scpsmanRegionDO = new ScpsmanRegionDO();
                    scpsmanRegionDO.setRegionCode(((OrgStoreDetailRpcDTO)storeMap.get(vo.getMasId())).getRegion());
                    scpsmanRegionDO.setMasId(save.getId());
                    scpsmanRegionDOS.add(scpsmanRegionDO);
                });
                this.salesmanRegionRepo.saveAll(scpsmanRegionDOS);
            }
            ScpsmanAuthorityDO byScpsmanId = this.scpDemandAuthorityRepo.findByScpsmanId(save.getId());
            ScpsmanAuthorityDO scpManAuthoritySaveVO = new ScpsmanAuthorityDO();
            if (byScpsmanId != null) {
                scpManAuthoritySaveVO.setId(byScpsmanId.getId());
            }
            scpManAuthoritySaveVO.setOuCode(orgOuRpcDTO.getOuCode());
            scpManAuthoritySaveVO.setOuName(orgOuRpcDTO.getOuName());
            scpManAuthoritySaveVO.setOuId(orgOuRpcDTO.getId());
            scpManAuthoritySaveVO.setScpsmanNo(save.getScpsmanNo());
            scpManAuthoritySaveVO.setEnableStatus(true);
            scpManAuthoritySaveVO.setScpsmanId(save.getId());
            ScpsmanAuthorityDO save1 = (ScpsmanAuthorityDO)this.scpDemandAuthorityRepo.save(scpManAuthoritySaveVO);
            this.scpDemandAuthorityDService.deleteByIds(Arrays.asList(save1.getId()));
            List ddos = contacts.get(key).stream().map(vo -> {
                ScpsmanAuthorityDDO scpsmanAuthorityDDO = new ScpsmanAuthorityDDO();
                scpsmanAuthorityDDO.setAuthSource(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                scpsmanAuthorityDDO.setMasId(save1.getId());
                scpsmanAuthorityDDO.setType(0);
                scpsmanAuthorityDDO.setRegion(((OrgStoreDetailRpcDTO)storeMap.get(vo.getMasId())).getRegion());
                scpsmanAuthorityDDO.setStWhId(((OrgStoreDetailRpcDTO)storeMap.get(vo.getMasId())).getId());
                scpsmanAuthorityDDO.setStWhCode(((OrgStoreDetailRpcDTO)storeMap.get(vo.getMasId())).getStoreCode());
                scpsmanAuthorityDDO.setStWhName(((OrgStoreDetailRpcDTO)storeMap.get(vo.getMasId())).getStoreName());
                return scpsmanAuthorityDDO;
            }).collect(Collectors.toList());
            this.scpDemandAuthorityDRepo.saveAll(ddos);
        }
    }

    private Map<String, String> buildReion(Map<String, String> regionUDCMap, List<SalesmanDetailInfoRespVO> salesmanInfoRespVOList) {
        HashMap<String, String> regionMap = new HashMap<String, String>();
        Map<Long, List<SalesmanRegionVO>> idRegionMap = this.getSalesmanRegionMap(regionUDCMap, salesmanInfoRespVOList.stream().map(SalesmanDetailInfoRespVO::getId).collect(Collectors.toList()));
        for (SalesmanDetailInfoRespVO salesmanDetailInfoRespVO : salesmanInfoRespVOList) {
            StringBuffer stringBuffer = new StringBuffer();
            if (!CollUtil.isNotEmpty((Collection)idRegionMap.get(salesmanDetailInfoRespVO.getId()))) continue;
            for (SalesmanRegionVO regionVO : idRegionMap.get(salesmanDetailInfoRespVO.getId())) {
                if (!StringUtils.isNotBlank((CharSequence)regionVO.getRegionName())) continue;
                stringBuffer = stringBuffer.append(regionVO.getRegionName() + " ");
            }
            regionMap.put(salesmanDetailInfoRespVO.getScpsmanNo(), stringBuffer.toString());
        }
        return regionMap;
    }

    private String buildPath(String code, int level, List<SalesmanLevelInfoDTO.path> paths, StringBuffer code1, String leaderUserFullName) {
        ScpsmanInfoDO infoDO3 = this.scpsmanInfoRepo.findByScpsmanNo(code);
        if (Optional.ofNullable(infoDO3).isPresent()) {
            SalesmanLevelInfoDTO.path path1 = new SalesmanLevelInfoDTO.path();
            code1.append(",");
            code1.append(infoDO3.getScpsmanNo());
            path1.setLevel(Integer.valueOf(level));
            path1.setCode(infoDO3.getScpsmanNo());
            path1.setType(infoDO3.getScpsmanType());
            path1.setName(leaderUserFullName);
            paths.add(path1);
            return code1.toString();
        }
        return code1.toString();
    }

    private void putFailMsg(Map<String, String> errorInfoMap, String scpsmanNo, String failMsg) {
        if (errorInfoMap.containsKey(scpsmanNo)) {
            String failMsgNew = errorInfoMap.get(scpsmanNo) + "," + failMsg;
            errorInfoMap.put(scpsmanNo, failMsgNew);
        } else {
            errorInfoMap.put(scpsmanNo, failMsg);
        }
    }

    private static Boolean checkData(Map<String, String> errorInfoMap, Boolean failFlag, List<SalesmanImportSaveVO> recommendRelateCustVOS, StringBuffer failMsg, Map<String, List<ScpsmanInfoDO>> salesmanMap, Map<String, List<ScpsmanInfoDO>> loginMap, Map<String, List<SysOrgBasicDTO>> buMap, Map<String, Long> userCodeIdMap, Map<String, List<OrgOuRpcDTO>> ouMap, Map<String, String> salesmanTypeUDCMap, Map<String, String> newRegionMap, List<String> areaNameList) {
        int i = 1;
        for (SalesmanImportSaveVO recommendRelateCustVO : recommendRelateCustVOS) {
            if (StringUtils.isBlank((CharSequence)recommendRelateCustVO.getScpsmanNo())) {
                failFlag = true;
                failMsg.append("\u4e1a\u52a1\u5458\u7f16\u53f7\u4e3a\u7a7a ");
            }
            if (StringUtils.isBlank((CharSequence)recommendRelateCustVO.getName())) {
                failFlag = true;
                failMsg.append("\u59d3\u540d\u4e3a\u7a7a ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getProvince()) && !areaNameList.contains(recommendRelateCustVO.getProvince())) {
                failFlag = true;
                failMsg.append("\u7701\u4fe1\u606f\u4e0d\u5b58\u5728 ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getCity()) && !areaNameList.contains(recommendRelateCustVO.getCity())) {
                failFlag = true;
                failMsg.append("\u5e02\u4fe1\u606f\u4e0d\u5b58\u5728 ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getArea()) && !areaNameList.contains(recommendRelateCustVO.getArea())) {
                failFlag = true;
                failMsg.append("\u533a\u4fe1\u606f\u4e0d\u5b58\u5728 ");
            }
            if (StringUtils.isBlank((CharSequence)recommendRelateCustVO.getOuCode())) {
                failFlag = true;
                failMsg.append("\u516c\u53f8\u7f16\u53f7\u4e3a\u7a7a ");
            }
            if (StringUtils.isBlank((CharSequence)recommendRelateCustVO.getBuCode())) {
                failFlag = true;
                failMsg.append("\u7ec4\u7ec7\u7f16\u53f7\u4e3a\u7a7a ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getBuCode()) && CollUtil.isEmpty((Collection)buMap.get(recommendRelateCustVO.getBuCode()))) {
                failFlag = true;
                failMsg.append("\u7ec4\u7ec7\u7f16\u53f7\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f ");
            }
            if (StringUtils.isBlank((CharSequence)recommendRelateCustVO.getLoginAccount())) {
                failFlag = true;
                failMsg.append("\u767b\u5f55\u8d26\u53f7\u4e3a\u7a7a ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getScpsmanType()) && StringUtils.isBlank((CharSequence)salesmanTypeUDCMap.get(recommendRelateCustVO.getScpsmanType()))) {
                failFlag = true;
                failMsg.append("\u4e1a\u52a1\u5458\u7c7b\u578b\u4e0d\u5b58\u5728 ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getScpsmanNo()) && CollUtil.isNotEmpty((Collection)salesmanMap.get(recommendRelateCustVO.getScpsmanNo()))) {
                failFlag = true;
                failMsg.append("\u4e1a\u52a1\u5458\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165 ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getLoginAccount()) && CollUtil.isNotEmpty((Collection)loginMap.get(recommendRelateCustVO.getLoginAccount()))) {
                failFlag = true;
                failMsg.append("\u767b\u5f55\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165 ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getBuCode()) && StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getOuCode()) && CollUtil.isNotEmpty((Collection)buMap.get(recommendRelateCustVO.getBuCode())) && CollUtil.isNotEmpty((Collection)ouMap.get(recommendRelateCustVO.getOuCode())) && ouMap.get(recommendRelateCustVO.getOuCode()).get(0).getBuId() != null && buMap.get(recommendRelateCustVO.getBuCode()).get(0).getId() != null && !ouMap.get(recommendRelateCustVO.getOuCode()).get(0).getBuId().equals(buMap.get(recommendRelateCustVO.getBuCode()).get(0).getId()) && !recommendRelateCustVO.getOuCode().equals(buMap.get(recommendRelateCustVO.getBuCode()).get(0).getParentCode())) {
                failFlag = true;
                failMsg.append("\u4fe1\u606f\u9519\u8bef\uff0c\u8be5\u516c\u53f8\u4e0e\u8be5\u7ec4\u7ec7\u6ca1\u6709\u7ed1\u5b9a\u5173\u7cfb\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165 ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getOuCode()) && CollUtil.isEmpty((Collection)ouMap.get(recommendRelateCustVO.getOuCode()))) {
                failFlag = true;
                failMsg.append("\u516c\u53f8\u7f16\u53f7\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u516c\u53f8\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165 ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getLeaderUserCode()) && userCodeIdMap.get(recommendRelateCustVO.getLeaderUserCode()) == null) {
                failFlag = true;
                failMsg.append("\u4e0a\u7ea7\u7f16\u53f7\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u4e0a\u7ea7\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165 ");
            }
            if (StrUtil.isNotBlank((CharSequence)failMsg.toString())) {
                errorInfoMap.put(recommendRelateCustVO.getScpsmanNo(), failMsg.toString());
            }
            ++i;
        }
        log.info("\u6821\u9a8c\u89e3\u6790\u6570\u636e\u540e:{}", (Object)JSONUtil.toJsonStr(errorInfoMap));
        return failFlag;
    }

    private boolean checkEmployee(Map<String, String> errorInfoMap, List<SalesmanImportSaveVO> recommendRelateCustVOS, StringBuffer failMsg, boolean failFlag, Map<String, List<SysOrgBasicDTO>> buMap) {
        ArrayList<EmployeeUpsertDTO> employeeUpsertDTOS = new ArrayList<EmployeeUpsertDTO>();
        for (SalesmanImportSaveVO recommendRelateCustVO : recommendRelateCustVOS) {
            EmployeeUpsertDTO upsertDTO = SalesmanInfoConvert.INSTANCE.salesmanImportSaveVOToUpsertDTO(recommendRelateCustVO);
            if (CollUtil.isNotEmpty((Collection)buMap.get(recommendRelateCustVO.getBuCode()))) {
                EmployeeUpsertDTO.EmployeeOrg employeeOrg = new EmployeeUpsertDTO.EmployeeOrg();
                employeeOrg.setOrgId(buMap.get(recommendRelateCustVO.getBuCode()).get(0).getId());
                upsertDTO.setOrgList(List.of(employeeOrg));
            }
            employeeUpsertDTOS.add(upsertDTO);
        }
        ApiResult apiResult = this.employeeRpcService.checkBatch(employeeUpsertDTOS);
        List data = (List)apiResult.getData();
        if (apiResult.isSuccess() && CollUtil.isNotEmpty((Collection)data)) {
            int n = 0;
            for (String datum : data) {
                if (datum.contains("IllegalArgumentException")) {
                    failFlag = true;
                    failMsg.append("\u7b2c" + n + "1\u884c\u6570\u636e" + datum + " ");
                }
                ++n;
            }
        }
        return failFlag;
    }

    public String isValid(String dateStr, List<String> patterns) {
        for (int i = 0; i < patterns.size(); ++i) {
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(patterns.get(0));
                LocalDate.parse(dateStr, dateTimeFormatter);
                return patterns.get(i);
            }
            catch (DateTimeParseException dateTimeParseException) {
                continue;
            }
        }
        return "";
    }

    private Map<String, List<SysOrgBasicDTO>> getBuMap(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        Set buCodesSet = recommendRelateCustVOS.stream().map(SalesmanImportSaveVO::getBuCode).collect(Collectors.toSet());
        SysOrgQueryDTO sysOrgQueryDTO = new SysOrgQueryDTO();
        sysOrgQueryDTO.setCodes(buCodesSet);
        ApiResult listApiResult = this.orgRpcService.queryList(sysOrgQueryDTO);
        if (!listApiResult.isSuccess()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01 " + listApiResult.getMsg());
        }
        List buList = (List)listApiResult.getData();
        Map<String, List<SysOrgBasicDTO>> buMap = new HashMap<String, List<SysOrgBasicDTO>>();
        if (CollUtil.isNotEmpty((Collection)buList)) {
            buMap = buList.stream().collect(Collectors.groupingBy(SysOrgBasicDTO::getCode));
        }
        return buMap;
    }

    private Map<String, List<ScpsmanInfoDO>> getSalesMap(List<String> list) {
        List<ScpsmanInfoDO> byMasSalesmanNoIn = this.scpsmanInfoRepo.findByScpsmanNoIn(list);
        Map<String, List<ScpsmanInfoDO>> salesmanMap = new HashMap<String, List<ScpsmanInfoDO>>();
        if (CollUtil.isNotEmpty(byMasSalesmanNoIn)) {
            salesmanMap = byMasSalesmanNoIn.stream().collect(Collectors.groupingBy(ScpsmanInfoDO::getScpsmanNo));
        }
        return salesmanMap;
    }

    private Map<String, List<ScpsmanInfoDO>> getLoginMap(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        List<String> loginAccounts = recommendRelateCustVOS.stream().map(SalesmanImportSaveVO::getLoginAccount).collect(Collectors.toList());
        List<ScpsmanInfoDO> salesmanInfoRepoByLoginAccountIn = this.scpsmanInfoRepo.findByLoginAccountIn(loginAccounts);
        Map<String, List<ScpsmanInfoDO>> loginMap = new HashMap<String, List<ScpsmanInfoDO>>();
        if (CollUtil.isNotEmpty(salesmanInfoRepoByLoginAccountIn)) {
            loginMap = salesmanInfoRepoByLoginAccountIn.stream().collect(Collectors.groupingBy(ScpsmanInfoDO::getLoginAccount));
        }
        return loginMap;
    }

    @NotNull
    private Map<String, Long> getLeaderMap(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        Set leaderCodes = recommendRelateCustVOS.stream().map(SalesmanImportSaveVO::getLeaderUserCode).filter(leaderUserCode -> leaderUserCode != null).collect(Collectors.toSet());
        Map<String, Long> userCodeIdMap = new HashMap<String, Long>();
        if (CollUtil.isNotEmpty(leaderCodes)) {
            EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
            employeePageQueryDTO.setCodes(leaderCodes);
            ApiResult apiResult = this.employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!apiResult.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u4e0a\u7ea7\u4fe1\u606f\u5931\u8d25\uff01" + apiResult.getMsg());
            }
            userCodeIdMap = ((PagingVO)apiResult.getData()).getRecords().stream().collect(Collectors.toMap(EmployeePageRespDTO::getCode, EmployeePageRespDTO::getUserId));
        }
        return userCodeIdMap;
    }

    private Map<String, List<OrgOuRpcDTO>> getOuMap(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuCodes(recommendRelateCustVOS.stream().map(SalesmanImportSaveVO::getOuCode).distinct().collect(Collectors.toList()));
        List ouDtoByParam = this.orgOuRpcService.findOuDtoByParam(orgOuRpcDtoParam);
        Map<String, List<OrgOuRpcDTO>> ouMap = new HashMap<String, List<OrgOuRpcDTO>>();
        if (CollUtil.isNotEmpty((Collection)ouDtoByParam)) {
            ouMap = ouDtoByParam.stream().collect(Collectors.groupingBy(OrgOuRpcDTO::getOuCode));
        }
        return ouMap;
    }

    public Map<Long, List<SalesmanRegionVO>> getSalesmanRegionMap(Map<String, String> regionUDCMap, List<Long> ids) {
        List<ScpsmanRegionDO> regionDOS = this.salesmanRegionRepo.findByMasIdIn(ids);
        Map<Long, List<SalesmanRegionVO>> regionMap = new HashMap<Long, List<SalesmanRegionVO>>();
        if (CollUtil.isNotEmpty(regionDOS)) {
            List<SalesmanRegionVO> salesmanRegionVOS = SalesmanInfoConvert.INSTANCE.salesmanRegionDOToVo(regionDOS);
            for (SalesmanRegionVO regionVO : salesmanRegionVOS) {
                regionVO.setRegionName(regionUDCMap.get(regionVO.getRegionCode()));
            }
            regionMap = salesmanRegionVOS.stream().collect(Collectors.groupingBy(SalesmanRegionVO::getMasId));
        }
        return regionMap;
    }

    private void buildEmployee(SalesmanInfoSaveVO salesmanInfoSaveVO, ScpsmanInfoDO scpsmanInfoDO, EmployeeUpsertDTO employeeUpsertDTO, String id) {
        Long userId;
        Long empId = salesmanInfoSaveVO.getUserId();
        if (empId != null && (userId = (Long)this.userRpcService.getIdByUsername(scpsmanInfoDO.getLoginAccount()).computeData()) != null) {
            this.userRpcService.addUserType(userId, SCPSMAN, id);
            return;
        }
        AreaVO areaVO = new AreaVO();
        areaVO.setProvinceCode(salesmanInfoSaveVO.getProvince());
        areaVO.setCityCode(salesmanInfoSaveVO.getCity());
        areaVO.setCountyCode(salesmanInfoSaveVO.getArea());
        EmployeeUpsertDTO.EmployeeOrg employeeOrg = new EmployeeUpsertDTO.EmployeeOrg();
        employeeOrg.setOrgId(salesmanInfoSaveVO.getBuId());
        employeeOrg.setLeaderUserId(salesmanInfoSaveVO.getLeaderUserId());
        if (salesmanInfoSaveVO.getSex() != null) {
            employeeUpsertDTO.setGender(salesmanInfoSaveVO.getSex().equals(1) ? "MALE" : "FEMALE");
        }
        employeeUpsertDTO.setAreaVO(areaVO);
        if (StrUtil.isNotBlank((CharSequence)salesmanInfoSaveVO.getPhone())) {
            employeeUpsertDTO.setPhone(salesmanInfoSaveVO.getPhone());
        }
        employeeUpsertDTO.setId(empId);
        employeeUpsertDTO.setOrgList(List.of(employeeOrg));
        employeeUpsertDTO.setCode(scpsmanInfoDO.getScpsmanNo());
        employeeUpsertDTO.setOuterKey(salesmanInfoSaveVO.getOuterKey());
        this.appendUserTypeToEmployeeUpsertDTO(employeeUpsertDTO, id);
        ApiResult result = this.employeeRpcService.upsert(employeeUpsertDTO);
        if (!result.isSuccess()) {
            throw new BusinessException(result.getMsg() + " \u4fdd\u5b58\u5458\u5de5\u5931\u8d25");
        }
    }

    private void appendUserTypeToEmployeeUpsertDTO(EmployeeUpsertDTO employeeUpsertDTO, String id) {
        SysUserTypeDTO sysUserTypeDTO = new SysUserTypeDTO();
        sysUserTypeDTO.setIdentityId(id);
        sysUserTypeDTO.setUserType(SCPSMAN);
        employeeUpsertDTO.setUserTypeList(Collections.singletonList(sysUserTypeDTO));
    }

    public ScpsmanInfoServiceImpl(TransactionTemplate transactionTemplate, ScpDemandAuthorityDService scpDemandAuthorityDService, ScpDemandAuthorityRepo scpDemandAuthorityRepo, ScpDemandAuthorityDRepo scpDemandAuthorityDRepo) {
        this.transactionTemplate = transactionTemplate;
        this.scpDemandAuthorityDService = scpDemandAuthorityDService;
        this.scpDemandAuthorityRepo = scpDemandAuthorityRepo;
        this.scpDemandAuthorityDRepo = scpDemandAuthorityDRepo;
    }
}

