package com.elitesland.scp.application.facade.vo.scpsman;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Auther: Mark
 * @Date: 2024/3/22 10:21
 * @Description:
 */
@Data
@ApiModel("计划员公共组件分页VO")
public class SalesmanComponentPageRespVO implements Serializable {
    private static final long serialVersionUID = -8634920363032431031L;

    /**
     * 员工ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("计划员ID")
    private Long id;

    /**
     * 员工编号
     */
    @ApiModelProperty(value = "计划员编号")
//    private String empCode;
    private String scpsmanNo;


    /**
     * 员工姓名
     */
    @ApiModelProperty(value = "计划员姓名")
//    private String empName;
    private String name;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("所属组织ID")
    private Long orgId;

    /**
     * 所属组织名称
     */
    @ApiModelProperty(value = "所属组织名称")
    private String orgName;
    @ApiModelProperty(value = "所属组织编码")
    private String orgCode;
    /**
     * 所属公司ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("所属公司ID")
    private Long ouId;

    /**
     * 所属公司名称
     */
    @ApiModelProperty(value = "所属公司名称")
    private String ouName;

    /**
     * 所属公司编号
     */
    @ApiModelProperty(value = "所属公司编号")
    private String ouCode;


    /**
     * 员工绑定的用户ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "计划员绑定的用户ID")
    private Long userId;


    @ApiModelProperty(value = "登录账号")
    private String loginAccount;


    @ApiModelProperty(value = "计划员类型")
    private String scpsmanType;
    private String scpsmanTypeName;

    @ApiModelProperty(value = "手机号")
    private String phone;

    /**
     * 领导的员工编号
     */

    @ApiModelProperty(value = "领导的员工编号")
    private String leaderEmployeeCode;

    /**
     * 领导的员工ID
     */
    @ApiModelProperty(value = "领导的员工ID")
    private Long leaderEmployeeId;


    private Long leaderSalemansId;

    /**
     * 上级领导ID
     */
    @ApiModelProperty(value = "上级领导ID")
    private Long leaderUserId;
    /**
     * 上级领导姓名
     */
    @ApiModelProperty(value = "上级领导姓名")
    private String leaderUserFullName;

    @ApiModelProperty("启用状态")
    private Integer enableStatus;
    private String enableStatusName;
    private String currCode;




}
