package com.elitesland.scp.application.facade.vo.stock;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2025-01-21
* @Version 1.0
**/

@Data
@ApiModel("预测目标库存安全库存查询条件")
public class ScpPredictStStockParamVO extends AbstractOrderQueryParam {

    @ApiModelProperty(value = "主表ID")
    @NotNull(message = "预测批次ID 不能为空")
    private Long masId;

    @ApiModelProperty(value = "公司ID集合")
    private List<Long> ouIds;

    @ApiModelProperty(value = "仓库ID集合")
    private List<Long> whIds;

    @ApiModelProperty(value = "商品ID集合")
    private List<Long> itemIds;

    private BigDecimal predSafetyQtySt;

    private BigDecimal predSafetyQtyEn;

    private BigDecimal predTargetQtySt;

    private BigDecimal predTargetQtyEn;

}