package com.elitesland.scp.provider.supalloc;

import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.application.service.supalloc.ScpSupplyAllocationService;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDTO;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDtoParam;
import com.elitesland.scp.service.supalloc.ScpSupplyAllocationProvider;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 26日 19:53
 * @version: 1.0
 */
@Service
@RequiredArgsConstructor
@RestController
@RequestMapping(ScpApplication.URI_PREFIX + ScpSupplyAllocationProvider.PATH)
public class ScpSupplyAllocationProviderImpl implements ScpSupplyAllocationProvider {

    private final ScpSupplyAllocationService scpSupplyAllocationService;


    @Override
    public List<ScpSupplyAllocationRpcDTO> findSupplyAllocationRpcByParam(ScpSupplyAllocationRpcDtoParam supplyAllocationRpcDtoParam) {
        return scpSupplyAllocationService.findSupplyAllocationRpcByParam(supplyAllocationRpcDtoParam);
    }
}
