/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.app;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.scp.application.facade.vo.param.app.ScpStoreItemParamVO;
import com.elitesland.scp.application.service.app.ScpCacheService;
import com.elitesland.scp.domain.convert.app.ScpStoreItemConvert;
import com.elitesland.scp.domain.entity.item.ScpStoreItemDO;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.utils.ScpCacheUtils;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScpCacheServiceImpl
implements ScpCacheService {
    private static final Logger log = LoggerFactory.getLogger(ScpCacheServiceImpl.class);
    private final ScpCacheUtils scpCacheUtils;
    private final RedissonClient redissonClient;
    private final RmiItemService rmiItemService;

    @Override
    public List<ScpStoreItemDO> getItem(ScpStoreItemParamVO paramVO) {
        log.info("\u5f00\u59cb\u4ece\u7f13\u5b58\u7ba1\u7406\u5668\u83b7\u53d6\u5546\u54c1\u4fe1\u606f\uff0c\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        List<ScpStoreItemDO> scpStoreItemDOS = this.scpCacheUtils.getItemBySpuId(paramVO.getSpuId());
        if (CollUtil.isNotEmpty(scpStoreItemDOS)) {
            return scpStoreItemDOS;
        }
        ItmItemScpBaseRpcParam itemScpBaseRpcParam = new ItmItemScpBaseRpcParam();
        itemScpBaseRpcParam.setBusinessBuCode(paramVO.getOuCode());
        itemScpBaseRpcParam.setSpuIds(Arrays.asList(paramVO.getSpuId()));
        List<ItmItemScpBaseRpcDTO> itemScpBaseRpcDTOS = this.rmiItemService.findItemScpBaseRpcDtoByParam(itemScpBaseRpcParam);
        if (CollectionUtils.isEmpty(itemScpBaseRpcDTOS)) {
            throw new BusinessException("\u5546\u54c1SPU\u3010" + paramVO.getSpuId() + "\u3011\u4e0d\u5b58\u5728");
        }
        log.info("\u7ed3\u675f\u4ece\u7f13\u5b58\u7ba1\u7406\u5668\u83b7\u53d6\u5546\u54c1\u4fe1\u606f");
        return this.buildItem(paramVO.getSpuId(), itemScpBaseRpcDTOS);
    }

    @Override
    public void deleteKeys(List<Long> itemIds) {
        for (Long itemId : itemIds) {
            this.scpCacheUtils.deleteKeys(itemId);
        }
    }

    @Override
    public void deleteAllKeys() {
        this.scpCacheUtils.deleteAllKeys();
    }

    @Override
    public void deleteSpecKeys(String spec) {
        this.scpCacheUtils.deleteSpecKeys(spec);
    }

    private List<ScpStoreItemDO> buildItem(Long spuId, List<ItmItemScpBaseRpcDTO> itemList) {
        String lockKey = this.scpCacheUtils.generateLockKey(spuId);
        RLock lock = this.redissonClient.getLock(lockKey);
        try {
            if (lock.tryLock(300L, 30L, TimeUnit.SECONDS)) {
                List<ScpStoreItemDO> itemDOList = this.scpCacheUtils.getItemBySpuId(spuId);
                if (CollUtil.isNotEmpty(itemDOList)) {
                    List<ScpStoreItemDO> list = itemDOList;
                    return list;
                }
                List<ScpStoreItemDO> saveItems = itemList.stream().map(row -> {
                    ScpStoreItemDO itemDO = ScpStoreItemConvert.INSTANCE.dtoToDo((ItmItemScpBaseRpcDTO)row);
                    itemDO.setSkuAttachmentList(row.getSkuAttchmentList());
                    itemDO.setSpuAttachmentList(row.getSpuAttchmentList());
                    itemDO.setItemId(row.getId());
                    itemDO.setUom(row.getUom2());
                    itemDO.setUomName(row.getUom2Name());
                    itemDO.setUom2(row.getUom());
                    itemDO.setUom2Name(row.getUomName());
                    itemDO.setUomRatio(row.getUomRatio2());
                    itemDO.setMoq(row.getMoq());
                    itemDO.setItemType(row.getItemType2());
                    return itemDO;
                }).collect(Collectors.toList());
                this.scpCacheUtils.saveItem(spuId, saveItems);
                List<ScpStoreItemDO> list = saveItems;
                return list;
            }
        }
        catch (BusinessException | InterruptedException e) {
            log.error("lock error:", e);
            throw new BusinessException(e.getMessage());
        }
        finally {
            if (lock.isLocked() && lock.isHeldByCurrentThread()) {
                lock.unlock();
                log.info("unlock success,lockKey:{}", (Object)lockKey);
            }
        }
        return new ArrayList<ScpStoreItemDO>();
    }

    public ScpCacheServiceImpl(ScpCacheUtils scpCacheUtils, RedissonClient redissonClient, RmiItemService rmiItemService) {
        this.scpCacheUtils = scpCacheUtils;
        this.redissonClient = redissonClient;
        this.rmiItemService = rmiItemService;
    }
}

