package com.elitesland.scp.domain.service.order;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderReplyPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderReplyPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderReplyRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderReplySaveVO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderReplyDTO;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Optional;

public interface ScpDemandOrderReplyDomainService {

    /**
     * 评价
     *
     * @param saveVO
     * @return
     */
    Long save(ScpDemandOrderReplySaveVO saveVO);

    /**
     * 查询评价
     *
     * @param id
     * @return
     */
    Optional<ScpDemandOrderReplyDTO> findReplyByOrderId(Long id);

    /**
     * 分页查询
     * @param paramVO
     * @return
     */
    PagingVO<ScpDemandOrderReplyPageRespVO> page(@RequestBody ScpDemandOrderReplyPageParamVO paramVO);
}
