/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.provider.InvWhProvider;
import com.elitesland.sale.dto.CrmCustDTO;
import com.elitesland.sale.service.CrmCustRpcService;
import com.elitesland.sale.sync.SaleSyncTypeEnum;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.whnet.OuInfo;
import com.elitesland.scp.application.facade.vo.whnet.OuInfoQueryParamVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationBaseParamVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationExportRespVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationImportVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationPageParamVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationPageVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationRespVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationResultVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationSaveVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.convert.inv.ScpWhNetRelationConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.entity.whnet.ScpWhNetRelationDO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.domain.service.whnet.ScpWhNetRelationDomainService;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.dto.whnet.ScpWhNetRelationDTO;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepoProc;
import com.elitesland.scp.param.ScpWhNetRelationRpcDtoParam;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.support.provider.item.dto.ItmCateCodeAndNameRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemCateCodeRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.item.param.ItmItemCateCodeParam;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.mq.SyncMqMessage;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.support.provider.path.SupportTransactionPathRpcService;
import com.elitesland.support.provider.path.dto.SupportTransactionPathDRpcDTO;
import com.elitesland.support.provider.path.dto.SupportTransactionPathRpcDTO;
import com.elitesland.support.provider.path.param.SupportTransactionPathRpcParam;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpWhNetRelationServiceImpl
implements ScpWhNetRelationService {
    private static final Logger log = LoggerFactory.getLogger(ScpWhNetRelationServiceImpl.class);
    private final ScpWhNetRelationDomainService scpWhNetRelationDomainService;
    private final ItmItemRpcService itmItemRpcService;
    private final UdcProvider udcProvider;
    private final ScpWhNetRelationRepoProc scpWhNetRelationRepoProc;
    private final UdcProvider systemService;
    private final InvWhProvider whProvider;
    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final RmiInvStkRpcService rmiInvStkService;
    private final SupportTransactionPathRpcService supportTransactionPathRpcService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final CrmCustRpcService crmCustRpcService;
    private final MessageQueueTemplate messageQueueTemplate;

    @Override
    public PagingVO<ScpWhNetRelationPageVO> page(ScpWhNetRelationPageParamVO queryParam) {
        if (Boolean.TRUE.equals(queryParam.getScpmanAuthority())) {
            PagingVO<ScpManAuthorityPageRespVO> pagingVO = this.getAuthorityPageRespVOPagingVO();
            if (pagingVO.isEmpty()) {
                return new PagingVO();
            }
            this.extractedAuthorityParam(queryParam, pagingVO);
        }
        return this.scpWhNetRelationDomainService.page(queryParam);
    }

    @Override
    public OuInfo findOuInfo(OuInfoQueryParamVO queryParam) {
        OuInfo ouInfo = this.getOuInfoFromPathCode(queryParam.getSupplyWhCode(), queryParam.getDemandWhStCode(), queryParam.getType());
        log.info("\u4ed3\u7f51\u5173\u7cfb,\u67e5\u8be2\u9500\u552e\u516c\u53f8\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)ouInfo));
        return ouInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult saveWhNetRelation(ScpWhNetRelationSaveVO createParam) {
        List<ScpWhNetRelationSaveVO.ScpWhNetRelation> whNetRelationList = createParam.getScpWhNetRelations();
        Map<String, List<ScpWhNetRelationSaveVO.ScpWhNetRelation>> groupMap = whNetRelationList.stream().collect(Collectors.groupingBy(d -> d.getDemandWhStCode() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode())));
        Set<String> strings = groupMap.keySet();
        List<ScpWhNetRelationDO> existList = this.scpWhNetRelationDomainService.findByConcatKey(strings);
        Map<String, List<ScpWhNetRelationDO>> existMap = existList.stream().collect(Collectors.groupingBy(d -> d.getDemandWhStCode() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode())));
        HashSet<String> modifySet = new HashSet<String>();
        ScpWhNetRelationResultVO result = new ScpWhNetRelationResultVO();
        ArrayList<ScpWhNetRelationResultVO.ResultVO> failList = new ArrayList<ScpWhNetRelationResultVO.ResultVO>();
        ArrayList<ScpWhNetRelationResultVO.ResultVO> successList = new ArrayList<ScpWhNetRelationResultVO.ResultVO>();
        for (Map.Entry<String, List<ScpWhNetRelationSaveVO.ScpWhNetRelation>> scpWhNetRelation : groupMap.entrySet()) {
            String relationKey = scpWhNetRelation.getKey();
            List<ScpWhNetRelationSaveVO.ScpWhNetRelation> whNetRelations = scpWhNetRelation.getValue();
            long count = whNetRelations.stream().filter(d -> d.getId() != null).count();
            List activateList = whNetRelations.stream().filter(d -> Boolean.TRUE.equals(d.getStatus())).collect(Collectors.toList());
            long count1 = activateList.stream().map(d -> d.getSupplyWhCode() + d.getDemandWhStCode() + d.getType() + d.getItemCateCode() + d.getItemCode() + d.getStatus()).count();
            long count2 = activateList.stream().map(d -> d.getSupplyWhCode() + d.getDemandWhStCode() + d.getType() + d.getItemCateCode() + d.getItemCode() + d.getStatus()).distinct().count();
            if (count2 != count1) {
                String errorMsg = String.format("\u9700\u6c42\u4ed3\u5e93-\u5546\u54c1\u54c1\u7c7b-\u5546\u54c1\u3010%s-%s-%s\u3011\u5b58\u5728\u76f8\u540c\u3010\u4f9b\u5e94\u5546\u4ed3-\u7c7b\u578b\u3011\u7ec4\u5408\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", whNetRelations.get(0).getDemandWhStCode(), whNetRelations.get(0).getItemCateCode(), whNetRelations.get(0).getItemCode());
                throw new BusinessException(ApiCode.FAIL, errorMsg);
            }
            if (!CollUtil.isNotEmpty(activateList)) continue;
            if (count == 0L && existMap.containsKey(relationKey)) {
                StringBuilder msgBuilder = new StringBuilder("\u6570\u636e\u91cd\u590d\uff0c\u9700\u6c42\u4ed3\u5e93-\u5546\u54c1\u54c1\u7c7b-\u5546\u54c1\u3010").append(whNetRelations.get(0).getDemandWhStName());
                if (StringUtils.isNotEmpty((String)whNetRelations.get(0).getItemCateName())) {
                    msgBuilder.append("-").append(whNetRelations.get(0).getItemCateName());
                }
                if (StringUtils.isNotEmpty((String)whNetRelations.get(0).getItemName())) {
                    msgBuilder.append("-").append(whNetRelations.get(0).getItemName());
                }
                msgBuilder.append("\u3011\u6ee1\u8db3\u4f9b\u8d27\u767e\u5206\u6bd4\u914d\u7f6e\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539");
                throw new BusinessException(ApiCode.FAIL, msgBuilder.toString());
            }
            if (count > 0L && existMap.containsKey(relationKey)) {
                modifySet.add(relationKey);
            }
            BigDecimal sumPercent = activateList.stream().filter(d -> Boolean.TRUE.equals(d.getStatus())).map(ScpWhNetRelationSaveVO.ScpWhNetRelation::getSupplyPercentage).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            List<ScpWhNetRelationResultVO.ResultVO> resultVOS = this.getResultVOS(whNetRelations);
            if (sumPercent.compareTo(new BigDecimal("100")) == 0) {
                successList.addAll(resultVOS);
                continue;
            }
            failList.addAll(resultVOS);
        }
        result.setFailList(failList);
        result.setSuccessList(successList);
        if (CollUtil.isEmpty(failList)) {
            List<ScpWhNetRelationDTO> whNetRelationDOS = createParam.getScpWhNetRelations().stream().map(ScpWhNetRelationConvert.INSTANCE::saveVoDto).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(modifySet)) {
                List<ScpWhNetRelationDO> modifyList = this.scpWhNetRelationDomainService.findByConcatKey(modifySet);
                List<Long> existIds = modifyList.stream().map(ScpWhNetRelationDO::getId).collect(Collectors.toList());
                this.scpWhNetRelationDomainService.deleteBatch(existIds);
            }
            this.checkTransactionPath(whNetRelationDOS);
            this.scpWhNetRelationDomainService.createBatch(whNetRelationDOS);
            this.sync(whNetRelationDOS);
            return ((ApiResult)((ApiResult)((ApiResult)((ApiResult)ApiResult.builder().success(true)).code(200)).data((Object)result)).msg("\u64cd\u4f5c\u6210\u529f")).build();
        }
        return ((ApiResult)((ApiResult)((ApiResult)((ApiResult)ApiResult.builder().success(false)).code(0)).data((Object)result)).msg("\u64cd\u4f5c\u5931\u8d25")).build();
    }

    private void sync(List<ScpWhNetRelationDTO> whNetRelationDOS) {
        List<ScpWhNetRelationDTO> relationDTOS = whNetRelationDOS.stream().filter(d -> "0".equals(d.getType())).collect(Collectors.toList());
        InvWhRpcDtoParam invWhRpcDtoParam = new InvWhRpcDtoParam();
        invWhRpcDtoParam.setWhIds(relationDTOS.stream().map(ScpWhNetRelationDTO::getSupplyWhId).distinct().collect(Collectors.toList()));
        Map<Long, InvWhRpcDTO> whMap = ((List)this.whProvider.findWhDTOByParam(invWhRpcDtoParam).computeData()).stream().collect(Collectors.toMap(InvWhRpcDTO::getWhId, d -> d));
        Map<String, OrgStoreDetailRpcDTO> storeDetailRpcDTOMap = this.rmiOrgStoreRpcService.queryByStoreCodes(relationDTOS.stream().map(ScpWhNetRelationDTO::getDemandWhStCode).collect(Collectors.toList())).stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getStoreCode, d -> d));
        relationDTOS.forEach(d -> {
            CrmCustDTO crmCustDTO;
            Long supplyWhId = d.getSupplyWhId();
            InvWhRpcDTO invWhRpcDTO = (InvWhRpcDTO)whMap.get(supplyWhId);
            OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = (OrgStoreDetailRpcDTO)storeDetailRpcDTOMap.get(d.getDemandWhStCode());
            if (Objects.nonNull(invWhRpcDTO) && Objects.nonNull(orgStoreDetailRpcDTO) && "HD".equals(invWhRpcDTO.getOtherWhType())) {
                CrmCustDTO crmCustDTO2 = (CrmCustDTO)this.crmCustRpcService.getCustInfo(orgStoreDetailRpcDTO.getStoreCode()).computeData();
                if (Objects.nonNull(crmCustDTO2)) {
                    SyncMqMessage syncMqMessage = new SyncMqMessage();
                    syncMqMessage.setBusinessKey(orgStoreDetailRpcDTO.getStoreCode());
                    syncMqMessage.setEntityId(crmCustDTO2.getId());
                    syncMqMessage.setOutSysType("HD");
                    syncMqMessage.setEntityKey(orgStoreDetailRpcDTO.getStoreCode());
                    this.messageQueueTemplate.publishMessage("yst-suplan", SaleSyncTypeEnum.CUST.name() + "__HD", (Serializable)syncMqMessage);
                }
            } else if (Objects.nonNull(invWhRpcDTO) && Objects.nonNull(orgStoreDetailRpcDTO) && "ShWms".equals(invWhRpcDTO.getOtherWhType()) && Objects.nonNull(crmCustDTO = (CrmCustDTO)this.crmCustRpcService.getCustInfo(orgStoreDetailRpcDTO.getStoreCode()).computeData())) {
                SyncMqMessage syncMqMessage = new SyncMqMessage();
                syncMqMessage.setBusinessKey(orgStoreDetailRpcDTO.getStoreCode());
                syncMqMessage.setEntityId(crmCustDTO.getId());
                syncMqMessage.setOutSysType("ShWms");
                syncMqMessage.setEntityKey(orgStoreDetailRpcDTO.getStoreCode());
                this.messageQueueTemplate.publishMessage("yst-suplan", SaleSyncTypeEnum.CUST.name() + "__ShWms", (Serializable)syncMqMessage);
            }
        });
    }

    private void checkTransactionPath(List<ScpWhNetRelationDTO> whNetRelationList) {
        List<String> whCodes = whNetRelationList.stream().map(ScpWhNetRelationDTO::getSupplyWhCode).distinct().collect(Collectors.toList());
        Map<String, InvWhRpcSimpleDTO> whMap = this.buildInvWhMap(whCodes);
        List<String> demandWhCodes = whNetRelationList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(row.getType())).map(ScpWhNetRelationDTO::getDemandWhStCode).distinct().collect(Collectors.toList());
        Map<String, InvWhRpcSimpleDTO> demandWhMap = this.buildInvWhMap(demandWhCodes);
        List<String> demandStoreCodes = whNetRelationList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType())).map(ScpWhNetRelationDTO::getDemandWhStCode).distinct().collect(Collectors.toList());
        Map<String, OrgStoreBaseRpcDTO> fStoreMap = this.getStoreMap(demandStoreCodes);
        ArrayList<SupportTransactionPathRpcParam> rpcParams = new ArrayList<SupportTransactionPathRpcParam>();
        whNetRelationList.forEach(row -> {
            Long whOuId;
            String demandWhStCode = row.getDemandWhStCode();
            String supplyWhCode = row.getSupplyWhCode();
            Long ouId = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) ? ((OrgStoreBaseRpcDTO)fStoreMap.get(demandWhStCode)).getOuId() : ((InvWhRpcSimpleDTO)demandWhMap.get(demandWhStCode)).getOuId();
            if (!ouId.equals(whOuId = ((InvWhRpcSimpleDTO)whMap.get(supplyWhCode)).getOuId())) {
                SupportTransactionPathRpcParam rpcParam = new SupportTransactionPathRpcParam();
                rpcParam.setCompanyIdStart(whOuId);
                rpcParam.setCompanyIdEnd(ouId);
                rpcParams.add(rpcParam);
            }
        });
        Map<String, List<SupportTransactionPathRpcDTO>> suppTransactionPathMap = this.checkTransactionPathAndBuild(rpcParams);
        whNetRelationList.forEach(row -> {
            String demandWhStCode = row.getDemandWhStCode();
            String supplyWhCode = row.getSupplyWhCode();
            Long ouId = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) ? ((OrgStoreBaseRpcDTO)fStoreMap.get(demandWhStCode)).getOuId() : ((InvWhRpcSimpleDTO)demandWhMap.get(demandWhStCode)).getOuId();
            String ouCode = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) ? ((OrgStoreBaseRpcDTO)fStoreMap.get(demandWhStCode)).getOuCode() : ((InvWhRpcSimpleDTO)demandWhMap.get(demandWhStCode)).getOuCode();
            Long whOuId = ((InvWhRpcSimpleDTO)whMap.get(supplyWhCode)).getOuId();
            String whOuCode = ((InvWhRpcSimpleDTO)whMap.get(supplyWhCode)).getOuCode();
            if (!ouId.equals(whOuId)) {
                List pathList = (List)suppTransactionPathMap.get(whOuId + "@" + ouId);
                if (CollUtil.isEmpty((Collection)pathList) || StrUtil.isBlank((CharSequence)((SupportTransactionPathRpcDTO)pathList.get(0)).getPathCode())) {
                    log.info("\u4ece\u516c\u53f8 {}\u5230\u516c\u53f8 {}\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4", (Object)whOuId, (Object)ouId);
                    throw new BusinessException("\u4ece\u516c\u53f8\u3010" + whOuCode + "\u3011\u81f3\u516c\u53f8\u3010" + ouCode + "\u3011\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4");
                }
                List detailList = ((SupportTransactionPathRpcDTO)pathList.get(0)).getDetailList();
                int size = detailList.size();
                SupportTransactionPathDRpcDTO dto = (SupportTransactionPathDRpcDTO)detailList.get(size - 1);
                row.setCustCode(dto.getCompanyCodeStart());
                row.setOuCode(dto.getCompanyCodeStart());
                row.setOuName(dto.getCompanyNameStart());
                row.setCustCode(dto.getCustCodeEnd());
            }
        });
    }

    private Map<String, OrgStoreBaseRpcDTO> getStoreMap(List<String> demandStoreCodes) {
        List<OrgStoreBaseRpcDTO> orgStoreBaseRpcDTOS = this.rmiOrgStoreRpcService.findOrgStoreBaseByParam(demandStoreCodes);
        if (CollUtil.isEmpty(orgStoreBaseRpcDTOS)) {
            return new HashMap<String, OrgStoreBaseRpcDTO>();
        }
        return orgStoreBaseRpcDTOS.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, List<SupportTransactionPathRpcDTO>> checkTransactionPathAndBuild(List<SupportTransactionPathRpcParam> rpcParams) {
        log.info("\u67e5\u8be2\u542f\u7528\u72b6\u6001\u7684\u7ed3\u7b97\u8def\u5f84,\u53c2\u6570:{}", (Object)JSONObject.toJSONString(rpcParams));
        List data = (List)this.supportTransactionPathRpcService.queryListByParam(rpcParams).getData();
        log.info("\u67e5\u8be2\u542f\u7528\u72b6\u6001\u7684\u7ed3\u7b97\u8def\u5f84\u7ed3\u675f,\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)data));
        if (CollUtil.isEmpty((Collection)data)) {
            return new HashMap<String, List<SupportTransactionPathRpcDTO>>();
        }
        return data.stream().collect(Collectors.groupingBy(row -> row.getCompanyIdStart() + "@" + row.getCompanyIdEnd()));
    }

    private Map<String, InvWhRpcSimpleDTO> buildInvWhMap(List<String> demandWhCodes) {
        if (CollUtil.isEmpty(demandWhCodes)) {
            return new HashMap<String, InvWhRpcSimpleDTO>();
        }
        return this.rmiInvStkService.findInvWhBaseMapByCode(demandWhCodes);
    }

    private Map<String, OrgStoreBaseRpcDTO> getStoreInfoBy(List<String> demandStCodes) {
        log.info("\u6279\u91cf\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u5165\u53c2{}", (Object)JSONUtil.toJsonStr(demandStCodes));
        List<OrgStoreBaseRpcDTO> resultList = this.rmiOrgStoreRpcService.findOrgStoreBaseByParam(demandStCodes);
        log.info("\u6279\u91cf\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u7ed3\u679c{}", (Object)JSONUtil.toJsonStr(resultList));
        Map<String, OrgStoreBaseRpcDTO> resultMap = resultList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, Function.identity()));
        log.info("\u6279\u91cf\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u7ed3\u679c\u5b57\u5178{}", (Object)JSONUtil.toJsonStr(resultMap));
        return resultMap;
    }

    private OuInfo getOuInfoFromPathCode(String fromWhCode, String toWhStCode, String type) {
        Long toOuId;
        String toOuCode;
        log.info("\u83b7\u53d6\u7ed3\u7b97\u8def\u5f84\u53c2\u6570,\u4ece\u4ed3\u5e93\u7f16\u7801:{},\u81f3\u4ed3\u5e93/\u95e8\u5e97\u7f16\u7801:{}", (Object)fromWhCode, (Object)toWhStCode);
        InvWhRpcSimpleDTO invWhMap = this.rmiInvStkService.findSimpleWhByCode(fromWhCode);
        Long fromOuId = invWhMap.getOuId();
        String fromOuCode = invWhMap.getOuCode();
        if ("1".equals(type)) {
            InvWhRpcSimpleDTO simpleDTO = this.rmiInvStkService.findSimpleWhByCode(toWhStCode);
            toOuCode = simpleDTO.getOuCode();
            toOuId = simpleDTO.getOuId();
        } else {
            OrgStoreBaseRpcDTO orgStore = this.getOuIdByStoreCode(toWhStCode);
            toOuCode = orgStore.getOuCode();
            toOuId = orgStore.getOuId();
        }
        log.info("fromOuId\u7684\u503c:{},toOuId\u7684\u503c:{}", (Object)fromOuId, (Object)toOuId);
        if (fromOuId == null || toOuId == null) {
            return null;
        }
        SupportTransactionPathRpcDTO pathCodeResult = this.getPathCodeResult(fromOuId, toOuId);
        if (pathCodeResult == null) {
            throw new BusinessException("\u4ece\u516c\u53f8\u3010" + fromOuCode + "\u3011\u81f3\u516c\u53f8\u3010" + toOuCode + "\u3011\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4");
        }
        log.info("\u83b7\u53d6\u5230\u7ed3\u7b97\u8def\u5f84\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)pathCodeResult));
        List detailList = pathCodeResult.getDetailList();
        int size = detailList.size();
        SupportTransactionPathDRpcDTO dto = (SupportTransactionPathDRpcDTO)detailList.get(size - 1);
        OuInfo ouInfo = new OuInfo();
        ouInfo.setOuCode(dto.getCompanyCodeStart());
        ouInfo.setOuName(dto.getCompanyNameStart());
        ouInfo.setOuId(dto.getCompanyIdStart());
        log.info("\u6839\u636e\u7ed3\u7b97\u8def\u5f84\u83b7\u53d6\u5230\u9500\u552e\u516c\u53f8\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)ouInfo));
        return ouInfo;
    }

    private OrgStoreBaseRpcDTO getOuIdByStoreCode(String storeCode) {
        Map<String, OrgStoreBaseRpcDTO> storeInfoBy = this.getStoreInfoBy(Arrays.asList(storeCode));
        if (!storeInfoBy.containsKey(storeCode)) {
            throw new BusinessException("\u95e8\u5e97\u7f16\u7801:" + storeCode + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
        }
        return storeInfoBy.get(storeCode);
    }

    private SupportTransactionPathRpcDTO getPathCodeResult(Long from, Long to) {
        log.info("\u67e5\u8be2\u7ed3\u7b97\u8def\u5f84\u53c2\u6570,from:{},to:{}", (Object)from, (Object)to);
        SupportTransactionPathRpcParam rpcParam = new SupportTransactionPathRpcParam();
        rpcParam.setCompanyIdStart(from);
        rpcParam.setCompanyIdEnd(to);
        SupportTransactionPathRpcDTO result = (SupportTransactionPathRpcDTO)this.supportTransactionPathRpcService.queryByParam(rpcParam).getData();
        log.info("\u67e5\u8be2\u7ed3\u7b97\u8def\u5f84\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)result));
        return result;
    }

    public String setEmptyStringStr(String str) {
        return str == null ? "" : str;
    }

    private List<ScpWhNetRelationResultVO.ResultVO> getResultVOS(List<ScpWhNetRelationSaveVO.ScpWhNetRelation> whNetRelations) {
        return whNetRelations.stream().map(w -> {
            ScpWhNetRelationResultVO.ResultVO resultVO = new ScpWhNetRelationResultVO.ResultVO();
            resultVO.setSupplyWhId(w.getId());
            resultVO.setSupplyWhCode(w.getSupplyWhCode());
            resultVO.setSupplyWhName(w.getSupplyWhName());
            resultVO.setDemandWhStCode(w.getDemandWhStCode());
            resultVO.setDemandWhStId(w.getDemandWhStId());
            resultVO.setDemandWhStName(w.getDemandWhStName());
            resultVO.setType(w.getType());
            resultVO.setItemCode(w.getItemCode());
            resultVO.setItemId(w.getItemId());
            resultVO.setItemName(w.getItemName());
            resultVO.setItemCateCode(w.getItemCateCode());
            if (StringUtils.isNotEmpty((String)w.getItemCateName())) {
                String itemCateName = w.getItemCateName().replace(",", ">");
                resultVO.setItemCateName(itemCateName);
            }
            resultVO.setSupplyPercentage(w.getSupplyPercentage());
            resultVO.setLineNo(w.getLineNo());
            return resultVO;
        }).collect(Collectors.toList());
    }

    @Override
    public List<ScpWhNetRelationRespVO> findWhNetList(ScpWhNetRelationBaseParamVO param) {
        String bussinessKey = param.getDemandWhStCode();
        if (StringUtils.isNotEmpty((String)param.getItemCateCode())) {
            bussinessKey = bussinessKey.concat(param.getItemCateCode());
            if (StringUtils.isNotEmpty((String)param.getItemCode())) {
                bussinessKey = bussinessKey.concat(param.getItemCode());
            }
        }
        List<ScpWhNetRelationDO> relationDOS = this.scpWhNetRelationDomainService.findByBussinessKey(bussinessKey);
        List<ScpWhNetRelationRespVO> relationRespVOList = relationDOS.stream().map(ScpWhNetRelationConvert.INSTANCE::doToRespVO).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(relationRespVOList)) {
            Map typeMap = this.udcProvider.getValueMapByUdcCode("yst-suplan", Set.of("DEMAND_SET_TYPE"));
            relationRespVOList.forEach(d -> {
                d.setTypeName((String)((Map)typeMap.getOrDefault("DEMAND_SET_TYPE", new HashMap())).get(d.getType()));
                if (StringUtils.isNotEmpty((String)d.getItemCateCode())) {
                    List itemCatePath = this.itmItemRpcService.findItemCatePath(d.getItemCateCode());
                    d.setItemCatePath(itemCatePath);
                }
            });
        }
        return relationRespVOList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteWhNetRelation(List<Long> ids) {
        this.scpWhNetRelationDomainService.deleteBatch(ids);
    }

    @Override
    public List<ScpWhNetRelationRpcDTO> findWhNetRelationRpcDtoByParam(ScpWhNetRelationRpcDtoParam queryParam) {
        if (StringUtils.isNotEmpty((String)queryParam.getItemCode()) && StringUtils.isEmpty((String)queryParam.getItemCateCode())) {
            ItmItemBaseRpcParam itemRpcDtoParam = new ItmItemBaseRpcParam();
            itemRpcDtoParam.setItemCodes(List.of(queryParam.getItemCode()));
            List itemRpcDtoByParam = this.itmItemRpcService.findItemBaseRpcDtoByParam(itemRpcDtoParam);
            queryParam.setItemCateCode(((ItmItemBaseRpcDTO)itemRpcDtoByParam.get(0)).getItemCateCode());
        }
        log.info("ScpWhNetRelationRpcDtoParam:{} ", (Object)JSON.toJSONString((Object)queryParam));
        List<ScpWhNetRelationRpcDTO> relationRpcDTOS = this.scpWhNetRelationRepoProc.findWhNetRelationRpcDtoByParam(queryParam);
        if (CollUtil.isEmpty(relationRpcDTOS)) {
            return new ArrayList<ScpWhNetRelationRpcDTO>();
        }
        List<ScpWhNetRelationRpcDTO> itemCodeLevelList = relationRpcDTOS.stream().filter(d -> Objects.equals(queryParam.getItemCode(), d.getItemCode()) && Objects.equals(queryParam.getItemCateCode(), d.getItemCateCode())).collect(Collectors.toList());
        List<ScpWhNetRelationRpcDTO> cateLevelList = relationRpcDTOS.stream().filter(d -> Objects.equals(queryParam.getItemCateCode(), d.getItemCateCode())).collect(Collectors.toList());
        List<ScpWhNetRelationRpcDTO> demandCodeList = relationRpcDTOS.stream().filter(d -> Objects.equals(queryParam.getDemandWhStCode(), d.getDemandWhStCode())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(itemCodeLevelList)) {
            return itemCodeLevelList;
        }
        if (CollUtil.isNotEmpty(cateLevelList)) {
            return cateLevelList;
        }
        return demandCodeList;
    }

    @Override
    public PagingVO<ScpWhNetRelationExportRespVO> exportSearch(ScpWhNetRelationPageParamVO queryParam) {
        if (Boolean.TRUE.equals(queryParam.getScpmanAuthority())) {
            PagingVO<ScpManAuthorityPageRespVO> pagingVO = this.getAuthorityPageRespVOPagingVO();
            if (pagingVO.isEmpty()) {
                return new PagingVO();
            }
            this.extractedAuthorityParam(queryParam, pagingVO);
        }
        return this.scpWhNetRelationDomainService.exportSearch(queryParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<String> executeImport(List<ScpWhNetRelationImportVO> dataList, int startRowIndex) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        ArrayList<String> errorList = new ArrayList<String>();
        this.checkImportParam(dataList, errorList);
        List<String> result = this.validResult(errorList);
        List<String> successDocGroup = this.getSuccessDocGroup(result, dataList);
        if (successDocGroup.isEmpty()) {
            return result;
        }
        log.info("\u4ed3\u7f51\u5173\u7cfb\u5bfc\u5165\u8282\u70b9\u4e00");
        List suplyWhCodes = dataList.stream().map(ScpWhNetRelationImportVO::getSupplyWhCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        InvWhRpcDtoParam whRpcDtoParam = new InvWhRpcDtoParam();
        whRpcDtoParam.setWhCodes(suplyWhCodes);
        ApiResult whList = this.whProvider.findWhDTOByParam(whRpcDtoParam);
        Map<String, InvWhRpcDTO> supplyWhMap = ((List)whList.getData()).stream().collect(Collectors.toMap(InvWhRpcDTO::getWhCode, i -> i, (o, n) -> n));
        Map<Object, Object> storeMap = new HashMap();
        List storeCodes = dataList.stream().filter(d -> UdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(d.getType())).map(ScpWhNetRelationImportVO::getDemandWhStCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(storeCodes)) {
            OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
            orgStoreBaseRpcParam.setStoreCodeList(storeCodes);
            List storeList = (List)this.orgStoreRpcService.findOrgStoreBaseByParam(orgStoreBaseRpcParam).getData();
            storeMap = storeList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, i -> i, (o, n) -> n));
        }
        List demandWhCodes = dataList.stream().filter(d -> UdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(d.getType())).map(ScpWhNetRelationImportVO::getDemandWhStCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Object, Object> demandWhMap = new HashMap();
        if (CollUtil.isNotEmpty(demandWhCodes)) {
            InvWhRpcDtoParam whRpcDtoParam2 = new InvWhRpcDtoParam();
            whRpcDtoParam2.setWhCodes(demandWhCodes);
            ApiResult demandWhList = this.whProvider.findWhDTOByParam(whRpcDtoParam2);
            demandWhMap = ((List)demandWhList.getData()).stream().collect(Collectors.toMap(InvWhRpcDTO::getWhCode, i -> i, (o, n) -> n));
        }
        List itemCateCodes = dataList.stream().map(ScpWhNetRelationImportVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map cateMap = new HashMap();
        if (CollUtil.isNotEmpty(itemCateCodes)) {
            ItmItemCateCodeParam cateCodeParam = new ItmItemCateCodeParam();
            cateCodeParam.setItemCateCodes(itemCateCodes);
            ItmItemCateCodeRpcDTO itemCateCodeRpcDTO = this.itmItemRpcService.findCateCodeReItemCateCode(cateCodeParam);
            cateMap = itemCateCodeRpcDTO.getCateMap();
            log.info("cateMap:{} ", (Object)JSON.toJSONString(cateMap));
        }
        List itemCodes = dataList.stream().map(ScpWhNetRelationImportVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Object, Object> itemMap = new HashMap();
        if (CollUtil.isNotEmpty(itemCodes)) {
            ItmItemRpcDtoParam itemRpcDtoParam = new ItmItemRpcDtoParam();
            itemRpcDtoParam.setItemCodes(itemCodes);
            List itemRpcDtoByParam = this.itmItemRpcService.findItemRpcDtoByParam(itemRpcDtoParam);
            itemMap = itemRpcDtoByParam.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, i -> i, (o, e) -> e));
        }
        HashMap errorMap = new HashMap();
        HashMap whNetRelationMap = new HashMap();
        for (ScpWhNetRelationImportVO importEntity : dataList) {
            if (!successDocGroup.contains(importEntity.getType() + importEntity.getSupplyWhCode() + importEntity.getDemandWhStCode() + importEntity.getItemCode())) continue;
            errorMap.put(importEntity.getLineNo(), new ArrayList());
            ArrayList<ScpWhNetRelationDTO> relationDTOList = (ArrayList<ScpWhNetRelationDTO>)whNetRelationMap.get(importEntity.getType() + importEntity.getSupplyWhCode() + importEntity.getDemandWhStCode() + importEntity.getItemCode());
            if (CollUtil.isEmpty((Collection)relationDTOList)) {
                relationDTOList = new ArrayList<ScpWhNetRelationDTO>();
                whNetRelationMap.put((CallSite)((Object)(importEntity.getType() + importEntity.getSupplyWhCode() + importEntity.getDemandWhStCode() + importEntity.getItemCode())), relationDTOList);
            }
            ScpWhNetRelationDTO scpWhNetRelationDTO = new ScpWhNetRelationDTO();
            scpWhNetRelationDTO.setType(importEntity.getType());
            scpWhNetRelationDTO.setSupplyWhCode(importEntity.getSupplyWhCode());
            InvWhRpcDTO supplyWhRpcDTO = supplyWhMap.get(importEntity.getSupplyWhCode());
            if (supplyWhRpcDTO == null) {
                ((List)errorMap.get(importEntity.getLineNo())).add("\u4f9b\u5e94\u4ed3\u5e93\u7f16\u7801" + importEntity.getSupplyWhCode() + " \u4e0d\u5b58\u5728");
            } else {
                scpWhNetRelationDTO.setSupplyWhId(supplyWhRpcDTO.getId());
                scpWhNetRelationDTO.setSupplyWhName(supplyWhRpcDTO.getWhName());
            }
            if (UdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(importEntity.getType())) {
                OrgStoreBaseRpcDTO storeDetailRpcDTO = (OrgStoreBaseRpcDTO)storeMap.get(importEntity.getDemandWhStCode());
                if (storeDetailRpcDTO == null) {
                    ((List)errorMap.get(importEntity.getLineNo())).add("\u9700\u6c42\u4ed3\u5e93\u7f16\u7801/\u95e8\u5e97\u7f16\u7801" + importEntity.getDemandWhStCode() + " \u4e0d\u5b58\u5728");
                } else {
                    scpWhNetRelationDTO.setDemandWhStId(storeDetailRpcDTO.getId());
                    scpWhNetRelationDTO.setDemandWhStCode(importEntity.getDemandWhStCode());
                    scpWhNetRelationDTO.setDemandWhStName(storeDetailRpcDTO.getStoreName());
                }
                if (!storeDetailRpcDTO.getOuId().equals(supplyWhRpcDTO.getOuId())) {
                    pathRpcParam = new SupportTransactionPathRpcParam();
                    pathRpcParam.setCompanyIdStart(supplyWhRpcDTO.getOuId());
                    pathRpcParam.setCompanyIdEnd(storeDetailRpcDTO.getOuId());
                    data = (SupportTransactionPathRpcDTO)this.supportTransactionPathRpcService.queryByParam(pathRpcParam).getData();
                    log.info("\u67e5\u8be2\u542f\u7528\u72b6\u6001\u7684\u7ed3\u7b97\u8def\u5f84\u7ed3\u675f,\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)data));
                    if (data == null || StrUtil.isBlank((CharSequence)data.getPathCode())) {
                        log.info("\u4ece\u516c\u53f8 {}\u5230\u516c\u53f8 {}\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4", (Object)supplyWhRpcDTO.getOuId(), (Object)storeDetailRpcDTO.getOuId());
                        ((List)errorMap.get(importEntity.getLineNo())).add("\u4ece\u516c\u53f8:" + supplyWhRpcDTO.getOuCode() + "\u5230\u516c\u53f8:" + storeDetailRpcDTO.getOuCode() + "\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4");
                    }
                    detailList = data.getDetailList();
                    size = detailList.size();
                    dto = (SupportTransactionPathDRpcDTO)detailList.get(size - 1);
                    scpWhNetRelationDTO.setCustCode(dto.getCompanyCodeStart());
                    scpWhNetRelationDTO.setOuCode(dto.getCompanyCodeStart());
                    scpWhNetRelationDTO.setOuName(dto.getCompanyNameStart());
                    scpWhNetRelationDTO.setCustCode(dto.getCustCodeEnd());
                }
            } else {
                InvWhRpcDTO demandWhDto = (InvWhRpcDTO)demandWhMap.get(importEntity.getDemandWhStCode());
                if (demandWhDto == null) {
                    ((List)errorMap.get(importEntity.getLineNo())).add("\u9700\u6c42\u4ed3\u5e93\u7f16\u7801/\u95e8\u5e97\u7f16\u7801" + importEntity.getDemandWhStCode() + " \u4e0d\u5b58\u5728");
                } else {
                    scpWhNetRelationDTO.setDemandWhStId(demandWhDto.getId());
                    scpWhNetRelationDTO.setDemandWhStCode(importEntity.getDemandWhStCode());
                    scpWhNetRelationDTO.setDemandWhStName(demandWhDto.getWhName());
                }
                if (!demandWhDto.getOuId().equals(supplyWhRpcDTO.getOuId())) {
                    pathRpcParam = new SupportTransactionPathRpcParam();
                    pathRpcParam.setCompanyIdStart(supplyWhRpcDTO.getOuId());
                    pathRpcParam.setCompanyIdEnd(demandWhDto.getOuId());
                    data = (SupportTransactionPathRpcDTO)this.supportTransactionPathRpcService.queryByParam(pathRpcParam).getData();
                    log.info("\u67e5\u8be2\u542f\u7528\u72b6\u6001\u7684\u7ed3\u7b97\u8def\u5f84\u7ed3\u675f,\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)data));
                    if (data == null || StrUtil.isBlank((CharSequence)data.getPathCode())) {
                        log.info("\u4ece\u516c\u53f8 {}\u5230\u516c\u53f8 {}\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4", (Object)supplyWhRpcDTO.getOuId(), (Object)demandWhDto.getOuId());
                        ((List)errorMap.get(importEntity.getLineNo())).add("\u4ece\u516c\u53f8:" + supplyWhRpcDTO.getOuCode() + "\u5230\u516c\u53f8:" + demandWhDto.getOuCode() + "\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4");
                    }
                    detailList = data.getDetailList();
                    size = detailList.size();
                    dto = (SupportTransactionPathDRpcDTO)detailList.get(size - 1);
                    scpWhNetRelationDTO.setCustCode(dto.getCompanyCodeStart());
                    scpWhNetRelationDTO.setOuCode(dto.getCompanyCodeStart());
                    scpWhNetRelationDTO.setOuName(dto.getCompanyNameStart());
                    scpWhNetRelationDTO.setCustCode(dto.getCustCodeEnd());
                }
            }
            if (StringUtils.isNotEmpty((String)importEntity.getItemCateCode())) {
                ItmCateCodeAndNameRpcDTO itmCateCodeAndNameRpcDTO = (ItmCateCodeAndNameRpcDTO)cateMap.get(importEntity.getItemCateCode());
                if (itmCateCodeAndNameRpcDTO == null) {
                    ((List)errorMap.get(importEntity.getLineNo())).add("\u5546\u54c1\u54c1\u7c7b\u7f16\u7801" + importEntity.getItemCateCode() + " \u4e0d\u5b58\u5728");
                } else {
                    scpWhNetRelationDTO.setItemCateName(String.join((CharSequence)">", itmCateCodeAndNameRpcDTO.getCateNameList()));
                    scpWhNetRelationDTO.setItemCateCode(importEntity.getItemCateCode());
                }
            }
            if (StringUtils.isNotEmpty((String)importEntity.getItemCode())) {
                ItmItemRpcDTO itmItemRpcDTO = (ItmItemRpcDTO)itemMap.get(importEntity.getItemCode());
                if (itmItemRpcDTO == null) {
                    ((List)errorMap.get(importEntity.getLineNo())).add("\u5546\u54c1\u7f16\u7801" + importEntity.getItemCode() + " \u4e0d\u5b58\u5728");
                } else {
                    scpWhNetRelationDTO.setItemCode(importEntity.getItemCode());
                    scpWhNetRelationDTO.setItemId(itmItemRpcDTO.getId());
                    scpWhNetRelationDTO.setItemName(itmItemRpcDTO.getItemName());
                    scpWhNetRelationDTO.setItemCateName(String.join((CharSequence)">", itmItemRpcDTO.getItemCatePathName()));
                    if (StringUtils.isNotEmpty((String)importEntity.getItemCateCode()) && !itmItemRpcDTO.getItemCateCode().equals(importEntity.getItemCateCode())) {
                        ((List)errorMap.get(importEntity.getLineNo())).add("\u5546\u54c1\u7f16\u7801" + importEntity.getItemCode() + "\u7684\u54c1\u7c7b\u548c\u5bfc\u5165\u54c1\u7c7b" + importEntity.getItemCateCode() + " \u4e0d\u4e00\u81f4");
                    } else {
                        scpWhNetRelationDTO.setItemCateCode(itmItemRpcDTO.getItemCateCode());
                    }
                }
            }
            scpWhNetRelationDTO.setTransferLeadTime(importEntity.getTransferLeadTime());
            scpWhNetRelationDTO.setSupplyPercentage(importEntity.getSupplyPercentage());
            scpWhNetRelationDTO.setStatus(Boolean.TRUE);
            scpWhNetRelationDTO.setEs1(importEntity.getImportBillNum());
            scpWhNetRelationDTO.setLineNo(importEntity.getLineNo());
            relationDTOList.add(scpWhNetRelationDTO);
        }
        log.info("\u4ed3\u7f51\u5173\u7cfb\u5bfc\u5165\u8282\u70b9\u4e8c");
        for (String key : whNetRelationMap.keySet()) {
            List scpWhNetRelationDTOS = (List)whNetRelationMap.get(key);
            if (scpWhNetRelationDTOS.size() >= 2) {
                scpWhNetRelationDTOS.forEach(a -> ((List)errorMap.get(a.getLineNo())).add("\u7c7b\u578b+\u4f9b\u5e94\u4ed3\u5e93+\u9700\u6c42\u95e8\u5e97+\u7269\u6599\u7f16\u7801[" + a.getType() + a.getSupplyWhCode() + a.getDemandWhStCode() + a.getItemCode() + "]\u5bfc\u5165\u5b58\u5728\u91cd\u590d\u6570\u636e"));
            }
            scpWhNetRelationDTOS.forEach(a -> a.setSupplyPercentage(BigDecimal.valueOf(100L)));
            Set<String> existsList = scpWhNetRelationDTOS.stream().map(d -> d.getType() + this.setEmptyStringStr(d.getSupplyWhCode()) + this.setEmptyStringStr(d.getDemandWhStCode()) + this.setEmptyStringStr(d.getItemCode())).collect(Collectors.toSet());
            List<ScpWhNetRelationDO> existList = this.scpWhNetRelationDomainService.findByAllConcatKey(existsList);
            if (!CollUtil.isNotEmpty(existList)) continue;
            scpWhNetRelationDTOS.forEach(a -> ((List)errorMap.get(a.getLineNo())).add("\u7c7b\u578b+\u4f9b\u5e94\u4ed3\u5e93+\u9700\u6c42\u95e8\u5e97+\u7269\u6599\u7f16\u7801[" + a.getType() + a.getSupplyWhCode() + a.getDemandWhStCode() + a.getItemCode() + "]\u5df2\u6709\u6570\u636e\u5b58\u5728\u91cd\u590d"));
        }
        log.info("\u4ed3\u7f51\u5173\u7cfb\u5bfc\u5165\u8282\u70b9\u4e09");
        for (Integer line : errorMap.keySet()) {
            if (((List)errorMap.get(line)).isEmpty()) continue;
            if (Objects.equals(errorList.get(line - 1), "-")) {
                errorList.set(line - 1, String.join((CharSequence)",", (Iterable)errorMap.get(line)));
                continue;
            }
            errorList.set(line - 1, (String)errorList.get(line - 1) + String.join((CharSequence)",", (Iterable)errorMap.get(line)));
        }
        successDocGroup = this.getSuccessDocGroup(errorList, dataList);
        ArrayList<ScpWhNetRelationDTO> ddos = new ArrayList<ScpWhNetRelationDTO>();
        if (!successDocGroup.isEmpty()) {
            List<String> finalSuccessDocGroup = successDocGroup;
            for (String key : whNetRelationMap.keySet()) {
                List scpWhNetRelationDTOS = (List)whNetRelationMap.get(key);
                List doList = scpWhNetRelationDTOS.stream().filter(i -> finalSuccessDocGroup.contains(i.getType() + i.getSupplyWhCode() + i.getDemandWhStCode() + i.getItemCode())).collect(Collectors.toList());
                if (doList.isEmpty()) continue;
                ddos.addAll(doList);
            }
        }
        ArrayList<String> newResult = new ArrayList<String>();
        ArrayList<String> errorNewList = new ArrayList<String>();
        for (int i2 = 0; i2 < errorList.size(); ++i2) {
            String error = (String)errorList.get(i2);
            String importDocGroup = dataList.get(i2).getType() + dataList.get(i2).getSupplyWhCode() + dataList.get(i2).getDemandWhStCode() + dataList.get(i2).getItemCode();
            if (!successDocGroup.contains(importDocGroup)) {
                if (Objects.equals(error, "-")) {
                    newResult.add("-");
                    continue;
                }
                newResult.add(error);
                errorNewList.add(error);
                continue;
            }
            newResult.add(null);
        }
        if (CollUtil.isEmpty(errorNewList)) {
            log.info("\u4ed3\u7f51\u5173\u7cfb\u5bfc\u5165\u8282\u70b9\u56db:{}", ddos);
            this.scpWhNetRelationDomainService.createBatch(ddos);
        }
        return newResult;
    }

    @Override
    public PagingVO<ScpWhNetRelationPageVO> scpmanAuthorityPage(ScpWhNetRelationPageParamVO queryParam) {
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = this.getAuthorityPageRespVOPagingVO();
        if (scpManAuthorityPageRespVOPagingVO.isEmpty()) {
            return new PagingVO();
        }
        this.extractedAuthorityParam(queryParam, scpManAuthorityPageRespVOPagingVO);
        return this.page(queryParam);
    }

    @Override
    public Map<String, List<ScpWhNetRelationRpcDTO>> findWhNetByParam(String demandWhStCode, String type, List<ScpStoreCartDO> storeCartDOS) {
        HashMap<String, List<ScpWhNetRelationRpcDTO>> whNetRelationMap = new HashMap<String, List<ScpWhNetRelationRpcDTO>>();
        ScpWhNetRelationRpcDtoParam scpWhNetRelationRpcDtoParam = new ScpWhNetRelationRpcDtoParam();
        scpWhNetRelationRpcDtoParam.setType(type);
        scpWhNetRelationRpcDtoParam.setDemandWhStCode(demandWhStCode);
        List<ScpWhNetRelationRpcDTO> relationList = this.scpWhNetRelationRepoProc.findWhNetRelationRpcDtoByParam(scpWhNetRelationRpcDtoParam);
        for (ScpStoreCartDO cartDO : storeCartDOS) {
            List itemCodeResults = relationList.stream().filter(row -> cartDO.getItemCode().equals(row.getItemCode())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(itemCodeResults)) {
                whNetRelationMap.put(cartDO.getItemCode(), itemCodeResults);
                continue;
            }
            List itemCateCodeResults = relationList.stream().filter(row -> cartDO.getItemCateCode().equals(row.getItemCateCode()) && StrUtil.isBlank((CharSequence)row.getItemCode())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(itemCateCodeResults)) {
                whNetRelationMap.put(cartDO.getItemCode(), itemCateCodeResults);
                continue;
            }
            List resultList = relationList.stream().filter(row -> StrUtil.isBlank((CharSequence)row.getItemCateCode()) && StringUtils.isBlank((String)row.getItemCode())).collect(Collectors.toList());
            if (CollUtil.isEmpty(resultList)) continue;
            whNetRelationMap.put(cartDO.getItemCode(), resultList);
        }
        return whNetRelationMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return;
        }
        List whNetRelationDOS = this.scpWhNetRelationDomainService.findByIds(ids).stream().filter(row -> Boolean.TRUE.equals(row.getStatus())).collect(Collectors.toList());
        List itemCodeGroups = whNetRelationDOS.stream().filter(row -> StrUtil.isNotBlank((CharSequence)row.getItemCode())).collect(Collectors.toList());
        List itemCateCodeGroups = whNetRelationDOS.stream().filter(row -> StrUtil.isNotBlank((CharSequence)row.getItemCateCode()) && StrUtil.isBlank((CharSequence)row.getItemCode())).collect(Collectors.toList());
        List whGroups = whNetRelationDOS.stream().filter(row -> StrUtil.isBlank((CharSequence)row.getItemCode()) && StrUtil.isBlank((CharSequence)row.getItemCateCode())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(itemCodeGroups)) {
            Map<String, List<ScpWhNetRelationDO>> itemCodeMap = itemCodeGroups.stream().collect(Collectors.groupingBy(row -> row.getDemandWhStCode() + row.getItemCode()));
            itemCodeMap.forEach((k, v) -> {
                BigDecimal sumAlloc = v.stream().map(ScpWhNetRelationDO::getSupplyPercentage).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
                if (sumAlloc.compareTo(new BigDecimal("100")) != 0) {
                    ScpWhNetRelationDO scpWhNetRelationDO = (ScpWhNetRelationDO)v.get(0);
                    throw new BusinessException("\u95e8\u5e97/\u4ed3\u5e93\u3010" + scpWhNetRelationDO.getDemandWhStName() + "\u3011,\u5546\u54c1\u3010  " + scpWhNetRelationDO.getItemName() + "\u3011\u914d\u7f6e\u6bd4\u989d\u4e0d\u7b26\u5408\u767e\u5206\u4e4b\u767e");
                }
            });
        }
        if (CollUtil.isNotEmpty(itemCateCodeGroups)) {
            Map<String, List<ScpWhNetRelationDO>> itemCateCodeMap = itemCateCodeGroups.stream().collect(Collectors.groupingBy(row -> row.getDemandWhStCode() + row.getItemCateCode()));
            itemCateCodeMap.forEach((k, v) -> {
                BigDecimal sumAlloc = v.stream().map(ScpWhNetRelationDO::getSupplyPercentage).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
                if (sumAlloc.compareTo(new BigDecimal("100")) != 0) {
                    ScpWhNetRelationDO scpWhNetRelationDO = (ScpWhNetRelationDO)v.get(0);
                    throw new BusinessException("\u95e8\u5e97/\u4ed3\u5e93\u3010" + scpWhNetRelationDO.getDemandWhStName() + "\u3011,\u5546\u54c1\u5206\u7c7b\u3010  " + scpWhNetRelationDO.getItemCateName() + "\u3011\u914d\u7f6e\u6bd4\u989d\u4e0d\u7b26\u5408\u767e\u5206\u4e4b\u767e");
                }
            });
        }
        if (CollUtil.isNotEmpty(whGroups)) {
            Map<String, List<ScpWhNetRelationDO>> whMap = whGroups.stream().collect(Collectors.groupingBy(row -> row.getDemandWhStCode()));
            whMap.forEach((k, v) -> {
                BigDecimal sumAlloc = v.stream().map(ScpWhNetRelationDO::getSupplyPercentage).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
                if (sumAlloc.compareTo(new BigDecimal("100")) != 0) {
                    ScpWhNetRelationDO scpWhNetRelationDO = (ScpWhNetRelationDO)v.get(0);
                    throw new BusinessException("\u95e8\u5e97/\u4ed3\u5e93\u3010" + scpWhNetRelationDO.getDemandWhStName() + ",\u914d\u7f6e\u6bd4\u989d\u4e0d\u7b26\u5408\u767e\u5206\u4e4b\u767e");
                }
            });
        }
        this.scpWhNetRelationDomainService.deleteBatch(ids);
    }

    private void extractedAuthorityParam(ScpWhNetRelationPageParamVO queryParam, PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO) {
        List records = scpManAuthorityPageRespVOPagingVO.getRecords();
        List<Long> whIds = records.stream().filter(v -> 1 == v.getType()).map(ScpManAuthorityPageRespVO::getStWhId).filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> storeIds = records.stream().filter(v -> 0 == v.getType()).map(ScpManAuthorityPageRespVO::getStWhId).filter(Objects::nonNull).collect(Collectors.toList());
        queryParam.setWhIds(whIds);
        queryParam.setStoreIds(storeIds);
    }

    private PagingVO<ScpManAuthorityPageRespVO> getAuthorityPageRespVOPagingVO() {
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        scpManAuthorityParam.setLoginAccount(currentUserDTO.getDetail().getUsername());
        scpManAuthorityParam.setTypes(List.of(Integer.valueOf(1), Integer.valueOf(0)));
        scpManAuthorityParam.setEnableStatus(Boolean.TRUE);
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = this.scpDemandAuthorityService.queryAuthorit(scpManAuthorityParam);
        return scpManAuthorityPageRespVOPagingVO;
    }

    private List<String> validResult(List<String> errorList) {
        errorList.replaceAll(new UnaryOperator<String>(){

            @Override
            public String apply(String s) {
                if (StringUtils.isEmpty((String)s)) {
                    return "-";
                }
                return s;
            }
        });
        return errorList;
    }

    private List<String> getSuccessDocGroup(List<String> errorList, List<ScpWhNetRelationImportVO> dataList) {
        List<String> docGroupNo = dataList.stream().map(a -> a.getType() + a.getSupplyWhCode() + a.getDemandWhStCode() + a.getItemCode()).distinct().collect(Collectors.toList());
        for (int i = 0; i < dataList.size(); ++i) {
            ScpWhNetRelationImportVO entity = dataList.get(i);
            if (Objects.equals("-", errorList.get(i))) continue;
            docGroupNo.remove(entity.getType() + entity.getSupplyWhCode() + entity.getDemandWhStCode() + entity.getItemCode());
        }
        return docGroupNo;
    }

    private void checkImportParam(List<ScpWhNetRelationImportVO> dataList, List<String> errorList) {
        HashMap errorMap = new HashMap();
        Map typeMap = MapUtil.reverse((Map)this.systemService.getValueMapByUdcCode("yst-suplan", "DEMAND_SET_TYPE"));
        HashMap<CallSite, Integer> dumpMap = new HashMap<CallSite, Integer>();
        for (int i = 0; i < dataList.size(); ++i) {
            ScpWhNetRelationImportVO importEntity = dataList.get(i);
            int line = i + 1;
            importEntity.setLineNo(line);
            errorMap.put(importEntity.getLineNo(), new ArrayList());
            if (StringUtils.isEmpty((String)importEntity.getTypeName())) {
                ((List)errorMap.get(line)).add("\u5217[\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                String lineType = (String)typeMap.get(importEntity.getTypeName());
                if (StringUtils.isEmpty((String)lineType)) {
                    ((List)errorMap.get(importEntity.getLineNo())).add("\u5217[\u7c7b\u578b\u540d]" + importEntity.getTypeName() + " \u4e0d\u5b58\u5728");
                } else {
                    importEntity.setType(lineType);
                }
            }
            if (StringUtils.isEmpty((String)importEntity.getDemandWhStCode())) {
                ((List)errorMap.get(line)).add("\u5217[\u9700\u6c42\u4ed3\u5e93/\u95e8\u5e97\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)importEntity.getSupplyWhCode())) {
                ((List)errorMap.get(line)).add("\u5217[\u4f9b\u5e94\u4ed3\u5e93\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isNotEmpty((String)importEntity.getDemandWhStCode()) || !StringUtils.isNotEmpty((String)importEntity.getSupplyWhCode()) || !StringUtils.isNotEmpty((String)importEntity.getType())) continue;
            String key = importEntity.getDemandWhStCode() + this.setEmptyStringStr(importEntity.getItemCode()) + importEntity.getSupplyWhCode() + importEntity.getType();
            if (dumpMap.get(key) == null) {
                dumpMap.put((CallSite)((Object)key), line);
                continue;
            }
            ((List)errorMap.get(line)).add("\u9700\u6c42\u4ed3\u5e93[" + importEntity.getDemandWhStCode() + "],\u4f9b\u5e94\u4ed3\u5e93/\u95e8\u5e97[" + importEntity.getSupplyWhCode() + "],\u5546\u54c1 \u5b58\u5728\u76f8\u540c\u3010\u4f9b\u5e94\u5546\u4ed3-\u7c7b\u578b\u3011\u7ec4\u5408\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
        }
        for (Integer line : errorMap.keySet()) {
            errorList.add(String.join((CharSequence)",", (Iterable)errorMap.get(line)));
        }
    }

    public ScpWhNetRelationServiceImpl(ScpWhNetRelationDomainService scpWhNetRelationDomainService, ItmItemRpcService itmItemRpcService, UdcProvider udcProvider, ScpWhNetRelationRepoProc scpWhNetRelationRepoProc, UdcProvider systemService, InvWhProvider whProvider, OrgStoreRpcService orgStoreRpcService, ScpDemandAuthorityService scpDemandAuthorityService, RmiInvStkRpcService rmiInvStkService, SupportTransactionPathRpcService supportTransactionPathRpcService, RmiOrgStoreRpcService rmiOrgStoreRpcService, CrmCustRpcService crmCustRpcService, MessageQueueTemplate messageQueueTemplate) {
        this.scpWhNetRelationDomainService = scpWhNetRelationDomainService;
        this.itmItemRpcService = itmItemRpcService;
        this.udcProvider = udcProvider;
        this.scpWhNetRelationRepoProc = scpWhNetRelationRepoProc;
        this.systemService = systemService;
        this.whProvider = whProvider;
        this.orgStoreRpcService = orgStoreRpcService;
        this.scpDemandAuthorityService = scpDemandAuthorityService;
        this.rmiInvStkService = rmiInvStkService;
        this.supportTransactionPathRpcService = supportTransactionPathRpcService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.crmCustRpcService = crmCustRpcService;
        this.messageQueueTemplate = messageQueueTemplate;
    }
}

