package com.elitesland.scp.application.facade.vo.resp.calendar;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel("单据类型配置详情返回")
public class ScpStoreCalendarSetRespVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -7129845441661010333L;

    @ApiModelProperty("配置编码")
    private String setCode;

    @ApiModelProperty("配置名称")
    private String setName;

    @ApiModelProperty("配置描述")
    private String setDescription;

    @ApiModelProperty("起始年份")
    private Integer startYear;

    @ApiModelProperty("结束年份")
    private Integer endYear;

    @ApiModelProperty("单据状态【yst-suplan:CALENDAR_SET_STATUS】")
    @SysCode(sys = "yst-suplan", mod = "CALENDAR_SET_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("单据分类")
    private List<String> itemType2s;

    @ApiModelProperty(value = "单据分类")
    private String itemType2;
}
