package com.elitesland.scp.domain.entity.freight;

import com.el.coordinator.core.common.jpa.entiry.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

@Entity
@Table(name = "scp_store_order_freight")
@org.hibernate.annotations.Table(appliesTo = "scp_store_order_freight", comment = "门店订单运费")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "门店订单运费", description = "门店订单运费")
@Where(clause = "delete_flag = 0")
public class ScpStoreOrderFreightDO extends BaseModel implements Serializable {

    @ApiModelProperty("订货类型")
    @Comment("订货类型")
    @Column(name = "order_type", columnDefinition = "varchar(30) comment '订货类型'")
    private String orderType;

    @ApiModelProperty("运费收取方式")
    @Comment("运费收取方式")
    @Column(name = "freight_method", columnDefinition = "varchar(30) comment '运费收取方式'")
    private String freightMethod;

    @ApiModelProperty("仓库编码")
    @Comment("仓库编码")
    @Column(name = "wh_code", columnDefinition = "varchar(64) comment '仓库编码'")
    private String whCode;

    @ApiModelProperty("仓库名称")
    @Comment("仓库名称")
    @Column(name = "wh_name", columnDefinition = "varchar(40) comment '仓库名称'")
    private String whName;

    @ApiModelProperty("需求类型")
    @Comment("需求类型")
    @Column(name = "demand_type", columnDefinition = "varchar(30) comment '需求类型'")
    private String demandType;

    @ApiModelProperty("需求门店编码或'all'")
    @Comment("需求门店编码或'all'")
    @Column(name = "store_code", columnDefinition = "varchar(64) comment '需求门店编码或''all'''")
    private String storeCode;

    @ApiModelProperty("需求门店名称或'全部'")
    @Comment("需求门店名称或'全部'")
    @Column(name = "store_name", columnDefinition = "varchar(64) comment '需求门店名称或''全部'''")
    private String storeName;

    @ApiModelProperty("商品编码")
    @Comment("商品编码")
    @Column(name = "item_code", columnDefinition = "varchar(40) comment '商品编码'")
    private String itemCode;

    @ApiModelProperty("商品名称")
    @Comment("商品名称")
    @Column(name = "item_name", columnDefinition = "varchar(255) comment '商品名称'")
    private String itemName;

    @ApiModelProperty("商品品类")
    @Comment("商品品类")
    @Column(name = "item_category_code", columnDefinition = "varchar(64) comment '商品品类'")
    private String itemCategoryCode;

    @ApiModelProperty("运费收取比例")
    @Comment("运费收取比例")
    @Column(name = "freight_rate", columnDefinition = "float comment '运费收取比例'")
    private BigDecimal freightRate;

    @ApiModelProperty("按数量收取金额")
    @Comment("按数量收取金额")
    @Column(name = "amount_per_quantity", columnDefinition = "float comment '按数量收取金额'")
    private BigDecimal amountPerQuantity;

    @ApiModelProperty("状态，1:启用，0:禁用")
    @Comment("状态，1:启用，0:禁用")
    @Column(name = "status", columnDefinition = "tinyint(1) comment '状态，1:启用，0:禁用'")
    private Integer status;

}
