package com.elitesland.scp.application.web.wechat;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.service.wechat.WechatService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

@Slf4j
@Api(tags = "企业微信登录接口")
@RestController
@RequestMapping(value = "/wechat", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class WeChatLoginController {

    private final WechatService wechatService;

    /**
     * 企业微信内登录地址
     */
    @ApiOperation(value = "oauth2登录地址")
    @PostMapping(value = "/oauth2/url")
    public ApiResult<String> oauth2LoginUrl() {
        //获取企业微信内登录地址
        return ApiResult.ok(wechatService.oauth2LoginUrl());
    }

    @ApiOperation(value = "SSO登录地址")
    @PostMapping(value = "/sso/url")
    public ApiResult<String> ssoLoginUrl() {
        //获取企业微信内登录地址
        return ApiResult.ok(wechatService.webLoginUrl());
    }

    @ApiOperation(value = "企业微信回调")
    @GetMapping(value = "/redirect")
    public ApiResult<String> redirect(@RequestParam("code") String code, @RequestParam("state") String state) {
        log.info("企业微信回调code:{},state:{}", code, state);
        return ApiResult.ok(code);
    }

    @ApiOperation(value = "PC登录")
    @GetMapping(value = "/pc/login")
    public ApiResult<String> pcLogin(@RequestParam("code") String code) {
        log.info("企业微信PC登录code:{}", code, code);
        return ApiResult.ok(wechatService.pcLogin(code));
    }

    @ApiOperation(value = "小程序登录")
    @GetMapping(value = "/mg/login")
    public ApiResult<String> mgLogin(@RequestParam("code") String code) {
        log.info("企业微信小程序登录code:{}", code, code);
        return ApiResult.ok(wechatService.mgLogin(code));
    }

}
